/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.ProteinDomain;
import org.forester.util.ForesterUtil;

public class DomainArchitecture
implements PhylogenyData {
    public static final String NHX_SEPARATOR = ">";
    private static final BigDecimal INCREASE_KEY = new BigDecimal("0.00001");
    private SortedMap<BigDecimal, ProteinDomain> _domains;
    private int _total_length;

    public DomainArchitecture() {
        this.init();
    }

    public DomainArchitecture(List<PhylogenyData> list, int n) {
        this.init();
        for (PhylogenyData phylogenyData : list) {
            ProteinDomain proteinDomain = (ProteinDomain)phylogenyData;
            this.addDomain(proteinDomain);
        }
        this._total_length = n;
    }

    public DomainArchitecture(String string) {
        this.init();
        int n = 0;
        int n2 = -1;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, NHX_SEPARATOR);
            String string2 = (String)stringTokenizer.nextElement();
            n = Integer.parseInt(string2);
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                String string4 = (String)stringTokenizer.nextElement();
                String string5 = (String)stringTokenizer.nextElement();
                String string6 = (String)stringTokenizer.nextElement();
                n2 = Integer.parseInt(string4);
                int n3 = Integer.parseInt(string3);
                double d = Double.parseDouble(string5);
                ProteinDomain proteinDomain = new ProteinDomain(string6, n3, n2, d);
                this.addDomain(proteinDomain);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException("malformed format for domain structure \"" + string + "\": " + exception.getMessage());
        }
        if (n2 > n) {
            throw new IllegalArgumentException("total length of domain structure is too short");
        }
        this._total_length = n;
    }

    public void addDomain(ProteinDomain proteinDomain) {
        BigDecimal bigDecimal = new BigDecimal("" + proteinDomain.getFrom());
        while (this._domains.containsKey(bigDecimal)) {
            bigDecimal = new BigDecimal("" + (bigDecimal.doubleValue() + INCREASE_KEY.doubleValue()));
        }
        this._domains.put(bigDecimal, proteinDomain);
    }

    @Override
    public StringBuffer asSimpleText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getDomains().size(); ++i) {
            if (i > 0) {
                stringBuffer.append("~");
            }
            stringBuffer.append(this.getDomain(i).asSimpleText());
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer asText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getDomains().size(); ++i) {
            if (i > 0) {
                stringBuffer.append("~");
            }
            stringBuffer.append(this.getDomain(i).asText());
        }
        return stringBuffer;
    }

    @Override
    public PhylogenyData copy() {
        ArrayList<PhylogenyData> arrayList = new ArrayList<PhylogenyData>(this.getDomains().size());
        for (int i = 0; i < this.getDomains().size(); ++i) {
            arrayList.add(this.getDomain(i).copy());
        }
        return new DomainArchitecture(arrayList, this.getTotalLength());
    }

    public ProteinDomain getDomain(int n) {
        return (ProteinDomain)this._domains.values().toArray()[n];
    }

    public SortedMap<BigDecimal, ProteinDomain> getDomains() {
        return this._domains;
    }

    public int getNumberOfDomains() {
        return this._domains.size();
    }

    public int getTotalLength() {
        return this._total_length;
    }

    private void init() {
        this._domains = new TreeMap<BigDecimal, ProteinDomain>();
        this._total_length = 0;
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        if (phylogenyData == null) {
            return false;
        }
        if (!(phylogenyData instanceof DomainArchitecture)) {
            return false;
        }
        DomainArchitecture domainArchitecture = (DomainArchitecture)phylogenyData;
        if (this.getDomains().size() != domainArchitecture.getDomains().size()) {
            return false;
        }
        for (int i = 0; i < this.getDomains().size(); ++i) {
            if (this.getDomain(i).getName().equals(domainArchitecture.getDomain(i).getName())) continue;
            return false;
        }
        return true;
    }

    public void setTotalLength(int n) {
        this._total_length = n;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(":");
        stringBuffer.append("DS=");
        stringBuffer.append(this.getTotalLength());
        if (this.getDomains() != null) {
            for (int i = 0; i < this.getDomains().size(); ++i) {
                stringBuffer.append(NHX_SEPARATOR);
                stringBuffer.append(this.getDomain(i).getFrom());
                stringBuffer.append(NHX_SEPARATOR);
                stringBuffer.append(this.getDomain(i).getTo());
                stringBuffer.append(NHX_SEPARATOR);
                stringBuffer.append(this.getDomain(i).getConfidence());
                stringBuffer.append(NHX_SEPARATOR);
                stringBuffer.append(ForesterUtil.replaceIllegalNhxCharacters(this.getDomain(i).getName()));
            }
        }
        return stringBuffer;
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendOpen(writer, "domain_architecture", "length", this.getTotalLength() + "");
        if (this.getDomains() != null) {
            String string2 = string + "  ";
            for (int i = 0; i < this.getDomains().size(); ++i) {
                this.getDomain(i).toPhyloXML(writer, n, string2);
            }
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendClose(writer, "domain_architecture");
    }

    public String toString() {
        return this.asText().toString();
    }
}

