/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class ProteinDomain
implements PhylogenyData {
    public static final double CONFIDENCE_DEFAULT = -1.0;
    public static final String IDENTIFIER_DEFAULT = "";
    private final String _name;
    private final int _from;
    private final int _to;
    private final String _id;
    private final double _confidence;

    public ProteinDomain(String string, int n, int n2) {
        this(string, n, n2, IDENTIFIER_DEFAULT, -1.0);
    }

    public ProteinDomain(String string, int n, int n2, double d) {
        this(string, n, n2, IDENTIFIER_DEFAULT, d);
    }

    public ProteinDomain(String string, int n, int n2, String string2) {
        this(string, n, n2, string2, -1.0);
    }

    public ProteinDomain(String string, int n, int n2, String string2, double d) {
        if (n >= n2 || n2 < 0) {
            throw new IllegalArgumentException("attempt to create protein domain from " + n + " to " + n2);
        }
        this._name = string;
        this._from = n;
        this._to = n2;
        this._id = string2;
        this._confidence = d;
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getName());
    }

    @Override
    public StringBuffer asText() {
        StringBuffer stringBuffer = new StringBuffer(this.getName());
        stringBuffer.append(" [");
        stringBuffer.append(this.getLength());
        if (!ForesterUtil.isEmpty(this.getId())) {
            stringBuffer.append(" ");
            stringBuffer.append(this.getId());
        }
        if (this.getConfidence() >= 0.0) {
            stringBuffer.append(" ");
            stringBuffer.append(this.getConfidence());
        }
        stringBuffer.append("]");
        return stringBuffer;
    }

    @Override
    public PhylogenyData copy() {
        if (this.getId() == null) {
            return new ProteinDomain(this.getName(), this.getFrom(), this.getTo(), this.getConfidence());
        }
        return new ProteinDomain(this.getName(), this.getFrom(), this.getTo(), this.getId(), this.getConfidence());
    }

    public double getConfidence() {
        return this._confidence;
    }

    public int getFrom() {
        return this._from;
    }

    public String getId() {
        return this._id;
    }

    public int getLength() {
        return this.getTo() - this.getFrom() + 1;
    }

    public String getName() {
        return this._name;
    }

    public int getTo() {
        return this._to;
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        if (phylogenyData == null) {
            return false;
        }
        if (!(phylogenyData instanceof ProteinDomain)) {
            return false;
        }
        if (((ProteinDomain)phylogenyData).getLength() != this.getLength()) {
            return false;
        }
        return ((ProteinDomain)phylogenyData).getName().equals(this.getName());
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        if (this.getId() != null) {
            PhylogenyDataUtil.appendOpen(writer, "domain", "from", this.getFrom() + IDENTIFIER_DEFAULT, "to", this.getTo() + IDENTIFIER_DEFAULT, "confidence", this.getConfidence() + IDENTIFIER_DEFAULT, "id", this.getId());
        } else {
            PhylogenyDataUtil.appendOpen(writer, "domain", "from", this.getFrom() + IDENTIFIER_DEFAULT, "to", this.getTo() + IDENTIFIER_DEFAULT, "confidence", this.getConfidence() + IDENTIFIER_DEFAULT);
        }
        writer.write(this.getName());
        PhylogenyDataUtil.appendClose(writer, "domain");
    }

    public String toString() {
        return this.asText().toString();
    }
}

