/*
 * Decompiled with CFR 0.152.
 */
package org.forester.protein;

import java.util.HashMap;
import java.util.Map;
import org.forester.protein.Domain;
import org.forester.util.ForesterUtil;

public class BasicDomain
implements Domain {
    private static short COUNT = 0;
    private static final Map<Short, String> ID_TO_STRING = new HashMap<Short, String>();
    private static final Map<String, Short> STRING_TO_ID = new HashMap<String, Short>();
    private final int _from;
    private final short _id;
    private final short _number;
    private final double _per_domain_evalue;
    private final double _per_domain_score;
    private final int _to;
    private final short _total_count;
    private final short _hmm_len;
    private final short _hmm_from;
    private final short _hmm_to;

    public BasicDomain(String string) {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("attempt to create protein domain with null or empty id");
        }
        this._id = BasicDomain.obtainIdAsShort(string);
        this._from = -1;
        this._to = -1;
        this._number = (short)-1;
        this._total_count = (short)-1;
        this._per_domain_evalue = -1.0;
        this._per_domain_score = -1.0;
        this._hmm_len = (short)-1;
        this._hmm_from = (short)-1;
        this._hmm_to = (short)-1;
    }

    public BasicDomain(String string, int n, int n2, short s, short s2, double d, double d2) {
        if (n >= n2 || n < 0) {
            throw new IllegalArgumentException("attempt to create protein domain from " + n + " to " + n2);
        }
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("attempt to create protein domain with null or empty id");
        }
        if (s > s2 || s < 0) {
            throw new IllegalArgumentException("attempt to create protein domain number " + s + " out of " + s2);
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("attempt to create protein domain with negative E-value");
        }
        this._id = BasicDomain.obtainIdAsShort(string);
        this._from = n;
        this._to = n2;
        this._number = s;
        this._total_count = s2;
        this._per_domain_evalue = d;
        this._per_domain_score = d2;
        this._hmm_len = (short)-1;
        this._hmm_from = (short)-1;
        this._hmm_to = (short)-1;
    }

    public BasicDomain(String string, int n, int n2, short s, short s2, double d, double d2, short s3, short s4, short s5) {
        if (n >= n2 || n < 0) {
            throw new IllegalArgumentException("attempt to create protein domain from " + n + " to " + n2);
        }
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("attempt to create protein domain with null or empty id");
        }
        if (s > s2 || s < 0) {
            throw new IllegalArgumentException("attempt to create protein domain number " + s + " out of " + s2);
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("attempt to create protein domain with negative E-value");
        }
        if (s4 >= s5 || s4 < 0) {
            throw new IllegalArgumentException("attempt to create protein domain matching hmm from " + n + " to " + n2);
        }
        if (s3 <= 0) {
            throw new IllegalArgumentException("attempt to create protein domain with zero or negative hmm length");
        }
        this._id = BasicDomain.obtainIdAsShort(string);
        this._from = n;
        this._to = n2;
        this._number = s;
        this._total_count = s2;
        this._per_domain_evalue = d;
        this._per_domain_score = d2;
        this._hmm_len = s3;
        this._hmm_from = s4;
        this._hmm_to = s5;
    }

    @Override
    public int compareTo(Domain domain) {
        if (domain.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to compare [" + domain.getClass() + "] to [" + this.getClass() + "]");
        }
        if (this == domain) {
            return 0;
        }
        return this.getDomainId().compareTo(domain.getDomainId());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to null");
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + object + " [" + object.getClass() + "]");
        }
        return this.getDomainId().equals(((Domain)object).getDomainId());
    }

    @Override
    public String getDomainId() {
        return BasicDomain.obtainIdFromShort(this._id);
    }

    @Override
    public int getFrom() {
        return this._from;
    }

    @Override
    public int getLength() {
        return 1 + this.getTo() - this.getFrom();
    }

    @Override
    public short getNumber() {
        return this._number;
    }

    @Override
    public double getPerDomainEvalue() {
        return this._per_domain_evalue;
    }

    @Override
    public double getPerDomainScore() {
        return this._per_domain_score;
    }

    @Override
    public int getTo() {
        return this._to;
    }

    @Override
    public short getTotalCount() {
        return this._total_count;
    }

    @Override
    public final short getHmmLen() {
        return this._hmm_len;
    }

    @Override
    public final short getHmmFrom() {
        return this._hmm_from;
    }

    @Override
    public final short getHmmTo() {
        return this._hmm_to;
    }

    public int hashCode() {
        return this.getDomainId().hashCode();
    }

    public String toString() {
        return this.getDomainId();
    }

    public StringBuffer toStringBuffer() {
        return new StringBuffer(this.getDomainId());
    }

    public static final short obtainIdAsShort(String string) {
        if (!STRING_TO_ID.containsKey(string)) {
            if (COUNT >= 32765) {
                throw new RuntimeException("too many domain ids!");
            }
            ID_TO_STRING.put(COUNT, string);
            STRING_TO_ID.put(string, COUNT);
            COUNT = (short)(COUNT + 1);
        }
        return STRING_TO_ID.get(string);
    }

    public static final String obtainIdFromShort(short s) {
        return ID_TO_STRING.get(s);
    }
}

