/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.surfacing.SurfacingConstants;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.ForesterUtil;
import org.forester.ws.seqdb.UniprotData;
import org.forester.ws.seqdb.UniprotRetrieve;

public final class DaioMethods {
    private static final int VERBOSITY = 1;
    private static final int MAX_IDS_TO_SEARCH_PER_SPECIES = 10;
    private static final String NA_SYMBOL = "-";
    private static final Pattern MULTIPLE_NAME_PATTERN = Pattern.compile("(.+)\\s\\[(\\d+)\\]");
    private static final Pattern ORF_NAME_PATTERN = Pattern.compile("orf\\s*(.+)", 2);
    private static final Pattern ORF_PROTEIN_NAME_PATTERN = Pattern.compile("orf\\s*(.+)\\s+protein", 2);

    /*
     * WARNING - void declaration
     */
    public static final String inferTaxonomicInformation(Phylogeny phylogeny, List<String> list) throws IOException {
        void var5_21;
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        for (String object2 : list) {
            PhylogenyNode phylogenyNode = phylogeny.getNodeViaTaxonomyCode(object2);
            arrayList.add(phylogenyNode);
        }
        Object object3 = null;
        for (PhylogenyNode phylogenyNode : arrayList) {
            PhylogenyNode phylogenyNode2 = PhylogenyMethods.calculateLCA((PhylogenyNode)arrayList.get(0), phylogenyNode);
            if (object3 != null && phylogenyNode2.calculateDepth() >= ((PhylogenyNode)object3).calculateDepth()) continue;
            object3 = phylogenyNode2;
        }
        if (((PhylogenyNode)object3).getAllExternalDescendants().size() == list.size()) {
            boolean bl = true;
        } else if (((PhylogenyNode)object3).getAllExternalDescendants().size() > list.size()) {
            boolean bl = false;
        } else {
            throw new IllegalStateException("this should never have happened");
        }
        Object var5_12 = null;
        if (((PhylogenyNode)object3).isExternal()) {
            String string = "species_specific";
        } else {
            void var4_8;
            void var5_18;
            void var5_16;
            if (((PhylogenyNode)object3).isHasNodeData() && ((PhylogenyNode)object3).getNodeData().isHasTaxonomy()) {
                if (!ForesterUtil.isEmpty(((PhylogenyNode)object3).getNodeData().getTaxonomy().getSynonyms()) && !ForesterUtil.isEmptyTrimmed(((PhylogenyNode)object3).getNodeData().getTaxonomy().getSynonyms().get(0))) {
                    String string = ((PhylogenyNode)object3).getNodeData().getTaxonomy().getSynonyms().get(0);
                } else if (!ForesterUtil.isEmptyTrimmed(((PhylogenyNode)object3).getNodeData().getTaxonomy().getScientificName())) {
                    String string = ((PhylogenyNode)object3).getNodeData().getTaxonomy().getScientificName();
                }
            }
            if (ForesterUtil.isEmptyTrimmed((String)var5_16) && !ForesterUtil.isEmptyTrimmed(((PhylogenyNode)object3).getName())) {
                String string = ((PhylogenyNode)object3).getName();
            }
            if (ForesterUtil.isEmptyTrimmed((String)var5_18)) {
                throw new IllegalArgumentException("found LCA in species tree without (1) taxonomy synonym (preferred), (2) taxonomy scientific name, and (3) node name");
            }
            if (var4_8 != false) {
                String string = var5_18.toUpperCase();
            } else {
                String string = var5_18.toLowerCase();
            }
        }
        return var5_21;
    }

    public static final String processOrfNames(String string) {
        Matcher matcher = ORF_PROTEIN_NAME_PATTERN.matcher(string);
        Matcher matcher2 = ORF_NAME_PATTERN.matcher(string);
        if (matcher.matches()) {
            string = "ORF " + matcher.group(1) + " protein";
        } else if (matcher2.matches()) {
            string = "ORF " + matcher2.group(1) + " protein";
        }
        return string;
    }

    public static final String[] obtainName(String string, SortedMap<String, SortedSet<String>> sortedMap, int n, int n2) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (Map.Entry<String, SortedSet<String>> entry : sortedMap.entrySet()) {
            SortedSet<String> sortedSet = entry.getValue();
            if (sortedSet.size() <= 0) continue;
            int n3 = 0;
            for (String string2 : sortedSet) {
                arrayList.add(string2);
                if (++n3 <= n) continue;
                continue block0;
            }
        }
        return DaioMethods.accessUniprot(arrayList, n2);
    }

    public static final void outputSpeciesAndIdsPerDAs(SortedMap<String, SortedMap<String, SortedSet<String>>> sortedMap, Phylogeny phylogeny, Writer writer, String string, String string2, boolean bl, File file, Writer writer2) throws IOException {
        SortedMap<String, String> sortedMap2;
        HashSet<Object> hashSet = new HashSet<Object>();
        if (file != null) {
            BasicTable<String> basicTable = BasicTableParser.parse(file, '\t');
            sortedMap2 = basicTable.getColumnsAsMap(0, 1);
        } else {
            sortedMap2 = null;
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            Object object;
            Object object2;
            String string3 = (String)entry.getKey();
            SortedMap sortedMap3 = (SortedMap)entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = sortedMap3.entrySet().iterator();
            String string4 = null;
            Object object3 = "";
            Object object4 = "";
            System.out.println();
            System.out.println("DA " + string3 + ":");
            if (sortedMap2 != null && sortedMap2.containsKey(string3)) {
                string4 = (String)sortedMap2.get(string3);
                System.out.println("  [from file] " + string4);
            }
            if ((ForesterUtil.isEmptyTrimmed(string4) || string4.equals(NA_SYMBOL)) && bl) {
                object2 = DaioMethods.obtainName(string3, sortedMap3, 10, 1);
                if (object2 != null) {
                    string4 = object2[0];
                    object3 = object2[1];
                    object4 = object2[2];
                } else {
                    string4 = null;
                }
            }
            if (!ForesterUtil.isEmpty(string4) && !string4.equals(NA_SYMBOL)) {
                object2 = (string4 = DaioMethods.processOrfNames(string4)).toLowerCase();
                if (hashSet.contains(object2)) {
                    while (hashSet.contains(object2)) {
                        object = MULTIPLE_NAME_PATTERN.matcher(string4);
                        if (((Matcher)object).matches()) {
                            int n = 1 + Integer.parseInt(((Matcher)object).group(2));
                            string4 = ((Matcher)object).group(1) + " [" + n + "]";
                        } else {
                            string4 = string4 + " [2]";
                        }
                        object2 = string4.toLowerCase();
                    }
                    System.out.println("   -> " + string4);
                }
                hashSet.add(object2);
            }
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object = (SortedSet)object2.getValue();
                if (object.size() <= 0) continue;
                String string5 = (String)object2.getKey();
                arrayList.add(string5);
            }
            object2 = sortedMap3.entrySet().iterator();
            writer2.write(string3);
            writer2.write("\t");
            if (!ForesterUtil.isEmpty(string4)) {
                writer2.write(string4);
                writer2.write("\t");
                writer2.write((String)object3);
                writer2.write("\t");
                writer2.write((String)object4);
            } else {
                writer2.write(NA_SYMBOL);
                writer2.write("\t");
                writer2.write("0");
                writer2.write("\t");
                writer2.write("0");
            }
            writer2.write(SurfacingConstants.NL);
            writer2.flush();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                String string6 = (String)object.getKey();
                SortedSet sortedSet = (SortedSet)object.getValue();
                if (sortedSet.size() > 0) {
                    String string7 = DaioMethods.inferTaxonomicInformation(phylogeny, arrayList);
                    writer.write(string3);
                    writer.write(string);
                    if (!ForesterUtil.isEmpty(string4)) {
                        writer.write(string4);
                    } else {
                        writer.write(NA_SYMBOL);
                    }
                    writer.write("_");
                    writer.write(string7);
                    writer.write(string);
                    writer.write(string6);
                    writer.write(string);
                    boolean bl2 = true;
                    for (String string8 : sortedSet) {
                        if (bl2) {
                            bl2 = false;
                        } else {
                            writer.write(string2);
                        }
                        writer.write(string8);
                    }
                    writer.write(SurfacingConstants.NL);
                }
                writer.flush();
            }
        }
        writer.flush();
        writer2.flush();
    }

    private static String[] accessUniprot(List<String> list, int n) throws IOException {
        Optional<Map.Entry> optional;
        UniprotRetrieve uniprotRetrieve = new UniprotRetrieve(false);
        SortedMap<String, UniprotData> sortedMap = uniprotRetrieve.retrieve(list);
        Iterator<Map.Entry<String, UniprotData>> iterator = sortedMap.entrySet().iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string2;
            String string3;
            int n2;
            optional = iterator.next();
            if (n > 1) {
                System.out.println("    " + (String)optional.getKey() + " => " + ((UniprotData)optional.getValue()).getProteinNames());
            }
            if ((n2 = (string3 = optional.getValue().getProteinNames()).indexOf(" (")) > 0) {
                string3 = string3.substring(0, n2);
            }
            if ((string2 = string3.toLowerCase()).startsWith("uncharacterized")) continue;
            arrayList.add(string3);
        }
        optional = arrayList.stream().collect(Collectors.groupingBy(string -> string, Collectors.counting())).entrySet().stream().max(Comparator.comparing(Map.Entry::getValue));
        if (optional.isPresent()) {
            if (n > 0) {
                System.out.println("  [" + ((Map.Entry)optional.get()).getValue() + "/" + arrayList.size() + "] " + (String)((Map.Entry)optional.get()).getKey());
            }
            return new String[]{(String)((Map.Entry)optional.get()).getKey(), String.valueOf(((Map.Entry)optional.get()).getValue()), String.valueOf(arrayList.size())};
        }
        if (n > 0) {
            System.out.println("  n/a");
        }
        return null;
    }
}

