/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.seqdb;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.go.GoTerm;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.sequence.MolecularSequence;
import org.forester.util.ForesterUtil;
import org.forester.ws.seqdb.SequenceDatabaseEntry;
import org.forester.ws.seqdb.SequenceDbWsTools;

public final class EbiDbEntry
implements SequenceDatabaseEntry {
    private static final boolean DEBUG = false;
    private static final Pattern LETTERS_PATTERN = Pattern.compile("^[A-Z]+");
    private static final Pattern chromosome_PATTERN = Pattern.compile("\\s+/chromosome=\"(\\w+)\"");
    private static final Pattern map_PATTERN = Pattern.compile("\\s+/map=\"([\\w\\.]+)\"");
    private static final Pattern gene_PATTERN = Pattern.compile("\\s+/gene=\"(.+)\"");
    private static final Pattern mim_PATTERN = Pattern.compile("\\s+/db_xref=\"MIM:(\\d+)\"");
    private static final Pattern taxon_PATTERN = Pattern.compile("\\s+/db_xref=\"taxon:(\\d+)\"");
    private static final Pattern interpro_PATTERN = Pattern.compile("\\s+/db_xref=\"InterPro:([A-Z0-9]+)\"");
    private static final Pattern uniprot_PATTERN = Pattern.compile("\\s+/db_xref=\"UniProtKB/[A-Za-z-]*:(\\w+)\"");
    private static final Pattern hgnc_PATTERN = Pattern.compile("\\s+/db_xref=\"[A-Z:]*HGNC:(\\d+)\"");
    private static final Pattern geneid_PATTERN = Pattern.compile("\\s+/db_xref=\"GeneID:(\\d+)\"");
    private static final Pattern pdb_PATTERN = Pattern.compile("\\s+/db_xref=\"PDB:([A-Z0-9]+)\"");
    private static final Pattern ec_PATTERN = Pattern.compile("\\s+/EC_number=\"([\\.\\-\\d]+)\"");
    private static final Pattern product_PATTERN = Pattern.compile("\\s+/product=\"(\\w{1,10})\"");
    private SortedSet<Annotation> _annotations;
    private String _chromosome;
    private SortedSet<Accession> _cross_references;
    private String _de;
    private String _gene_name;
    private String _map;
    private String _os;
    private String _pa;
    private String _provider;
    private String _symbol;
    private String _tax_id;

    private EbiDbEntry() {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public String getAccession() {
        return this._pa;
    }

    @Override
    public SortedSet<Annotation> getAnnotations() {
        return this._annotations;
    }

    @Override
    public String getChromosome() {
        return this._chromosome;
    }

    @Override
    public SortedSet<Accession> getCrossReferences() {
        return this._cross_references;
    }

    @Override
    public String getGeneName() {
        return this._gene_name;
    }

    @Override
    public SortedSet<GoTerm> getGoTerms() {
        return null;
    }

    @Override
    public String getMap() {
        return this._map;
    }

    @Override
    public String getProvider() {
        return this._provider;
    }

    @Override
    public String getSequenceName() {
        return this._de;
    }

    @Override
    public String getSequenceSymbol() {
        return this._symbol;
    }

    @Override
    public String getTaxonomyIdentifier() {
        return this._tax_id;
    }

    @Override
    public String getTaxonomyScientificName() {
        return this._os;
    }

    @Override
    public boolean isEmpty() {
        return ForesterUtil.isEmpty(this.getAccession()) && ForesterUtil.isEmpty(this.getSequenceName()) && ForesterUtil.isEmpty(this.getTaxonomyScientificName()) && ForesterUtil.isEmpty(this.getTaxonomyIdentifier()) && ForesterUtil.isEmpty(this.getSequenceSymbol());
    }

    @Override
    public MolecularSequence getMolecularSequence() {
        return null;
    }

    private void addAnnotation(Annotation annotation) {
        if (this._annotations == null) {
            this._annotations = new TreeSet<Annotation>();
        }
        this._annotations.add(annotation);
    }

    private void addCrossReference(Accession accession) {
        if (this._cross_references == null) {
            this._cross_references = new TreeSet<Accession>();
        }
        this._cross_references.add(accession);
    }

    private void setAccession(String string) {
        if (this._pa == null) {
            this._pa = string;
        }
    }

    private void setChromosome(String string) {
        this._chromosome = string;
    }

    private void setGeneName(String string) {
        if (this._gene_name == null) {
            this._gene_name = string;
        }
    }

    private void setMap(String string) {
        this._map = string;
    }

    private void setSequenceName(String string) {
        if (this._de == null) {
            this._de = string;
        }
    }

    private void setSequenceSymbol(String string) {
        this._symbol = string;
    }

    private void setTaxId(String string) {
        if (this._tax_id == null) {
            this._tax_id = string;
        }
    }

    private void setTaxonomyScientificName(String string) {
        if (this._os == null) {
            this._os = string;
        }
    }

    private static void append(StringBuilder stringBuilder, String string) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(string.trim());
    }

    public static final SequenceDatabaseEntry createInstance(List<String> list) {
        EbiDbEntry ebiDbEntry = new EbiDbEntry();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        for (String string : list) {
            Matcher matcher;
            Matcher matcher2;
            Matcher matcher3;
            Matcher matcher4;
            Matcher matcher5;
            Matcher matcher6;
            if (string.startsWith("ACCESSION ")) {
                ebiDbEntry.setAccession(SequenceDbWsTools.extractFrom(string, "ACCESSION"));
                bl = false;
            } else if (string.startsWith("ID ")) {
                ebiDbEntry.setAccession(SequenceDbWsTools.extractFromTo(string, "ID", ";"));
                bl = false;
            } else if (string.startsWith("DEFINITION ") || string.startsWith("DE ")) {
                boolean bl8 = false;
                if (string.startsWith("DEFINITION ")) {
                    bl8 = true;
                }
                if (string.indexOf("[") > 0) {
                    if (bl8) {
                        EbiDbEntry.append(stringBuilder, SequenceDbWsTools.extractFromTo(string, "DEFINITION", "["));
                    } else {
                        EbiDbEntry.append(stringBuilder, SequenceDbWsTools.extractFromTo(string, "DE", "["));
                    }
                } else if (string.indexOf(".") > 0) {
                    if (bl8) {
                        EbiDbEntry.append(stringBuilder, SequenceDbWsTools.extractFromTo(string, "DEFINITION", "."));
                    } else {
                        EbiDbEntry.append(stringBuilder, SequenceDbWsTools.extractFromTo(string, "DE", "."));
                    }
                } else if (bl8) {
                    EbiDbEntry.append(stringBuilder, SequenceDbWsTools.extractFrom(string, "DEFINITION"));
                } else {
                    EbiDbEntry.append(stringBuilder, SequenceDbWsTools.extractFrom(string, "DE"));
                }
                if (bl8) {
                    bl = true;
                }
            } else if (string.startsWith("  ORGANISM ")) {
                if (string.indexOf("(") > 0) {
                    ebiDbEntry.setTaxonomyScientificName(SequenceDbWsTools.extractFromTo(string, "  ORGANISM", "("));
                } else {
                    ebiDbEntry.setTaxonomyScientificName(SequenceDbWsTools.extractFrom(string, "  ORGANISM"));
                }
            } else if (string.startsWith("OS ")) {
                if (string.indexOf("(") > 0) {
                    ebiDbEntry.setTaxonomyScientificName(SequenceDbWsTools.extractFromTo(string, "OS", "("));
                } else {
                    ebiDbEntry.setTaxonomyScientificName(SequenceDbWsTools.extractFrom(string, "OS"));
                }
            } else if (string.startsWith(" ") && bl) {
                stringBuilder.append(" ");
                if (string.indexOf("[") > 0) {
                    stringBuilder.append(SequenceDbWsTools.extractTo(string, "["));
                } else if (string.indexOf(".") > 0) {
                    stringBuilder.append(SequenceDbWsTools.extractTo(string, "."));
                } else {
                    stringBuilder.append(string.trim());
                }
            } else {
                bl = false;
            }
            if (!string.startsWith("FT ") && LETTERS_PATTERN.matcher(string).find()) {
                bl2 = false;
                bl3 = false;
                bl4 = false;
                bl5 = false;
                bl6 = false;
                bl7 = false;
            }
            if (string.startsWith("FEATURES ") || string.startsWith("FT ")) {
                bl2 = true;
            }
            if (bl2 && (string.startsWith("     source ") || string.startsWith("FT   source "))) {
                bl3 = true;
                bl4 = false;
                bl5 = false;
                bl6 = false;
                bl7 = false;
            }
            if (bl2 && (string.startsWith("     gene ") || string.startsWith("FT   gene "))) {
                bl3 = false;
                bl4 = true;
                bl5 = false;
                bl6 = false;
                bl7 = false;
            }
            if (bl2 && (string.startsWith("     CDS ") || string.startsWith("FT   CDS "))) {
                bl3 = false;
                bl4 = false;
                bl5 = true;
                bl6 = false;
                bl7 = false;
            }
            if (bl2 && (string.startsWith("     Protein ") || string.startsWith("FT   Protein "))) {
                bl3 = false;
                bl4 = false;
                bl5 = false;
                bl6 = false;
                bl7 = true;
            }
            if (bl2 && (string.startsWith("     mRNA ") || string.startsWith("FT   mRNA "))) {
                bl3 = false;
                bl4 = false;
                bl5 = false;
                bl6 = true;
                bl7 = false;
            }
            if (bl3) {
                Matcher matcher7 = taxon_PATTERN.matcher(string);
                if (matcher7.find()) {
                    ebiDbEntry.setTaxId(matcher7.group(1));
                }
                if ((matcher6 = chromosome_PATTERN.matcher(string)).find()) {
                    ebiDbEntry.setChromosome(matcher6.group(1));
                }
                if ((matcher5 = map_PATTERN.matcher(string)).find()) {
                    ebiDbEntry.setMap(matcher5.group(1));
                }
            }
            if (bl5 || bl4) {
                Matcher matcher8 = hgnc_PATTERN.matcher(string);
                if (matcher8.find()) {
                    ebiDbEntry.addCrossReference(new Accession(matcher8.group(1), "hgnc"));
                }
                if ((matcher6 = geneid_PATTERN.matcher(string)).find()) {
                    ebiDbEntry.addCrossReference(new Accession(matcher6.group(1), "geneid"));
                }
            }
            if (!bl7 && !bl5 && !bl4 && !bl6) continue;
            Matcher matcher9 = ec_PATTERN.matcher(string);
            if (matcher9.find()) {
                ebiDbEntry.addAnnotation(new Annotation("EC", matcher9.group(1)));
            }
            if ((matcher6 = gene_PATTERN.matcher(string)).find()) {
                ebiDbEntry.setGeneName(matcher6.group(1));
            }
            if ((matcher5 = uniprot_PATTERN.matcher(string)).find()) {
                ebiDbEntry.addCrossReference(new Accession(matcher5.group(1), "uniprot"));
            }
            if ((matcher4 = interpro_PATTERN.matcher(string)).find()) {
                ebiDbEntry.addCrossReference(new Accession(matcher4.group(1), "interpro"));
            }
            if ((matcher3 = mim_PATTERN.matcher(string)).find()) {
                ebiDbEntry.addCrossReference(new Accession(matcher3.group(1), "mim"));
            }
            if ((matcher2 = product_PATTERN.matcher(string)).find()) {
                ebiDbEntry.setSequenceSymbol(matcher2.group(1));
            }
            if (!(matcher = pdb_PATTERN.matcher(string)).find()) continue;
            ebiDbEntry.addCrossReference(new Accession(matcher.group(1), "pdb"));
        }
        if (stringBuilder.length() > 0) {
            ebiDbEntry.setSequenceName(stringBuilder.toString().trim());
        }
        return ebiDbEntry;
    }
}

