/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.filechooser;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.tiff.TIFFDecodeParam;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.tiff.TIFFImageDecoder;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.util.ImageDecodeParam;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.util.MemoryCacheSeekableStream;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.AccessControlException;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Files {
    public static final int FILE_TYPE_ALIAS = 2;
    public static final int FILE_TYPE_DIRECTORY = 1;
    public static final int FILE_TYPE_FILE = 0;
    public static final int FILE_TYPE_UNKOWN = -1;
    private static final Color[][] labelColors;
    private static final boolean isNativeCodeAvailable;

    private Files() {
    }

    public static File getAbsoluteFile(File f) {
        if (!f.isAbsolute()) {
            f = new File(QuaquaManager.getProperty("user.home") + File.separatorChar + f.getPath());
        }
        if (File.separatorChar == '\\') {
            return f;
        }
        StringBuffer buf = new StringBuffer(f.getPath().length());
        int skip = 0;
        for (File i = f; i != null; i = i.getParentFile()) {
            String name = i.getName();
            if (name.equals(".")) {
                if (skip <= 0) continue;
                --skip;
                continue;
            }
            if (name.equals("..")) {
                ++skip;
                continue;
            }
            if (skip > 0) {
                --skip;
                continue;
            }
            buf.insert(0, name);
            buf.insert(0, File.separatorChar);
        }
        return f.getPath().equals(buf.toString()) ? f : new File(buf.toString());
    }

    public static boolean canWorkWithAliases() {
        return isNativeCodeAvailable;
    }

    public static int getFileType(File f) {
        if (isNativeCodeAvailable) {
            return Files.getFileType(f.getPath());
        }
        return f.isDirectory() ? 1 : (f.isFile() ? 0 : -1);
    }

    public static File resolveAlias(File alias, boolean noUI) {
        if (isNativeCodeAvailable) {
            String path = Files.resolveAlias(alias.getPath(), noUI);
            return path == null ? null : new File(path);
        }
        return alias;
    }

    public static int resolveAliasType(File alias, boolean noUI) {
        if (isNativeCodeAvailable) {
            return Files.resolveAliasType(alias.getPath(), noUI);
        }
        return alias.isFile() ? 0 : (alias.isDirectory() ? 1 : -1);
    }

    public static byte[] toSerializedAlias(File f) {
        if (isNativeCodeAvailable) {
            return Files.toSerializedAlias(f.getPath());
        }
        return null;
    }

    public static File resolveAlias(byte[] serializedAlias, boolean noUI) {
        if (isNativeCodeAvailable) {
            String path = Files.jniResolveAlias(serializedAlias, noUI);
            return path == null ? null : new File(path);
        }
        return null;
    }

    public static int resolveAliasType(byte[] serializedAlias, boolean noUI) {
        if (isNativeCodeAvailable) {
            return Files.jniResolveAliasType(serializedAlias, noUI);
        }
        return -1;
    }

    public static boolean canWorkWithLabels() {
        return isNativeCodeAvailable;
    }

    public static int getLabel(File f) {
        if (isNativeCodeAvailable && f != null) {
            return Files.getLabel(f.getPath());
        }
        return -1;
    }

    public static Color getLabelColor(int label, int type) {
        return label == -1 ? null : labelColors[label][type];
    }

    public static BufferedImage getIconImage(File file, int size) {
        if (isNativeCodeAvailable && file != null) {
            try {
                byte[] tiffData = Files.getIconImage(file.getPath(), size);
                TIFFImageDecoder decoder = new TIFFImageDecoder(new MemoryCacheSeekableStream(new ByteArrayInputStream(tiffData)), (ImageDecodeParam)new TIFFDecodeParam());
                RenderedImage rImg = decoder.decodeAsRenderedImage(0);
                if (rImg instanceof BufferedImage) {
                    return (BufferedImage)rImg;
                }
                Raster r = rImg.getData();
                WritableRaster wr = WritableRaster.createWritableRaster(r.getSampleModel(), null);
                rImg.copyData(wr);
                BufferedImage img = new BufferedImage(rImg.getColorModel(), wr, rImg.getColorModel().isAlphaPremultiplied(), null);
                return img;
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    public static Icon getIcon(File file, int size) {
        return new ImageIcon(Files.getIconImage(file, size));
    }

    public static String getKindString(File file) {
        if (isNativeCodeAvailable && file != null) {
            return Files.getKindString(file.getPath());
        }
        return null;
    }

    private static native int getFileType(String var0);

    private static native String resolveAlias(String var0, boolean var1);

    private static native int resolveAliasType(String var0, boolean var1);

    private static native byte[] toSerializedAlias(String var0);

    private static native String jniResolveAlias(byte[] var0, boolean var1);

    private static native int jniResolveAliasType(byte[] var0, boolean var1);

    private static native int getLabel(String var0);

    private static native String getKindString(String var0);

    private static native byte[] getIconImage(String var0, int var1);

    static {
        boolean success;
        labelColors = new Color[][]{{null, null, null, null}, {new Color(0xB5B5B5), new Color(0xD7D7D7), new Color(0xE9E9E9), new Color(0xF3F3F3)}, {new Color(12442714), new Color(14478762), new Color(15529422), new Color(16120550)}, {new Color(13344222), new Color(14928878), new Color(15786742), new Color(16249082)}, {new Color(6730239), new Color(11983615), new Color(13756671), new Color(15332607)}, {new Color(15916890), new Color(16512170), new Color(16578254), new Color(16710886)}, {new Color(16741740), new Color(16757420), new Color(16766675), new Color(16771302)}, {new Color(16430421), new Color(16570018), new Color(16705996), new Color(0xFFF3E3)}};
        String value = QuaquaManager.getProperty("Quaqua.jniIsPreloaded");
        if (value == null) {
            value = QuaquaManager.getProperty("Quaqua.JNI.isPreloaded");
        }
        if (value != null && value.equals("true")) {
            success = true;
        } else {
            try {
                System.loadLibrary("quaqua");
                success = true;
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println("Warning: " + Files.class + " couldn't load library libquaqua.jnilib.");
                success = false;
            }
            catch (AccessControlException e) {
                System.err.println("Warning: " + Files.class + " access controller denied loading library libquaqua.jnilib.");
                success = false;
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.err.println("Warning: " + Files.class + " couldn't load library libquaqua.jnilib.");
                success = false;
            }
        }
        isNativeCodeAvailable = success;
    }
}

