/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.filechooser;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.filechooser.FileSystemViewFilter;
import ch.randelshofer.quaqua.filechooser.QuaquaFileView;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;

public abstract class QuaquaFileSystemView
extends FileSystemViewFilter {
    private static QuaquaFileSystemView instance;
    private static QuaquaFileSystemView fileSystemView;

    public abstract File getComputer();

    public abstract File getSystemVolume();

    public FileView createFileView(JFileChooser chooser) {
        return new QuaquaFileView(this);
    }

    public static QuaquaFileSystemView getQuaquaFileSystemView() {
        if (fileSystemView == null) {
            String className;
            int os = QuaquaManager.getOS();
            if (os == 5) {
                className = "ch.randelshofer.quaqua.filechooser.WindowsFileSystemView14";
            } else {
                switch (os) {
                    case 2: {
                        className = "ch.randelshofer.quaqua.jaguar.filechooser.JaguarFileSystemView";
                        break;
                    }
                    case 3: {
                        className = "ch.randelshofer.quaqua.panther.filechooser.PantherFileSystemView";
                        break;
                    }
                    default: {
                        className = "ch.randelshofer.quaqua.tiger.filechooser.TigerFileSystemView";
                    }
                }
            }
            try {
                fileSystemView = (QuaquaFileSystemView)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InternalError(e.getMessage());
            }
        }
        return fileSystemView;
    }
}

