/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.filechooser;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SubtreeTreeModel
implements TreeModel,
TreeModelListener {
    protected EventListenerList listenerList = new EventListenerList();
    protected PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private TreeModel target;
    private Object subtreeRoot;
    private Object[] rootPath;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    public SubtreeTreeModel(TreeModel target) {
        this.target = target;
        this.subtreeRoot = target.getRoot();
        this.rootPath = new Object[]{this.subtreeRoot};
        target.addTreeModelListener(this);
    }

    public void setPathToRoot(TreePath newValue) {
        this.setPathToRoot(newValue.getPath());
    }

    public void setPathToRoot(Object[] newValue) {
        Object[] oldValue = this.rootPath;
        if (!Arrays.equals(oldValue, newValue)) {
            this.rootPath = newValue;
            this.subtreeRoot = newValue[newValue.length - 1];
            this.changeSupport.firePropertyChange("rootPath", oldValue, newValue);
            this.fireTreeStructureChanged(this.subtreeRoot, new Object[]{this.rootPath[this.rootPath.length - 1]});
        }
    }

    public TreePath getPathToRoot() {
        return new TreePath(this.rootPath);
    }

    public Object getChild(Object parent, int index) {
        return this.target.getChild(parent, index);
    }

    public int getChildCount(Object parent) {
        return this.target.getChildCount(parent);
    }

    public int getIndexOfChild(Object parent, Object child) {
        return this.target.getIndexOfChild(parent, child);
    }

    public Object getRoot() {
        return this.subtreeRoot;
    }

    public boolean isLeaf(Object node) {
        return this.target.isLeaf(node);
    }

    public TreePath toFullPath(TreePath subtreePath) {
        return new TreePath(this.toFullPath(subtreePath.getPath()));
    }

    public Object[] toFullPath(Object[] subtreePath) {
        LinkedList<Object> list = new LinkedList<Object>(Arrays.asList(subtreePath));
        if (subtreePath.length > 0) {
            TreeNode node = (TreeNode)subtreePath[0];
            while ((node = node.getParent()) != null) {
                list.addFirst(node);
            }
        }
        return list.toArray();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        this.target.valueForPathChanged(this.toFullPath(path), newValue);
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = SubtreeTreeModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = SubtreeTreeModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? SubtreeTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? SubtreeTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? SubtreeTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? SubtreeTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    private void fireTreeStructureChanged(Object source, TreePath path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? SubtreeTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    public boolean isDescendant(Object[] fullpath) {
        if (fullpath.length >= this.rootPath.length) {
            for (int i = 0; i < this.rootPath.length; ++i) {
                if (this.rootPath[i] == fullpath[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object[] toSubPath(Object[] fullPath) {
        if (this.isDescendant(fullPath)) {
            Object[] subtreePath = new Object[fullPath.length - this.rootPath.length + 1];
            System.arraycopy(fullPath, this.rootPath.length - 1, subtreePath, 0, subtreePath.length);
            return subtreePath;
        }
        return null;
    }

    public boolean isDescendant(TreePath fullpath) {
        if (fullpath.getPathCount() >= this.rootPath.length) {
            for (int i = 0; i < this.rootPath.length; ++i) {
                if (this.rootPath[i] == fullpath.getPathComponent(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public TreePath toSubPath(TreePath fullPath) {
        Object[] subPath = this.toSubPath(fullPath.getPath());
        return subPath == null ? null : new TreePath(subPath);
    }

    public void treeNodesChanged(TreeModelEvent event) {
        Object[] subtreePath = this.toSubPath(event.getPath());
        if (subtreePath != null) {
            this.fireTreeNodesChanged(event.getSource(), subtreePath, event.getChildIndices(), event.getChildren());
        }
    }

    public void treeNodesInserted(TreeModelEvent event) {
        Object[] subtreePath = this.toSubPath(event.getPath());
        if (subtreePath != null) {
            this.fireTreeNodesInserted(event.getSource(), subtreePath, event.getChildIndices(), event.getChildren());
        }
    }

    public void treeNodesRemoved(TreeModelEvent event) {
        Object[] subtreePath = this.toSubPath(event.getPath());
        if (subtreePath != null) {
            this.fireTreeNodesRemoved(event.getSource(), subtreePath, event.getChildIndices(), event.getChildren());
        }
    }

    public void treeStructureChanged(TreeModelEvent event) {
        Object[] subtreePath = this.toSubPath(event.getPath());
        if (subtreePath != null) {
            this.fireTreeStructureChanged(event.getSource(), subtreePath);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

