/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.primer3;

import com.informagen.C.IO;
import com.informagen.C.RefDouble;
import com.informagen.C.RefInt;
import com.informagen.C.RefShort;
import com.informagen.primer3.BoulderIOReader;
import com.informagen.primer3.Constants;
import com.informagen.primer3.Macros;
import com.informagen.primer3.Primer3;
import com.informagen.primer3.pr_append_str;
import com.informagen.primer3.primer_args;
import com.informagen.primer3.program_args;
import com.informagen.primer3.seq_args;
import com.informagen.primer3.seq_lib;
import com.informagen.primer3.seq_lib_entry;
import com.informagen.primer3.task;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

class Boulder_input {
    public static int INIT_BUF_SIZE = 1024;
    public static int INIT_LIB_SIZE = 500;
    static String s;
    static String datum;
    static pr_append_str parse_err;

    Boulder_input() {
    }

    private static boolean COMPARE(String string) {
        return s.startsWith(string);
    }

    private static String COMPARE_AND_MALLOC(String string, String string2) {
        if (Boulder_input.COMPARE(string)) {
            if (string2 == null) {
                return new String(datum);
            }
            Primer3.pr_append_new_chunk(parse_err, "Duplicate tag: ");
            Primer3.pr_append(parse_err, string);
            return string2;
        }
        return null;
    }

    private static boolean COMPARE_ALIGN_SCORE(String string, RefShort refShort) {
        if (Boulder_input.COMPARE(string)) {
            Boulder_input.parse_align_score(string, datum, refShort, parse_err);
            return true;
        }
        return false;
    }

    private static boolean COMPARE_FLOAT(String string, RefDouble refDouble) {
        if (Boulder_input.COMPARE(string)) {
            Boulder_input.parse_double(string, datum, refDouble, parse_err);
            return true;
        }
        return false;
    }

    private static boolean COMPARE_INT(String string, RefInt refInt) {
        if (Boulder_input.COMPARE(string)) {
            Boulder_input.parse_int(string, datum, refInt, parse_err);
            return true;
        }
        return false;
    }

    private static boolean COMPARE_INTERVAL_LIST(String string, RefInt refInt, int[][] nArray) {
        if (Boulder_input.COMPARE(string)) {
            Boulder_input.parse_interval_list(string, datum, refInt, nArray, parse_err);
            return true;
        }
        return false;
    }

    static int read_record(BoulderIOReader boulderIOReader, program_args program_args2, primer_args primer_args2, seq_args seq_args2) {
        RefDouble refDouble = new RefDouble();
        RefInt refInt = new RefInt();
        RefShort refShort = new RefShort();
        boolean bl = false;
        int n = 2;
        String string = null;
        String string2 = null;
        int n2 = 0;
        String string3 = null;
        String string4 = null;
        seq_args2.initialize();
        seq_args2.error.data = new StringBuffer(0);
        primer_args2.glob_err.data = new StringBuffer(0);
        seq_args2.start_codon_pos = Constants.PR_DEFAULT_START_CODON_POS;
        seq_args2.incl_l = -1;
        int n3 = 0;
        while (true) {
            try {
                s = boulderIOReader.readLine();
                if (s == null || s.equals("=")) {
                    break;
                }
            }
            catch (IOException iOException) {
                IO.stdout.print("IOException during file reading\n");
            }
            bl = true;
            if (!program_args2.format_output) {
                IO.stdout.print(s + "\n");
            }
            int n4 = s.length();
            n2 = s.indexOf("=");
            if (n2 == -1) {
                Primer3.pr_append_new_chunk(primer_args2.glob_err, "Input line with no '=': ");
                Primer3.pr_append(primer_args2.glob_err, s);
            } else {
                datum = s.substring(n2 + 1);
                parse_err = seq_args2.error;
                if (Boulder_input.COMPARE("SEQUENCE")) {
                    string2 = Boulder_input.COMPARE_AND_MALLOC("SEQUENCE", seq_args2.sequence);
                    if (string2 == null) continue;
                    seq_args2.sequence = string2;
                    continue;
                }
                if (Boulder_input.COMPARE("PRIMER_SEQUENCE_QUALITY")) {
                    n3 = Boulder_input.parse_seq_quality(datum, seq_args2.quality);
                    if (n3 != 0) continue;
                    Primer3.pr_append_new_chunk(seq_args2.error, "Error in sequence quality data");
                    continue;
                }
                if (Boulder_input.COMPARE("PRIMER_SEQUENCE_ID")) {
                    string2 = Boulder_input.COMPARE_AND_MALLOC("PRIMER_SEQUENCE_ID", seq_args2.sequence_name);
                    if (string2 == null) continue;
                    seq_args2.sequence_name = string2;
                    continue;
                }
                if (Boulder_input.COMPARE("MARKER_NAME")) {
                    string2 = Boulder_input.COMPARE_AND_MALLOC("MARKER_NAME", seq_args2.sequence_name);
                    if (string2 == null) continue;
                    seq_args2.sequence_name = string2;
                    continue;
                }
                if (Boulder_input.COMPARE("PRIMER_LEFT_INPUT")) {
                    string2 = Boulder_input.COMPARE_AND_MALLOC("PRIMER_LEFT_INPUT", seq_args2.left_input);
                    if (string2 == null) continue;
                    seq_args2.left_input = string2;
                    continue;
                }
                if (Boulder_input.COMPARE("PRIMER_RIGHT_INPUT")) {
                    string2 = Boulder_input.COMPARE_AND_MALLOC("PRIMER_RIGHT_INPUT", seq_args2.right_input);
                    if (string2 == null) continue;
                    seq_args2.right_input = string2;
                    continue;
                }
                if (Boulder_input.COMPARE("PRIMER_INTERNAL_OLIGO_INPUT")) {
                    string2 = Boulder_input.COMPARE_AND_MALLOC("PRIMER_INTERNAL_OLIGO_INPUT", seq_args2.internal_input);
                    if (string2 == null) continue;
                    seq_args2.internal_input = string2;
                    continue;
                }
                refInt.setValue(seq_args2.num_targets);
                if (Boulder_input.COMPARE_INTERVAL_LIST("TARGET", refInt, seq_args2.tar)) {
                    seq_args2.num_targets = refInt.getValue();
                    continue;
                }
                refInt.setValue(seq_args2.num_excl);
                if (Boulder_input.COMPARE_INTERVAL_LIST("EXCLUDED_REGION", refInt, seq_args2.excl)) {
                    seq_args2.num_excl = refInt.getValue();
                    continue;
                }
                refInt.setValue(seq_args2.num_internal_excl);
                if (Boulder_input.COMPARE_INTERVAL_LIST("PRIMER_INTERNAL_OLIGO_EXCLUDED_REGION", refInt, seq_args2.excl_internal)) {
                    seq_args2.num_internal_excl = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE("INCLUDED_REGION")) {
                    RefInt refInt2 = new RefInt(seq_args2.incl_s);
                    RefInt refInt3 = new RefInt(seq_args2.incl_l);
                    if (!Boulder_input.parse_int_pair("INCLUDED_REGION", datum, ",", refInt2, refInt3, parse_err)) continue;
                    seq_args2.incl_s = refInt2.getValue();
                    seq_args2.incl_l = refInt3.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_START_CODON_POSITION", refInt)) {
                    seq_args2.start_codon_pos = refInt.getValue();
                    continue;
                }
                parse_err = primer_args2.glob_err;
                if (Boulder_input.COMPARE("PRIMER_PRODUCT_SIZE_RANGE") || Boulder_input.COMPARE("PRIMER_DEFAULT_PRODUCT")) {
                    Boulder_input.parse_product_size("PRIMER_PRODUCT_SIZE_RANGE", datum, primer_args2, parse_err);
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_DEFAULT_SIZE", refInt)) {
                    primer_args2.primer_opt_size = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_OPT_SIZE", refInt)) {
                    primer_args2.primer_opt_size = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_MIN_SIZE", refInt)) {
                    primer_args2.primer_min_size = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_MAX_SIZE", refInt)) {
                    primer_args2.primer_max_size = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_MAX_POLY_X", refInt)) {
                    primer_args2.max_poly_x = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_OPT_TM", refDouble)) {
                    primer_args2.opt_tm = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_OPT_GC_PERCENT", refDouble)) {
                    primer_args2.opt_gc_content = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_MIN_TM", refDouble)) {
                    primer_args2.min_tm = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_MAX_TM", refDouble)) {
                    primer_args2.max_tm = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_MAX_DIFF_TM", refDouble)) {
                    primer_args2.max_diff_tm = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_MIN_GC", refDouble)) {
                    primer_args2.min_gc = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_MAX_GC", refDouble)) {
                    primer_args2.max_gc = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_SALT_CONC", refDouble)) {
                    primer_args2.salt_conc = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_DNA_CONC", refDouble)) {
                    primer_args2.dna_conc = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_NUM_NS_ACCEPTED", refInt)) {
                    primer_args2.num_ns_accepted = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_PRODUCT_OPT_SIZE", refInt)) {
                    primer_args2.product_opt_size = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_ALIGN_SCORE("PRIMER_SELF_ANY", refShort)) {
                    primer_args2.self_any = refShort.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_ALIGN_SCORE("PRIMER_SELF_END", refShort)) {
                    primer_args2.self_end = refShort.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_FILE_FLAG", refInt)) {
                    primer_args2.file_flag = refInt.getValue() == 1;
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_PICK_ANYWAY", refInt)) {
                    primer_args2.pick_anyway = refInt.getValue() == 1;
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_GC_CLAMP", refInt)) {
                    primer_args2.gc_clamp = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_EXPLAIN_FLAG", refInt)) {
                    primer_args2.explain_flag = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_ALIGNMENT_FLAG", refInt)) {
                    primer_args2.alignment_flag = refInt.getValue() == 1;
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_FORWARD_REPORT_COUNT", refInt)) {
                    primer_args2.forward_report_count = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_IO_REPORT_COUNT", refInt)) {
                    primer_args2.io_report_count = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_REVERSE_REPORT_COUNT", refInt)) {
                    primer_args2.reverse_report_count = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_LIBERAL_BASE", refInt)) {
                    primer_args2.liberal_base = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_FIRST_BASE_INDEX", refInt)) {
                    primer_args2.first_base_index = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_NUM_RETURN", refInt)) {
                    primer_args2.num_return = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_MIN_QUALITY", refInt)) {
                    primer_args2.min_quality = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_MIN_END_QUALITY", refInt)) {
                    primer_args2.min_end_quality = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_QUALITY_RANGE_MIN", refInt)) {
                    primer_args2.quality_range_min = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_QUALITY_RANGE_MAX", refInt)) {
                    primer_args2.quality_range_max = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_PRODUCT_MAX_TM", refDouble)) {
                    primer_args2.product_max_tm = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_PRODUCT_MIN_TM", refDouble)) {
                    primer_args2.product_min_tm = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_PRODUCT_OPT_TM", refDouble)) {
                    primer_args2.product_opt_tm = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_PICK_INTERNAL_OLIGO", refInt)) {
                    n = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE("PRIMER_TASK")) {
                    string2 = Boulder_input.COMPARE_AND_MALLOC("PRIMER_TASK", string);
                    if (string2 == null) continue;
                    string = string2;
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_INTERNAL_OLIGO_OPT_SIZE", refInt)) {
                    primer_args2.io_primer_opt_size = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_INTERNAL_OLIGO_MAX_SIZE", refInt)) {
                    primer_args2.io_primer_max_size = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_INTERNAL_OLIGO_MIN_SIZE", refInt)) {
                    primer_args2.io_primer_min_size = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_INTERNAL_OLIGO_MAX_POLY_X", refInt)) {
                    primer_args2.io_max_poly_x = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_INTERNAL_OLIGO_OPT_TM", refDouble)) {
                    primer_args2.io_opt_tm = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_INTERNAL_OLIGO_OPT_GC_PERCENT", refDouble)) {
                    primer_args2.io_opt_gc_content = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_INTERNAL_OLIGO_MAX_TM", refDouble)) {
                    primer_args2.io_max_tm = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_INTERNAL_OLIGO_MIN_TM", refDouble)) {
                    primer_args2.io_min_tm = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_INTERNAL_OLIGO_MIN_GC", refDouble)) {
                    primer_args2.io_min_gc = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_INTERNAL_OLIGO_MAX_GC", refDouble)) {
                    primer_args2.io_max_gc = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_INTERNAL_OLIGO_SALT_CONC", refDouble)) {
                    primer_args2.io_salt_conc = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_INTERNAL_OLIGO_DNA_CONC", refDouble)) {
                    primer_args2.io_dna_conc = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_INTERNAL_OLIGO_NUM_NS", refInt)) {
                    primer_args2.io_num_ns_accepted = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_INT("PRIMER_INTERNAL_OLIGO_MIN_QUALITY", refInt)) {
                    primer_args2.io_min_quality = refInt.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_ALIGN_SCORE("PRIMER_INTERNAL_OLIGO_SELF_ANY", refShort)) {
                    primer_args2.io_self_any = refShort.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_ALIGN_SCORE("PRIMER_INTERNAL_OLIGO_SELF_END", refShort)) {
                    primer_args2.io_self_end = refShort.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_ALIGN_SCORE("PRIMER_MAX_MISPRIMING", refShort)) {
                    primer_args2.repeat_compl = refShort.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_ALIGN_SCORE("PRIMER_INTERNAL_OLIGO_MAX_MISHYB", refShort)) {
                    primer_args2.io_repeat_compl = refShort.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_ALIGN_SCORE("PRIMER_PAIR_MAX_MISPRIMING", refShort)) {
                    primer_args2.pair_repeat_compl = refShort.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_INSIDE_PENALTY", refDouble)) {
                    primer_args2.inside_penalty = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_OUTSIDE_PENALTY", refDouble)) {
                    primer_args2.outside_penalty = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE("PRIMER_MISPRIMING_LIBRARY")) {
                    if (string3 != null) {
                        Primer3.pr_append_new_chunk(primer_args2.glob_err, "Duplicate PRIMER_MISPRIMING_LIBRARY tag");
                        string3 = null;
                        continue;
                    }
                    string3 = new String(datum);
                    continue;
                }
                if (Boulder_input.COMPARE("PRIMER_INTERNAL_OLIGO_MISHYB_LIBRARY")) {
                    if (string4 != null) {
                        Primer3.pr_append_new_chunk(primer_args2.glob_err, "Duplicate PRIMER_INTERNAL_OLIGO_MISHYB_LIBRARY tag");
                        string4 = null;
                        continue;
                    }
                    string4 = new String(datum);
                    continue;
                }
                if (Boulder_input.COMPARE("PRIMER_COMMENT") || Boulder_input.COMPARE("COMMENT")) continue;
                if (Boulder_input.COMPARE_FLOAT("PRIMER_MAX_END_STABILITY", refDouble)) {
                    primer_args2.max_end_stability = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_WT_TM_GT", refDouble)) {
                    primer_args2.primer_weights.temp_gt = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_WT_TM_LT", refDouble)) {
                    primer_args2.primer_weights.temp_lt = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_WT_GC_PERCENT_GT", refDouble)) {
                    primer_args2.primer_weights.gc_content_gt = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_WT_GC_PERCENT_LT", refDouble)) {
                    primer_args2.primer_weights.gc_content_lt = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_WT_SIZE_LT", refDouble)) {
                    primer_args2.primer_weights.length_lt = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_WT_SIZE_GT", refDouble)) {
                    primer_args2.primer_weights.length_gt = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_WT_COMPL_ANY", refDouble)) {
                    primer_args2.primer_weights.compl_any = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_WT_COMPL_END", refDouble)) {
                    primer_args2.primer_weights.compl_end = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_WT_NUM_NS", refDouble)) {
                    primer_args2.primer_weights.num_ns = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_WT_REP_SIM", refDouble)) {
                    primer_args2.primer_weights.repeat_sim = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_WT_SEQ_QUAL", refDouble)) {
                    primer_args2.primer_weights.seq_quality = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_WT_END_QUAL", refDouble)) {
                    primer_args2.primer_weights.end_quality = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_WT_POS_PENALTY", refDouble)) {
                    primer_args2.primer_weights.pos_penalty = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_WT_END_STABILITY", refDouble)) {
                    primer_args2.primer_weights.end_stability = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_IO_WT_TM_GT", refDouble)) {
                    primer_args2.io_weights.temp_gt = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_IO_WT_TM_LT", refDouble)) {
                    primer_args2.io_weights.temp_lt = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_IO_WT_GC_PERCENT_GT", refDouble)) {
                    primer_args2.io_weights.gc_content_gt = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_IO_WT_GC_PERCENT_LT", refDouble)) {
                    primer_args2.io_weights.gc_content_lt = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_IO_WT_SIZE_LT", refDouble)) {
                    primer_args2.io_weights.length_lt = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_IO_WT_SIZE_GT", refDouble)) {
                    primer_args2.io_weights.length_gt = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_IO_WT_COMPL_ANY", refDouble)) {
                    primer_args2.io_weights.compl_any = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_IO_WT_COMPL_END", refDouble)) {
                    primer_args2.io_weights.compl_end = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_IO_WT_NUM_NS", refDouble)) {
                    primer_args2.io_weights.num_ns = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_IO_WT_REP_SIM", refDouble)) {
                    primer_args2.io_weights.repeat_sim = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_IO_WT_SEQ_QUAL", refDouble)) {
                    primer_args2.io_weights.seq_quality = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_IO_WT_END_QUAL", refDouble)) {
                    primer_args2.io_weights.end_quality = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_PAIR_WT_PR_PENALTY", refDouble)) {
                    primer_args2.pr_pair_weights.primer_quality = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_PAIR_WT_IO_PENALTY", refDouble)) {
                    primer_args2.pr_pair_weights.io_quality = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_PAIR_WT_DIFF_TM", refDouble)) {
                    primer_args2.pr_pair_weights.diff_tm = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_PAIR_WT_COMPL_ANY", refDouble)) {
                    primer_args2.pr_pair_weights.compl_any = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_PAIR_WT_COMPL_END", refDouble)) {
                    primer_args2.pr_pair_weights.compl_end = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_PAIR_WT_PRODUCT_TM_LT", refDouble)) {
                    primer_args2.pr_pair_weights.product_tm_lt = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_PAIR_WT_PRODUCT_TM_GT", refDouble)) {
                    primer_args2.pr_pair_weights.product_tm_gt = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_PAIR_WT_PRODUCT_SIZE_GT", refDouble)) {
                    primer_args2.pr_pair_weights.product_size_gt = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_PAIR_WT_PRODUCT_SIZE_LT", refDouble)) {
                    primer_args2.pr_pair_weights.product_size_lt = refDouble.getValue();
                    continue;
                }
                if (Boulder_input.COMPARE_FLOAT("PRIMER_PAIR_WT_REP_SIM", refDouble)) {
                    primer_args2.pr_pair_weights.repeat_sim = refDouble.getValue();
                    continue;
                }
            }
            if (!program_args2.strict_tags) continue;
            Primer3.pr_append_new_chunk(primer_args2.glob_err, "Unrecognized tag: ");
            Primer3.pr_append(primer_args2.glob_err, s);
            System.err.print("Unrecognized tag: " + s + "\n");
        }
        if (null == s) {
            if (bl) {
                Primer3.pr_append_new_chunk(primer_args2.glob_err, "Final record not terminated by '='");
                return 1;
            }
            return 0;
        }
        if (string != null) {
            if (string.equalsIgnoreCase("pick_pcr_primers")) {
                primer_args2.primer_task = task.pick_pcr_primers;
            } else if (string.equalsIgnoreCase("pick_pcr_primers_and_hyb_probe")) {
                primer_args2.primer_task = task.pick_pcr_primers_and_hyb_probe;
            } else if (string.equalsIgnoreCase("pick_left_only")) {
                primer_args2.primer_task = task.pick_left_only;
            } else if (string.equalsIgnoreCase("pick_right_only")) {
                primer_args2.primer_task = task.pick_right_only;
            } else if (string.equalsIgnoreCase("pick_hyb_probe_only")) {
                primer_args2.primer_task = task.pick_hyb_probe_only;
            } else {
                Primer3.pr_append_new_chunk(primer_args2.glob_err, "Unrecognized PRIMER_TASK");
            }
            string = null;
        }
        if (null == seq_args2.sequence) {
            Primer3.pr_append_new_chunk(seq_args2.error, "Missing SEQUENCE tag");
        } else {
            int n5 = seq_args2.sequence.length();
            if (seq_args2.incl_l == -1) {
                seq_args2.incl_l = n5;
                seq_args2.incl_s = primer_args2.first_base_index;
            }
            if (n3 != 0 && n3 != n5) {
                Primer3.pr_append_new_chunk(seq_args2.error, "Error in sequence quality data");
            }
            if ((primer_args2.min_quality != 0 || primer_args2.io_min_quality != 0) && n3 == 0) {
                Primer3.pr_append_new_chunk(seq_args2.error, "Sequence quality data missing");
            }
            if (primer_args2.min_quality != 0 && primer_args2.min_end_quality < primer_args2.min_quality) {
                primer_args2.min_end_quality = primer_args2.min_quality;
            }
        }
        if (null != string3) {
            if (string3.length() == 0) {
                Boulder_input.free_seq_lib(primer_args2.repeat_lib);
            } else {
                Boulder_input.read_seq_lib(primer_args2.repeat_lib, string3, "mispriming library");
                if (primer_args2.repeat_lib.error.data != null) {
                    Primer3.pr_append_new_chunk(primer_args2.glob_err, new String(primer_args2.repeat_lib.error.data));
                }
            }
            string3 = null;
        }
        if (null != string4) {
            if (string4.length() == 0) {
                Boulder_input.free_seq_lib(primer_args2.io_mishyb_library);
            } else {
                Boulder_input.read_seq_lib(primer_args2.io_mishyb_library, string4, "internal oligo mishyb library");
                if (primer_args2.io_mishyb_library.error.data != null) {
                    Primer3.pr_append_new_chunk(primer_args2.glob_err, new String(primer_args2.io_mishyb_library.error.data));
                }
            }
            string4 = null;
        }
        if (!(n != 1 && n != 0 || primer_args2.primer_task != task.pick_left_only && primer_args2.primer_task != task.pick_right_only && primer_args2.primer_task != task.pick_hyb_probe_only)) {
            Primer3.pr_append_new_chunk(primer_args2.glob_err, "Contradiction in primer_task definition");
        } else if (n == 1) {
            primer_args2.primer_task = 1;
        } else if (n == 0) {
            primer_args2.primer_task = 0;
        }
        seq_args2.incl_s -= primer_args2.first_base_index;
        seq_args2.start_codon_pos -= primer_args2.first_base_index;
        Boulder_input.adjust_base_index_interval_list(seq_args2.tar, seq_args2.num_targets, primer_args2.first_base_index);
        Boulder_input.adjust_base_index_interval_list(seq_args2.excl, seq_args2.num_excl, primer_args2.first_base_index);
        Boulder_input.adjust_base_index_interval_list(seq_args2.excl_internal, seq_args2.num_internal_excl, primer_args2.first_base_index);
        return 1;
    }

    private static void adjust_base_index_interval_list(int[][] nArray, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            nArray2[0] = nArray2[0] - n2;
        }
    }

    private static void tag_syntax_error(String string, String string2, pr_append_str pr_append_str2) {
        Primer3.pr_append_new_chunk(pr_append_str2, "Illegal ");
        Primer3.pr_append(pr_append_str2, string);
        Primer3.pr_append(pr_append_str2, " value: ");
        Primer3.pr_append(pr_append_str2, string2);
    }

    private static void parse_align_score(String string, String string2, RefShort refShort, pr_append_str pr_append_str2) {
        RefDouble refDouble = new RefDouble();
        Boulder_input.parse_double(string, string2, refDouble, pr_append_str2);
        double d = refDouble.getValue();
        d *= Constants.PR_ALIGN_SCORE_PRECISION;
        if (d > 32767.0) {
            Primer3.pr_append_new_chunk(pr_append_str2, "Value too large at tag ");
            Primer3.pr_append(pr_append_str2, string);
        } else {
            refShort.setValue((short)d);
        }
    }

    private static void parse_double(String string, String string2, RefDouble refDouble, pr_append_str pr_append_str2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        double d = 0.0;
        try {
            d = Double.valueOf(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            Boulder_input.tag_syntax_error(string, string2, pr_append_str2);
            return;
        }
        refDouble.setValue(d);
        if (stringTokenizer.hasMoreTokens()) {
            Boulder_input.tag_syntax_error(string, string2, pr_append_str2);
        }
    }

    private static void parse_int(String string, String string2, RefInt refInt, pr_append_str pr_append_str2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n = 0;
        try {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            Boulder_input.tag_syntax_error(string, string2, pr_append_str2);
            return;
        }
        if (n > Integer.MAX_VALUE || n < Integer.MIN_VALUE) {
            Boulder_input.tag_syntax_error(string, string2, pr_append_str2);
            Primer3.pr_append(pr_append_str2, " (value too large or too small)");
            return;
        }
        refInt.setValue(n);
        if (stringTokenizer.hasMoreTokens()) {
            Boulder_input.tag_syntax_error(string, string2, pr_append_str2);
        }
    }

    private static boolean parse_int_pair(String string, String string2, String string3, RefInt refInt, RefInt refInt2, pr_append_str pr_append_str2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2.trim(), string3);
        int n = 0;
        try {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            Boulder_input.tag_syntax_error(string, string2, pr_append_str2);
            return false;
        }
        if (n > Integer.MAX_VALUE || n < Integer.MIN_VALUE) {
            Boulder_input.tag_syntax_error(string, string2, pr_append_str2);
            Primer3.pr_append(pr_append_str2, " (value too large or too small)");
            return false;
        }
        refInt.setValue(n);
        if (!stringTokenizer.hasMoreTokens()) {
            Boulder_input.tag_syntax_error(string, string2, pr_append_str2);
            Primer3.pr_append(pr_append_str2, " (two values expected)");
        }
        try {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            Boulder_input.tag_syntax_error(string, string2, pr_append_str2);
            Primer3.pr_append(pr_append_str2, " (value not an integer)");
            return false;
        }
        if (n > Integer.MAX_VALUE || n < Integer.MIN_VALUE) {
            Boulder_input.tag_syntax_error(string, string2, pr_append_str2);
            Primer3.pr_append(pr_append_str2, " (value too large or too small)");
            return false;
        }
        refInt2.setValue(n);
        return true;
    }

    private static void parse_interval_list(String string, String string2, RefInt refInt, int[][] nArray, pr_append_str pr_append_str2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2.trim(), " ");
        RefInt refInt2 = new RefInt();
        RefInt refInt3 = new RefInt();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (refInt.getValue() >= Constants.PR_MAX_INTERVAL_ARRAY) {
                Primer3.pr_append_new_chunk(pr_append_str2, "Too many elements for tag ");
                Primer3.pr_append(pr_append_str2, string);
                return;
            }
            if (!Boulder_input.parse_int_pair(string, string3, ",", refInt2, refInt3, pr_append_str2)) continue;
            nArray[refInt.getValue()][0] = refInt2.getValue();
            nArray[refInt.getValue()][1] = refInt3.getValue();
            refInt.setValue(refInt.getValue() + 1);
        }
    }

    private static void parse_product_size(String string, String string2, primer_args primer_args2, pr_append_str pr_append_str2) {
        StringTokenizer stringTokenizer = new StringTokenizer(datum.trim(), " ");
        RefInt refInt = new RefInt();
        RefInt refInt2 = new RefInt();
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (n >= Constants.PR_MAX_INTERVAL_ARRAY) {
                Primer3.pr_append_new_chunk(pr_append_str2, "Too many values for ");
                Primer3.pr_append(pr_append_str2, string);
                return;
            }
            if (!Boulder_input.parse_int_pair(string, string3, "-", refInt, refInt2, pr_append_str2)) continue;
            primer_args2.pr_min[n] = refInt.getValue();
            primer_args2.pr_max[n] = refInt2.getValue();
            ++n;
        }
        primer_args2.numIntervals = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void read_seq_lib(seq_lib seq_lib2, String string, String string2) {
        String string3 = null;
        Macros.PR_ASSERT(null != seq_lib2);
        Macros.PR_ASSERT(null != string);
        Boulder_input.free_seq_lib(seq_lib2);
        int n = string.lastIndexOf(File.separator);
        if (n > 0) {
            seq_lib2.repeat_file = string.substring(n + 1);
        }
        String string4 = null;
        String string5 = "";
        double d = 0.0;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            int n2 = -1;
            boolean bl = false;
            boolean bl2 = false;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.startsWith(">")) {
                    if (++n2 > 0) {
                        if (string5.length() == 0) {
                            Primer3.pr_append_new_chunk(seq_lib2.error, "Empty sequence in ");
                            throw new IOException();
                        }
                        string5 = Boulder_input.upcase_and_check_char(string5);
                        seq_lib2.add(string4, string5, d);
                        string5 = "";
                    }
                    if (!((d = Boulder_input.parse_seq_name(string4 = string3.substring(1))) < 0.0)) continue;
                    Primer3.pr_append_new_chunk(seq_lib2.error, "Illegal weight in ");
                    throw new IOException();
                }
                if (n2 < 0) {
                    Primer3.pr_append_new_chunk(seq_lib2.error, "Missing id line (expected '>') in ");
                    throw new IOException();
                }
                string5 = string5 + string3;
            }
            if (n2 < 0) {
                Primer3.pr_append_new_chunk(seq_lib2.error, "Empty ");
                throw new IOException();
            }
            if (string5.length() == 0) {
                Primer3.pr_append_new_chunk(seq_lib2.error, "Empty sequence in ");
                throw new IOException();
            }
            string5 = Boulder_input.upcase_and_check_char(string5);
            seq_lib2.add(string4, string5, d);
            if (string5 == null) {
                Primer3.pr_append_new_chunk(seq_lib2.warning, "Unrecognized character in ");
                Primer3.pr_append(seq_lib2.warning, string2);
                Primer3.pr_append(seq_lib2.warning, " ");
                Primer3.pr_append(seq_lib2.warning, seq_lib2.repeat_file);
            }
            Boulder_input.reverse_complement_seq_lib(seq_lib2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Primer3.pr_append_new_chunk(seq_lib2.error, "File not found: " + seq_lib2.repeat_file);
        }
        catch (IOException iOException) {
            Primer3.pr_append(seq_lib2.error, string2);
            Primer3.pr_append(seq_lib2.error, " ");
            Primer3.pr_append(seq_lib2.error, seq_lib2.repeat_file);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    static void free_seq_lib(seq_lib seq_lib2) {
        if (null == seq_lib2) {
            return;
        }
        seq_lib2.free();
    }

    private static String upcase_and_check_char(String string) {
        String string2 = string.toUpperCase();
        string2 = string2.replace('\n', ' ');
        string2 = string2.replace('\r', ' ');
        string2 = string2.replace('\t', ' ');
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        char[] cArray = string2.toCharArray();
        for (int i = 0; i < string2.length(); ++i) {
            if (cArray[i] == ' ') continue;
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    private static double parse_seq_name(String string) {
        double d = 1.0;
        int n = 0;
        n = string.indexOf(42);
        if (n == -1) {
            return 1.0;
        }
        d = Double.valueOf(string.substring(n + 1));
        if (d > Constants.PR_MAX_LIBRARY_WT) {
            return -1.0;
        }
        return d;
    }

    private static void reverse_complement_seq_lib(seq_lib seq_lib2) {
        int n = seq_lib2.seq_num;
        if (n == 0) {
            return;
        }
        int n2 = seq_lib2.entries.size();
        for (int i = 0; i < n2; ++i) {
            seq_lib_entry seq_lib_entry2 = (seq_lib_entry)seq_lib2.entries.elementAt(i);
            seq_lib2.add("Reverse " + seq_lib_entry2.name, new String(Primer3.reverse_complement(seq_lib_entry2.seq)), seq_lib_entry2.weight);
        }
        seq_lib2.entries.trimToSize();
    }

    private static int parse_seq_quality(String string, int[] nArray) {
        int n = 0;
        return n;
    }
}

