/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.primer3;

import com.informagen.C.IO;
import com.informagen.F;
import com.informagen.primer3.Constants;
import com.informagen.primer3.Macros;
import com.informagen.primer3.Primer3;
import com.informagen.primer3.oligo_stats;
import com.informagen.primer3.oligo_type;
import com.informagen.primer3.pair_array_t;
import com.informagen.primer3.pair_stats;
import com.informagen.primer3.primer_args;
import com.informagen.primer3.primer_pair;
import com.informagen.primer3.primer_rec;
import com.informagen.primer3.seq_args;
import com.informagen.primer3.seq_lib;
import com.informagen.primer3.task;
import java.io.PrintWriter;
import java.util.Vector;

public class Format_output {
    public static int FORWARD = 1;
    public static int REVERSE = -1;

    public static void format_pairs(PrintWriter printWriter, primer_args primer_args2, seq_args seq_args2, pair_array_t pair_array_t2) {
        boolean bl = Format_output.lib_sim_specified(primer_args2);
        Macros.PR_ASSERT(printWriter != null);
        Macros.PR_ASSERT(null != primer_args2);
        Macros.PR_ASSERT(null != seq_args2);
        primer_rec primer_rec2 = null;
        if (null != seq_args2.sequence_name) {
            printWriter.print("PRIMER PICKING RESULTS FOR " + seq_args2.sequence_name + "\n\n");
        }
        if (seq_args2.error.hasError()) {
            printWriter.print("INPUT PROBLEM: " + seq_args2.error.data + "\n\n");
        } else {
            if (primer_args2.repeat_lib.repeat_file != null) {
                printWriter.print("Using mispriming library: " + primer_args2.repeat_lib.repeat_file + "\n");
            } else {
                printWriter.print("No mispriming library specified.\n");
            }
            if (primer_args2.primer_task == task.pick_pcr_primers_and_hyb_probe) {
                if (primer_args2.io_mishyb_library.repeat_file != null) {
                    printWriter.print("Using internal oligo mishyb library: " + primer_args2.io_mishyb_library.repeat_file + "\n");
                } else {
                    printWriter.print("No internal oligo mishyb library specified\n");
                }
            }
            printWriter.print("Using " + primer_args2.first_base_index + "-based sequence positions" + "\n");
            if (pair_array_t2.num_pairs() == 0) {
                printWriter.print("NO PRIMERS FOUND\n\n");
            }
            Format_output.print_summary(printWriter, primer_args2, seq_args2, pair_array_t2, 0);
            printWriter.print("\n");
            if (primer_args2.alignment_flag) {
                Format_output.print_seq(printWriter, primer_args2, seq_args2, primer_rec2, pair_array_t2, 0);
            }
            if (pair_array_t2.num_pairs() > 1) {
                Format_output.print_rest(printWriter, primer_args2, seq_args2, pair_array_t2);
            }
            if (primer_args2.explain_flag != 0) {
                printWriter.print("\n");
                Format_output.print_explain(printWriter, primer_args2, seq_args2, bl);
                printWriter.print("\n" + Constants.pr_release + "\n");
                printWriter.print("\n------------------------------------------------------------------------------------\n");
            }
            printWriter.print("\n\n");
        }
    }

    public static void format_oligos(PrintWriter printWriter, primer_args primer_args2, seq_args seq_args2, Vector vector, int n, int n2) {
        String string;
        boolean bl = Format_output.lib_sim_specified(primer_args2);
        Macros.PR_ASSERT(null != printWriter);
        Macros.PR_ASSERT(null != primer_args2);
        Macros.PR_ASSERT(null != seq_args2);
        Object var9_7 = null;
        if (null != seq_args2.sequence_name) {
            printWriter.print("PRIMER PICKING RESULTS FOR " + seq_args2.sequence_name + "\n\n");
        }
        if (seq_args2.error.hasError()) {
            printWriter.print("INPUT PROBLEM: " + seq_args2.error.data + "\n\n");
        } else if (n2 != oligo_type.OT_INTL) {
            if (primer_args2.repeat_lib.repeat_file != null) {
                printWriter.print("Using mispriming library: " + primer_args2.repeat_lib.repeat_file + "\n");
            } else {
                printWriter.print("No mispriming library specified\n");
            }
        } else if (primer_args2.primer_task == task.pick_pcr_primers_and_hyb_probe) {
            if (primer_args2.io_mishyb_library.repeat_file != null) {
                printWriter.print("Using internal oligo mishyb library: " + primer_args2.io_mishyb_library.repeat_file + "\n");
            } else {
                printWriter.print("No internal oligo mishyb library specified\n");
            }
        }
        String string2 = n2 == oligo_type.OT_LEFT ? "LEFT_PRIMER" : (n2 == oligo_type.OT_RIGHT ? "RIGHT_PRIMER" : "INTERNAL_OLIGO");
        printWriter.print("Using " + primer_args2.first_base_index + "-based sequence positions" + "\n");
        if (n == 0) {
            printWriter.print("NO OLIGOS FOUND\n\n");
        }
        if ((string = Primer3.pr_gather_warnings(seq_args2, primer_args2)) != null) {
            printWriter.print("WARNING: " + string + "\n\n");
            string = null;
        }
        if (n > 0) {
            Format_output.print_oligo_summary(printWriter, primer_args2, seq_args2, vector, n2, 0);
        } else {
            vector = null;
        }
        printWriter.print("\n");
        if (n > 1) {
            printWriter.print("ADDITIONAL OLIGOS:\n");
            printWriter.print("   ");
            Format_output.print_oligo_header(printWriter, "", bl);
            for (int i = 1; i < primer_args2.num_return && i <= n - 1; ++i) {
                primer_rec primer_rec2 = (primer_rec)vector.elementAt(i);
                printWriter.print(F.f(i, 2));
                if (oligo_type.OT_LEFT == n2 || oligo_type.OT_INTL == n2) {
                    Format_output.print_oligo(printWriter, string2, seq_args2, primer_rec2, FORWARD, primer_args2, primer_args2.repeat_lib, bl);
                    continue;
                }
                Format_output.print_oligo(printWriter, string2, seq_args2, primer_rec2, REVERSE, primer_args2, primer_args2.repeat_lib, bl);
            }
        }
        if (primer_args2.explain_flag != 0) {
            printWriter.print("\n");
            Format_output.print_explain(printWriter, primer_args2, seq_args2, bl);
            printWriter.print("\n" + Constants.pr_release + "\n");
            printWriter.print("\n------------------------------------------------------------------------------------\n");
        }
        printWriter.print("\n\n");
    }

    private static void print_summary(PrintWriter printWriter, primer_args primer_args2, seq_args seq_args2, pair_array_t pair_array_t2, int n) {
        int n2 = seq_args2.sequence.length();
        boolean bl = Format_output.lib_sim_specified(primer_args2);
        primer_pair primer_pair2 = pair_array_t2.getPair(n);
        if (pair_array_t2.num_pairs() > 0) {
            printWriter.print("\n");
            Format_output.print_oligo_header(printWriter, "", bl);
            Format_output.print_oligo(printWriter, "LEFT PRIMER", seq_args2, primer_pair2.left, FORWARD, primer_args2, primer_args2.repeat_lib, bl);
            Format_output.print_oligo(printWriter, "RIGHT PRIMER", seq_args2, primer_pair2.right, REVERSE, primer_args2, primer_args2.repeat_lib, bl);
            if (primer_args2.primer_task == task.pick_pcr_primers_and_hyb_probe) {
                Format_output.print_oligo(printWriter, "INTERNAL OLIGO", seq_args2, primer_pair2.intl, FORWARD, primer_args2, primer_args2.io_mishyb_library, bl);
            }
        }
        printWriter.print("\nSEQUENCE SIZE: " + n2 + "\n");
        printWriter.print("INCLUDED REGION SIZE: " + seq_args2.incl_l + "\n\n");
        if (pair_array_t2.num_pairs() > 0) {
            Format_output.print_pair_info(printWriter, primer_pair2, primer_args2);
        }
        Format_output.print_pair_array(printWriter, "TARGETS", seq_args2.num_targets, seq_args2.tar, primer_args2, seq_args2);
        Format_output.print_pair_array(printWriter, "EXCLUDED REGIONS", seq_args2.num_excl, seq_args2.excl, primer_args2, seq_args2);
        Format_output.print_pair_array(printWriter, "INTERNAL OLIGO EXCLUDED REGIONS", seq_args2.num_internal_excl, seq_args2.excl_internal, primer_args2, seq_args2);
    }

    private static void print_oligo_header(PrintWriter printWriter, String string, boolean bl) {
        printWriter.print(F.f(string, 16, (short)2) + "start  len      tm     gc%   any    3' ");
        if (bl) {
            printWriter.print("  rep ");
        }
        printWriter.print("seq\n");
    }

    private static void print_oligo(PrintWriter printWriter, String string, seq_args seq_args2, primer_rec primer_rec2, int n, primer_args primer_args2, seq_lib seq_lib2, boolean bl) {
        String string2 = FORWARD == n ? Primer3.pr_oligo_sequence(seq_args2, primer_rec2) : Primer3.pr_oligo_rev_c_sequence(seq_args2, primer_rec2);
        printWriter.print(F.f(string, 16, (short)2));
        printWriter.print(F.f(primer_rec2.start + seq_args2.incl_s + primer_args2.first_base_index, 5));
        printWriter.print(F.f(primer_rec2.length, 5));
        printWriter.print(F.f(primer_rec2.temp, 8, 1));
        printWriter.print(F.f(primer_rec2.gc_content, 8, 1));
        printWriter.print(F.f(0.01 * (double)primer_rec2.self_any, 6, 2));
        printWriter.print(F.f(0.01 * (double)primer_rec2.self_end, 6, 2));
        if (bl) {
            if (seq_lib2.repeat_file != null) {
                printWriter.print(" " + F.f(0.01 * (double)primer_rec2.repeat_sim.score[primer_rec2.repeat_sim.max], 5, 1));
            } else {
                printWriter.print("      ");
            }
        }
        printWriter.print(" " + string2 + "\n");
        if (Constants.PR_DEFAULT_INSIDE_PENALTY != primer_args2.inside_penalty || Constants.PR_DEFAULT_OUTSIDE_PENALTY != primer_args2.outside_penalty) {
            printWriter.print("POSITION PENALTY, QUALITY: " + primer_rec2.position_penalty + ", " + primer_rec2.quality + "\n");
        }
    }

    private static void print_pair_array(PrintWriter printWriter, String string, int n, int[][] nArray, primer_args primer_args2, seq_args seq_args2) {
        if (n > 0) {
            printWriter.print(string + " (start, len)*: ");
            for (int i = 0; i < n; ++i) {
                printWriter.print(nArray[i][0] + primer_args2.first_base_index + seq_args2.incl_s + "," + nArray[i][1] + " ");
            }
            printWriter.print("\n");
        }
    }

    private static void print_seq(PrintWriter printWriter, primer_args primer_args2, seq_args seq_args2, primer_rec primer_rec2, pair_array_t pair_array_t2, int n) {
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        primer_pair primer_pair2 = null;
        if (primer_args2.primer_task == task.pick_pcr_primers || primer_args2.primer_task == task.pick_pcr_primers_and_hyb_probe) {
            primer_pair2 = pair_array_t2.getPair(n);
        }
        int n3 = seq_args2.sequence.length();
        int[] nArray = new int[n3];
        char[] cArray = new char[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            cArray[n2] = 32;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            int n5;
            if (n2 < seq_args2.incl_s || n2 >= seq_args2.incl_s + seq_args2.incl_l) {
                int n6 = n2;
                nArray[n6] = nArray[n6] | 1;
            }
            if ((primer_args2.primer_task == task.pick_pcr_primers || primer_args2.primer_task == task.pick_pcr_primers_and_hyb_probe) && pair_array_t2.num_pairs() > 0) {
                if (n2 >= primer_pair2.left.start + seq_args2.incl_s && n2 < primer_pair2.left.start + primer_pair2.left.length + seq_args2.incl_s) {
                    int n7 = n2;
                    nArray[n7] = nArray[n7] | 2;
                }
                if (n2 >= primer_pair2.right.start - primer_pair2.right.length + 1 + seq_args2.incl_s && n2 <= primer_pair2.right.start + seq_args2.incl_s) {
                    int n8 = n2;
                    nArray[n8] = nArray[n8] | 4;
                }
                if (primer_args2.primer_task == 1 && n2 >= primer_pair2.intl.start + seq_args2.incl_s && n2 < primer_pair2.intl.start + primer_pair2.intl.length + seq_args2.incl_s) {
                    int n9 = n2;
                    nArray[n9] = nArray[n9] | 8;
                }
            } else if (primer_rec2 != null) {
                if (primer_args2.primer_task == task.pick_left_only && n2 < primer_rec2.start + primer_rec2.length + seq_args2.incl_s && n2 >= primer_rec2.start + seq_args2.incl_s) {
                    int n10 = n2;
                    nArray[n10] = nArray[n10] | 2;
                } else if (primer_args2.primer_task == task.pick_right_only && n2 >= primer_rec2.start - primer_rec2.length + 1 + seq_args2.incl_s && n2 <= primer_rec2.start + seq_args2.incl_s) {
                    int n11 = n2;
                    nArray[n11] = nArray[n11] | 4;
                } else if (primer_args2.primer_task == task.pick_hyb_probe_only && n2 >= primer_rec2.start + seq_args2.incl_s && n2 < primer_rec2.start + primer_rec2.length + seq_args2.incl_s) {
                    int n12 = n2;
                    nArray[n12] = nArray[n12] | 8;
                }
            }
            for (n5 = 0; n5 < seq_args2.num_targets; ++n5) {
                n4 = seq_args2.tar[n5][0] + seq_args2.incl_s;
                if (n2 < n4 || n2 >= n4 + seq_args2.tar[n5][1]) continue;
                int n13 = n2;
                nArray[n13] = nArray[n13] | 0x10;
            }
            for (n5 = 0; n5 < seq_args2.num_excl; ++n5) {
                n4 = seq_args2.excl[n5][0] + seq_args2.incl_s;
                if (n2 < n4 || n2 >= n4 + seq_args2.excl[n5][1]) continue;
                int n14 = n2;
                nArray[n14] = nArray[n14] | 0x20;
            }
            for (n5 = 0; n5 < seq_args2.num_internal_excl; ++n5) {
                n4 = seq_args2.excl_internal[n5][0] + seq_args2.incl_s;
                if (n2 < n4 || n2 >= n4 + seq_args2.excl_internal[n5][1]) continue;
                int n15 = n2;
                nArray[n15] = nArray[n15] | 0x40;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if ((nArray[n2] & 1) != 0) {
                bl2 = true;
                cArray[n2] = 46;
            } else if ((nArray[n2] & 0x20) != 0) {
                cArray[n2] = 88;
            } else if ((nArray[n2] & 0x40) != 0) {
                cArray[n2] = 120;
            } else if ((nArray[n2] & 0x10) != 0 && (nArray[n2] & 2) != 0) {
                cArray[n2] = 41;
            } else if ((nArray[n2] & 0x10) != 0 && (nArray[n2] & 4) != 0) {
                cArray[n2] = 40;
            } else if ((nArray[n2] & 0x10) != 0) {
                cArray[n2] = 42;
            } else if ((nArray[n2] & 2) != 0) {
                cArray[n2] = 62;
            } else if ((nArray[n2] & 4) != 0) {
                cArray[n2] = 60;
            } else if ((nArray[n2] & 8) != 0) {
                cArray[n2] = 94;
            }
            if (nArray[n2] == 0) continue;
            bl = true;
        }
        Format_output.print_seq_lines(printWriter, seq_args2.sequence, new String(cArray), n3, 60, bl, primer_args2);
        if (bl) {
            printWriter.print("KEYS (in order of precedence):\n");
        }
        if (bl2) {
            printWriter.print("...... vector sequence\n");
        }
        if (seq_args2.num_excl > 0) {
            printWriter.print("XXXXXX excluded region\n");
        }
        if (primer_args2.primer_task == 1 && seq_args2.num_internal_excl > 0) {
            printWriter.print("xxxxxx excluded region for internal oligo\n");
        }
        if (seq_args2.num_targets > 0) {
            printWriter.print("****** target\n");
        }
        if ((primer_args2.primer_task == task.pick_pcr_primers || primer_args2.primer_task == task.pick_pcr_primers_and_hyb_probe) && pair_array_t2.num_pairs() > 0) {
            printWriter.print(">>>>>> left primer\n");
            printWriter.print("<<<<<< right primer\n");
            if (primer_args2.primer_task == 1) {
                printWriter.print("^^^^^^ internal oligo\n");
            }
        } else if (primer_args2.primer_task == task.pick_left_only && primer_rec2 != null) {
            printWriter.print(">>>>>> left primer\n");
        } else if (primer_args2.primer_task == task.pick_right_only && primer_rec2 != null) {
            printWriter.print("<<<<<< right primer\n");
        } else if (primer_args2.primer_task == task.pick_hyb_probe_only && primer_rec2 != null) {
            printWriter.print("^^^^^^ internal oligo\n");
        }
        if (bl) {
            printWriter.print("\n");
        }
        nArray = null;
        cArray = null;
    }

    private static void print_seq_lines(PrintWriter printWriter, String string, String string2, int n, int n2, boolean bl, primer_args primer_args2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n > n2) {
            printWriter.print(F.f(n3 + primer_args2.first_base_index, 5) + " " + string.substring(n4, n4 + n2) + "\n");
            if (bl) {
                printWriter.print("      ");
                printWriter.print(string2.substring(n5, n5 + n2));
                printWriter.print("\n\n");
            }
            n -= n2;
            n4 += n2;
            n5 += n2;
            n3 += n2;
        }
        printWriter.print(F.f(n3 + primer_args2.first_base_index, 5) + " " + string.substring(n4) + "\n");
        if (bl) {
            printWriter.print("      " + string2.substring(n5) + "\n\n");
        }
        printWriter.print("\n");
    }

    private static void print_pair_info(PrintWriter printWriter, primer_pair primer_pair2, primer_args primer_args2) {
        printWriter.print("PRODUCT SIZE: " + primer_pair2.product_size + ", ");
        printWriter.print("PAIR ANY COMPL: " + F.f(0.01 * (double)primer_pair2.compl_any, 4, 2) + ", PAIR 3' COMPL: " + F.f(0.01 * (double)primer_pair2.compl_end, 4, 2) + "\n");
        if (primer_args2.product_max_tm != Constants.PR_DEFAULT_PRODUCT_MAX_TM || primer_args2.product_min_tm != Constants.PR_DEFAULT_PRODUCT_MIN_TM) {
            IO.stdout.print("PRODUCT Tm: " + F.f(primer_pair2.product_tm, 4, 1));
            IO.stdout.print("PRODUCT Tm - min(OLIGO Tm): " + F.f(primer_pair2.product_tm_oligo_tm_diff, 4, 1) + "\n");
        }
    }

    private static void print_rest(PrintWriter printWriter, primer_args primer_args2, seq_args seq_args2, pair_array_t pair_array_t2) {
        boolean bl = Format_output.lib_sim_specified(primer_args2);
        printWriter.print("ADDITIONAL OLIGOS\n");
        printWriter.print("   ");
        Format_output.print_oligo_header(printWriter, "", bl);
        for (int i = 1; i < pair_array_t2.num_pairs(); ++i) {
            printWriter.print(F.f(i, 3, (short)2));
            Format_output.print_oligo(printWriter, "LEFT PRIMER", seq_args2, pair_array_t2.getPair((int)i).left, FORWARD, primer_args2, primer_args2.repeat_lib, bl);
            printWriter.print("   ");
            Format_output.print_oligo(printWriter, "RIGHT PRIMER", seq_args2, pair_array_t2.getPair((int)i).right, REVERSE, primer_args2, primer_args2.repeat_lib, bl);
            if (primer_args2.primer_task == task.pick_pcr_primers_and_hyb_probe) {
                printWriter.print("   ");
                Format_output.print_oligo(printWriter, "INTERNAL OLIGO", seq_args2, pair_array_t2.getPair((int)i).intl, FORWARD, primer_args2, primer_args2.io_mishyb_library, bl);
            }
            printWriter.print("   ");
            Format_output.print_pair_info(printWriter, pair_array_t2.getPair(i), primer_args2);
            printWriter.print("\n");
        }
    }

    static void print_explain(PrintWriter printWriter, primer_args primer_args2, seq_args seq_args2, boolean bl) {
        if (!(primer_args2.pick_anyway && (task.pick_pcr_primers == primer_args2.primer_task && seq_args2.left_input != null && seq_args2.right_input != null || task.pick_pcr_primers_and_hyb_probe == primer_args2.primer_task && seq_args2.left_input != null && seq_args2.right_input != null && seq_args2.internal_input != null || task.pick_left_only == primer_args2.primer_task && seq_args2.left_input != null || task.pick_right_only == primer_args2.primer_task && seq_args2.right_input != null || task.pick_hyb_probe_only == primer_args2.primer_task && seq_args2.internal_input != null))) {
            if (bl) {
                printWriter.print("         con   too    in    in          no    tm    tm  high  high  high        high      \n");
                printWriter.print("         sid  many   tar  excl   bad    GC   too   too   any    3'   lib  ploy   end      \n");
                printWriter.print("        ered    Ns   get   reg   GC% clamp   low  high compl compl   sim     X  stab    ok\n");
            } else {
                printWriter.print("         con   too    in    in          no    tm    tm  high  high        high      \n");
                printWriter.print("         sid  many   tar  excl   bad    GC   too   too   any    3'  poly   end      \n");
                printWriter.print("        ered    Ns   get   reg   GC% clamp   low  high compl compl     X  stab    ok\n");
            }
        }
        if (!(task.pick_pcr_primers != primer_args2.primer_task && task.pick_left_only != primer_args2.primer_task && task.pick_pcr_primers_and_hyb_probe != primer_args2.primer_task || primer_args2.pick_anyway && seq_args2.left_input != null)) {
            Format_output.print_stat_line(printWriter, "Left", seq_args2.left_expl, bl);
        }
        if (!(task.pick_pcr_primers != primer_args2.primer_task && task.pick_right_only != primer_args2.primer_task && task.pick_pcr_primers_and_hyb_probe != primer_args2.primer_task || primer_args2.pick_anyway && seq_args2.right_input != null)) {
            Format_output.print_stat_line(printWriter, "Right", seq_args2.right_expl, bl);
        }
        if (!(task.pick_pcr_primers_and_hyb_probe != primer_args2.primer_task && task.pick_hyb_probe_only != primer_args2.primer_task || primer_args2.pick_anyway && seq_args2.internal_input != null)) {
            Format_output.print_stat_line(printWriter, "Intl", seq_args2.intl_expl, bl);
        }
        if (task.pick_pcr_primers == primer_args2.primer_task || task.pick_pcr_primers_and_hyb_probe == primer_args2.primer_task) {
            pair_stats pair_stats2 = seq_args2.pair_expl;
            Primer3.pr_print_pair_explain(printWriter, seq_args2);
        }
    }

    private static void print_stat_line(PrintWriter printWriter, String string, oligo_stats oligo_stats2, boolean bl) {
        printWriter.print(F.f(string, 6, (short)2));
        printWriter.print(F.f(oligo_stats2.considered, 6));
        printWriter.print(F.f(oligo_stats2.ns, 6));
        printWriter.print(F.f(oligo_stats2.target, 6));
        printWriter.print(F.f(oligo_stats2.excluded, 6));
        printWriter.print(F.f(oligo_stats2.gc, 6));
        printWriter.print(F.f(oligo_stats2.gc_clamp, 6));
        printWriter.print(F.f(oligo_stats2.temp_min, 6));
        printWriter.print(F.f(oligo_stats2.temp_max, 6));
        printWriter.print(F.f(oligo_stats2.compl_any, 6));
        printWriter.print(F.f(oligo_stats2.compl_end, 6));
        if (bl) {
            printWriter.print(F.f(oligo_stats2.repeat, 6));
        }
        printWriter.print(F.f(oligo_stats2.poly_x, 6));
        printWriter.print(F.f(oligo_stats2.stability, 6));
        printWriter.print(F.f(oligo_stats2.ok, 6));
        printWriter.print("\n");
    }

    private static boolean lib_sim_specified(primer_args primer_args2) {
        return primer_args2.repeat_lib.repeat_file != null || primer_args2.io_mishyb_library.repeat_file != null;
    }

    private static void print_oligo_summary(PrintWriter printWriter, primer_args primer_args2, seq_args seq_args2, Vector vector, int n, int n2) {
        int n3 = seq_args2.sequence.length();
        boolean bl = Format_output.lib_sim_specified(primer_args2);
        String string = n == oligo_type.OT_LEFT ? "LEFT_PRIMER" : (n == oligo_type.OT_RIGHT ? "RIGHT_PRIMER" : "INTERNAL_OLIGO");
        primer_rec primer_rec2 = (primer_rec)vector.elementAt(n2);
        Format_output.print_oligo_header(printWriter, "\n", bl);
        if (oligo_type.OT_LEFT == n || oligo_type.OT_INTL == n) {
            Format_output.print_oligo(printWriter, string, seq_args2, primer_rec2, FORWARD, primer_args2, primer_args2.repeat_lib, bl);
        } else {
            Format_output.print_oligo(printWriter, string, seq_args2, primer_rec2, REVERSE, primer_args2, primer_args2.repeat_lib, bl);
        }
        printWriter.print("SEQUENCE SIZE: " + n3 + "\n");
        printWriter.print("INCLUDED REGION SIZE: " + seq_args2.incl_l + "\n\n");
        Format_output.print_pair_array(printWriter, "TARGETS", seq_args2.num_targets, seq_args2.tar, primer_args2, seq_args2);
        Format_output.print_pair_array(printWriter, "EXCLUDED REGIONS", seq_args2.num_excl, seq_args2.excl, primer_args2, seq_args2);
        Format_output.print_pair_array(printWriter, "INTERNAL OLIGO EXCLUDED REGIONS", seq_args2.num_internal_excl, seq_args2.excl_internal, primer_args2, seq_args2);
    }
}

