/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.format;

import com.informagen.Sequence;
import com.informagen.Util;
import com.informagen.sa.AnalysisPanel;
import com.informagen.sa.PanelPrinter;
import com.informagen.sa.SAObject;
import com.informagen.sa.SequenceAnalysis;
import com.informagen.sa.format.CODATA;
import com.informagen.sa.format.EMBL;
import com.informagen.sa.format.FASTA;
import com.informagen.sa.format.GCG;
import com.informagen.sa.format.GenBank;
import com.informagen.sa.format.PIR;
import com.informagen.sa.format.Raw;
import com.informagen.sa.format.SequenceFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class FormatPanel
extends AnalysisPanel {
    private final Preferences preferences = Preferences.userNodeForPackage(this.getClass());
    private final JComboBox mFormatChoice = new JComboBox();
    private final JTextArea outputArea = new JTextArea();
    private SequenceFormatter mFormatter;

    public static String getAnalysisName() {
        return "Format";
    }

    public FormatPanel() {
        this.buildUI();
        this.wireUI();
        this.mFormatChoice.setSelectedItem(this.preferences.get("format", "FASTA"));
        this.doFormatChoice();
    }

    public boolean ignorePropertyChangeEvents() {
        return true;
    }

    public void changeSequence(SAObject sAObject, int[] nArray) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.selection = nArray;
        this.writeIt();
    }

    public void sequenceUnavailable() {
        this.saObject = null;
        this.sequence = null;
        this.selection = null;
        this.writeToOutputArea("");
    }

    public void sequenceChanged(SAObject sAObject) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.selection = null;
        this.writeIt();
    }

    public void selectionChanged(int[] nArray) {
        this.selection = nArray;
        this.writeIt();
    }

    public void selectionCancelled() {
        this.selection = null;
        this.writeIt();
    }

    public void cursorPositionChanged(int n) {
    }

    private void buildUI() {
        this.setLayout(new BorderLayout(5, 5));
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.mFormatChoice.addItem("FASTA");
        this.mFormatChoice.addItem("GCG");
        this.mFormatChoice.addItem("GenBank and IBI");
        this.mFormatChoice.addItem("EMBL and SwissProt");
        this.mFormatChoice.addItem("NBRF PIR");
        this.mFormatChoice.addItem("CODATA");
        this.mFormatChoice.addItem("Sequence only");
        this.mFormatChoice.setMaximumSize(this.mFormatChoice.getPreferredSize());
        jToolBar.add(this.mFormatChoice);
        this.add((Component)jToolBar, "North");
        this.outputArea.setFont(new Font("Courier", 0, Util.isWindows() ? 10 : 12));
        this.outputArea.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this.outputArea, 22, 30);
        this.add((Component)jScrollPane, "Center");
    }

    void wireUI() {
        this.mFormatChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    FormatPanel.this.doFormatChoice();
                    FormatPanel.this.preferences.put("format", (String)FormatPanel.this.mFormatChoice.getSelectedItem());
                }
            }
        });
    }

    private void doFormatChoice() {
        int n = this.mFormatChoice.getSelectedIndex();
        switch (n) {
            case 0: {
                this.mFormatter = new FASTA();
                break;
            }
            case 1: {
                this.mFormatter = new GCG();
                break;
            }
            case 2: {
                this.mFormatter = new GenBank();
                break;
            }
            case 3: {
                this.mFormatter = new EMBL();
                break;
            }
            case 4: {
                this.mFormatter = new PIR();
                break;
            }
            case 5: {
                this.mFormatter = new CODATA();
                break;
            }
            case 6: {
                this.mFormatter = new Raw();
            }
        }
        this.writeIt();
    }

    void writeIt() {
        if (this.sequence == null) {
            return;
        }
        if (this.workThread != null) {
            this.workThread.interrupt();
        }
        this.workThread = new Thread(){

            public void run() {
                Object object;
                FormatPanel.this.mFormatter.setCodeword(FormatPanel.this.sequence.getUID());
                if (FormatPanel.this.selection != null) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append(FormatPanel.this.sequence.getTitle() == null ? "" : FormatPanel.this.sequence.getTitle());
                    ((StringBuffer)object).append(FormatPanel.this.sequence.getTitle() == null ? "Selection: " : " (");
                    ((StringBuffer)object).append(FormatPanel.this.selection[0] + 1).append("-").append(FormatPanel.this.selection[1]);
                    ((StringBuffer)object).append(FormatPanel.this.sequence.getTitle() == null ? "" : ")");
                    FormatPanel.this.mFormatter.setTitle(((StringBuffer)object).toString());
                } else {
                    FormatPanel.this.mFormatter.setTitle(FormatPanel.this.sequence.getTitle());
                }
                if (FormatPanel.this.selection != null) {
                    object = FormatPanel.this.sequence.getSequence();
                    FormatPanel.this.mFormatter.setSequence(((String)object).substring(FormatPanel.this.selection[0], FormatPanel.this.selection[1]));
                } else {
                    FormatPanel.this.mFormatter.setSequence(FormatPanel.this.sequence.getSequence());
                }
                FormatPanel.this.mFormatter.isProtein(FormatPanel.this.sequence.isProtein());
                if (FormatPanel.this.selection != null) {
                    object = FormatPanel.this.sequence.createClone();
                    String string = FormatPanel.this.sequence.getSequence();
                    ((Sequence)object).setSequence(string.substring(FormatPanel.this.selection[0], FormatPanel.this.selection[1]));
                    FormatPanel.this.mFormatter.setMolWt(((Sequence)object).molwt());
                    object = null;
                } else {
                    FormatPanel.this.mFormatter.setMolWt(FormatPanel.this.sequence.molwt());
                }
                FormatPanel.this.writeToOutputArea(FormatPanel.this.mFormatter.format());
                FormatPanel.this.workThread = null;
            }
        };
        try {
            this.workThread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    void writeToOutputArea(final String string) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FormatPanel.this.outputArea.selectAll();
                    FormatPanel.this.outputArea.replaceSelection(string);
                    FormatPanel.this.outputArea.setCaretPosition(0);
                }
            });
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void printPanel() {
        String string = this.outputArea.getText();
        PanelPrinter panelPrinter = new PanelPrinter(string);
        panelPrinter.setPointSize(10);
        panelPrinter.print();
    }

    public void savePanel() {
        String string = this.outputArea.getText();
        String string2 = this.sequence != null ? this.sequence.getUID() : "";
        int n = this.mFormatChoice.getSelectedIndex();
        String string3 = ".seq";
        switch (n) {
            case 0: {
                string3 = ".fasta";
                break;
            }
            case 1: {
                string3 = ".gcg";
                break;
            }
            case 2: {
                string3 = this.sequence.isNucleic() ? ".seq" : ".pro";
                break;
            }
            case 3: {
                string3 = ".embl";
                break;
            }
            case 4: {
                string3 = ".nbrf";
                break;
            }
            case 5: {
                string3 = ".codata";
                break;
            }
            case 6: {
                string3 = this.sequence.isNucleic() ? ".seq" : ".pro";
            }
        }
        Frame frame = Util.thisFrame(this);
        SequenceAnalysis.saveText(frame, string, string2 + string3);
    }
}

