/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.structure;

import com.informagen.sa.structure.SequenceAnalyzer;

public abstract class SmoothingFilter
implements SequenceAnalyzer {
    public static final int RAW_DATA = 1;
    public static final int RUNNING_AVERAGE = 2;
    public static final int MEDIAN_SIEVE = 3;
    String mName;
    int mWindow;
    double[] mValues;
    int mFilterMethod = 2;
    double mGraphMin = 0.0;
    double mGraphMax = 0.0;
    double mCutoff = 0.0;

    public SmoothingFilter(int n) {
        this.setFilterMethod(n);
        this.createValueArray();
        this.setValues();
    }

    abstract void setValues();

    public void setFilterMethod(int n) {
        this.mFilterMethod = n;
    }

    public String getName() {
        return this.mName;
    }

    public double getGraphMin() {
        return this.mGraphMin;
    }

    public double getGraphMax() {
        return this.mGraphMax;
    }

    public double getGraphCutoff() {
        return this.mCutoff;
    }

    public double[] analyze(String string) {
        string = string.toUpperCase();
        double[] dArray = new double[]{0.0, 1.0};
        switch (this.mFilterMethod) {
            case 1: {
                dArray = this.rawData(string);
                break;
            }
            case 2: {
                dArray = this.runningAverage(string);
                break;
            }
            case 3: {
                dArray = this.medianSieve(string);
            }
        }
        return dArray;
    }

    protected void createValueArray() {
        this.mValues = new double[128];
        for (int i = 0; i < 128; ++i) {
            this.mValues[i] = 0.0;
        }
    }

    private double[] rawData(String string) {
        int n = string.length();
        char[] cArray = string.toCharArray();
        double[] dArray = new double[n];
        for (int i = 0; i < cArray.length; ++i) {
            dArray[i] = this.mValues[cArray[i]];
        }
        return dArray;
    }

    private double[] runningAverage(String string) {
        int n;
        int n2 = string.length();
        if (n2 < this.mWindow * 2) {
            return null;
        }
        char[] cArray = string.toCharArray();
        double[] dArray = new double[n2];
        double d = 0.0;
        for (n = 0; n < this.mWindow; ++n) {
            d += this.mValues[cArray[n]];
        }
        dArray[this.mWindow / 2] = d / (double)this.mWindow;
        for (n = 1; n < n2 - this.mWindow; ++n) {
            d -= this.mValues[cArray[n]];
            dArray[n + this.mWindow / 2] = (d += this.mValues[cArray[n + this.mWindow]]) / (double)this.mWindow;
        }
        return dArray;
    }

    private double[] medianSieve(String string) {
        int n;
        int n2 = string.length();
        if (n2 < this.mWindow * 2) {
            return null;
        }
        char[] cArray = string.toCharArray();
        double[] dArray = new double[n2];
        for (n = 0; n < cArray.length; ++n) {
            dArray[n] = this.mValues[cArray[n]];
        }
        for (n = 2; n <= this.mWindow; ++n) {
            dArray = this.sieve(dArray, n);
        }
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }

    private double[] sieve(double[] dArray, int n) {
        int n2;
        int n3 = dArray.length;
        int n4 = n - 1;
        int n5 = n3 + 2 * n4;
        double[] dArray2 = new double[n5];
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            dArray2[n4 + n2] = dArray[n2];
        }
        for (n2 = 0; n2 < n4; ++n2) {
            dArray2[n4 + n3 + n2] = 0.0;
            dArray2[n2] = 0.0;
        }
        int n6 = 2 * n - 1;
        for (n2 = 0; n2 < n3; ++n2) {
            double[] dArray3 = new double[n6];
            for (int i = 0; i < n6; ++i) {
                dArray3[i] = dArray2[n2 + i];
            }
            this.sort(dArray3);
            dArray2[n2] = dArray3[n - 1];
        }
        return dArray2;
    }

    private void sort(double[] dArray) {
        int n = dArray.length;
        for (int i = n / 2; i > 0; --i) {
            this.downheap(dArray, i, n);
        }
        do {
            double d = dArray[0];
            dArray[0] = dArray[n - 1];
            dArray[n - 1] = d;
            this.downheap(dArray, 1, --n);
        } while (n > 1);
    }

    private void downheap(double[] dArray, int n, int n2) {
        double d = dArray[n - 1];
        while (n <= n2 / 2) {
            int n3 = n + n;
            if (n3 < n2 && dArray[n3 - 1] < dArray[n3]) {
                ++n3;
            }
            if (d >= dArray[n3 - 1]) break;
            dArray[n - 1] = dArray[n3 - 1];
            n = n3;
        }
        dArray[n - 1] = d;
    }
}

