/*
 * Decompiled with CFR 0.152.
 */
package neobio.alignment;

import neobio.alignment.AlignmentBlock;
import neobio.alignment.CrochemoreLandauZivUkelson;
import neobio.alignment.Factor;
import neobio.alignment.IncompatibleScoringSchemeException;
import neobio.alignment.LocalAlignmentBlock;
import neobio.alignment.PairwiseAlignment;

public class CrochemoreLandauZivUkelsonLocalAlignment
extends CrochemoreLandauZivUkelson {
    protected static final byte TYPE_CROSSING_PATH = 0;
    protected static final byte TYPE_S_PATH = 1;
    protected static final byte TYPE_C_PATH = 2;
    protected static final byte TYPE_E_PATH = 3;
    protected int max_score;
    protected int max_row;
    protected int max_col;
    protected byte max_path_type;
    protected int max_source_index;

    protected AlignmentBlock createBlock(Factor factor, Factor factor2, int n, int n2) throws IncompatibleScoringSchemeException {
        int n3;
        int n4;
        int n5;
        int n6 = factor.length();
        int n7 = factor2.length();
        int n8 = n6 + n7 + 1;
        LocalAlignmentBlock localAlignmentBlock = new LocalAlignmentBlock(factor, factor2, n8);
        LocalAlignmentBlock localAlignmentBlock2 = (LocalAlignmentBlock)this.getLeftPrefix(localAlignmentBlock);
        LocalAlignmentBlock localAlignmentBlock3 = (LocalAlignmentBlock)this.getDiagonalPrefix(localAlignmentBlock);
        LocalAlignmentBlock localAlignmentBlock4 = (LocalAlignmentBlock)this.getTopPrefix(localAlignmentBlock);
        int n9 = this.scoreInsertion(factor2.getNewChar());
        int n10 = this.scoreSubstitution(factor.getNewChar(), factor2.getNewChar());
        int n11 = this.scoreDeletion(factor.getNewChar());
        int n12 = 0;
        while (n12 < n8) {
            int n13 = Integer.MIN_VALUE;
            int n14 = Integer.MIN_VALUE;
            n5 = Integer.MIN_VALUE;
            int n15 = Integer.MIN_VALUE;
            n4 = Integer.MIN_VALUE;
            if (n12 < n8 - 1) {
                n4 = localAlignmentBlock2.dist_column[n12] + n9;
                n14 = localAlignmentBlock2.E_path_score[n12];
            }
            if (n12 > 0 && n12 < n8 - 1) {
                n15 = localAlignmentBlock3.dist_column[n12 - 1] + n10;
            }
            if (n12 > 0) {
                n5 = localAlignmentBlock4.dist_column[n12 - 1] + n11;
                n13 = localAlignmentBlock4.E_path_score[n12 - 1];
            }
            localAlignmentBlock.dist_column[n12] = n3 = this.max(n4, n15, n5);
            localAlignmentBlock.direction[n12] = n3 == n4 ? 1 : (n3 == n15 ? 2 : 3);
            localAlignmentBlock.E_path_score[n12] = n3 = this.max(n14, localAlignmentBlock.dist_column[n12], n13);
            if (n3 == n14) {
                localAlignmentBlock.E_path_ancestor[n12] = localAlignmentBlock2.E_path_ancestor[n12];
                localAlignmentBlock.E_path_ancestor_index[n12] = localAlignmentBlock2.E_path_ancestor_index[n12];
            } else if (n3 == localAlignmentBlock.dist_column[n12]) {
                localAlignmentBlock.E_path_ancestor[n12] = localAlignmentBlock;
                localAlignmentBlock.E_path_ancestor_index[n12] = n12;
            } else {
                localAlignmentBlock.E_path_ancestor[n12] = localAlignmentBlock4.E_path_ancestor[n12 - 1];
                localAlignmentBlock.E_path_ancestor_index[n12] = localAlignmentBlock4.E_path_ancestor_index[n12 - 1];
            }
            if (n12 < n7) {
                localAlignmentBlock.S_path_score[n12] = localAlignmentBlock2.S_path_score[n12];
            } else if (n12 == n7) {
                n4 = localAlignmentBlock2.S_path_score[n12 - 1] + n9;
                n15 = localAlignmentBlock3.S_path_score[n12 - 1] + n10;
                n5 = localAlignmentBlock4.S_path_score[n12] + n11;
                localAlignmentBlock.S_path_score[n12] = n3 = this.max(0, n4, n15, n5);
                localAlignmentBlock.S_direction = n3 == n4 ? (byte)1 : (n3 == n15 ? (byte)2 : (n3 == n5 ? (byte)3 : (byte)0));
            } else {
                localAlignmentBlock.S_path_score[n12] = localAlignmentBlock4.S_path_score[n12 - 1];
            }
            ++n12;
        }
        this.computeOutputBorder(localAlignmentBlock, n, n2, n8, n7, n6);
        n4 = localAlignmentBlock2.C;
        n5 = localAlignmentBlock4.C;
        localAlignmentBlock.C = n3 = this.max(n4, localAlignmentBlock.S_path_score[n7], n5);
        if (localAlignmentBlock.C > this.max_score) {
            this.max_score = localAlignmentBlock.C;
            this.max_row = n;
            this.max_col = n2;
            this.max_path_type = (byte)2;
        }
        return localAlignmentBlock;
    }

    protected AlignmentBlock createRootBlock(Factor factor, Factor factor2) {
        this.max_score = 0;
        this.max_col = 0;
        this.max_row = 0;
        this.max_path_type = (byte)2;
        return new LocalAlignmentBlock(factor, factor2);
    }

    protected AlignmentBlock createFirstRowBlock(Factor factor, Factor factor2, int n) throws IncompatibleScoringSchemeException {
        int n2 = 0;
        int n3 = factor2.length();
        int n4 = n2 + n3 + 1;
        LocalAlignmentBlock localAlignmentBlock = new LocalAlignmentBlock(factor, factor2, n4);
        LocalAlignmentBlock localAlignmentBlock2 = (LocalAlignmentBlock)this.getLeftPrefix(localAlignmentBlock);
        int n5 = this.scoreInsertion(factor2.getNewChar());
        int n6 = 0;
        while (n6 < n3) {
            localAlignmentBlock.dist_column[n6] = localAlignmentBlock2.dist_column[n6] + n5;
            localAlignmentBlock.direction[n6] = 1;
            localAlignmentBlock.S_path_score[n6] = localAlignmentBlock2.S_path_score[n6];
            localAlignmentBlock.E_path_score[n6] = localAlignmentBlock2.E_path_score[n6];
            localAlignmentBlock.E_path_ancestor[n6] = localAlignmentBlock2.E_path_ancestor[n6];
            localAlignmentBlock.E_path_ancestor_index[n6] = localAlignmentBlock2.E_path_ancestor_index[n6];
            if (localAlignmentBlock.dist_column[n6] > localAlignmentBlock.E_path_score[n6]) {
                localAlignmentBlock.E_path_score[n6] = localAlignmentBlock.dist_column[n6];
                localAlignmentBlock.E_path_ancestor[n6] = localAlignmentBlock;
                localAlignmentBlock.E_path_ancestor_index[n6] = n6;
            }
            ++n6;
        }
        localAlignmentBlock.dist_column[n3] = 0;
        localAlignmentBlock.E_path_score[n3] = 0;
        localAlignmentBlock.direction[n3] = 0;
        localAlignmentBlock.E_path_ancestor[n3] = localAlignmentBlock;
        localAlignmentBlock.E_path_ancestor_index[n3] = n3;
        localAlignmentBlock.S_direction = 1;
        localAlignmentBlock.S_path_score[n3] = localAlignmentBlock2.S_path_score[n3 - 1] + n5;
        if (localAlignmentBlock.S_path_score[n3] <= 0) {
            localAlignmentBlock.S_path_score[n3] = 0;
            localAlignmentBlock.S_direction = 0;
        }
        this.computeOutputBorder(localAlignmentBlock, 0, n, n4, n3, n2);
        localAlignmentBlock.C = this.max(localAlignmentBlock2.C, localAlignmentBlock.S_path_score[n3]);
        if (localAlignmentBlock.C > this.max_score) {
            this.max_score = localAlignmentBlock.C;
            this.max_row = 0;
            this.max_col = n;
            this.max_path_type = (byte)2;
        }
        return localAlignmentBlock;
    }

    protected AlignmentBlock createFirstColumnBlock(Factor factor, Factor factor2, int n) throws IncompatibleScoringSchemeException {
        int n2 = factor.length();
        int n3 = 0;
        int n4 = n2 + n3 + 1;
        LocalAlignmentBlock localAlignmentBlock = new LocalAlignmentBlock(factor, factor2, n4);
        LocalAlignmentBlock localAlignmentBlock2 = (LocalAlignmentBlock)this.getTopPrefix(localAlignmentBlock);
        int n5 = this.scoreDeletion(factor.getNewChar());
        localAlignmentBlock.dist_column[0] = 0;
        localAlignmentBlock.E_path_score[0] = 0;
        localAlignmentBlock.direction[0] = 0;
        localAlignmentBlock.E_path_ancestor[0] = localAlignmentBlock;
        localAlignmentBlock.E_path_ancestor_index[0] = 0;
        localAlignmentBlock.S_direction = (byte)3;
        localAlignmentBlock.S_path_score[0] = localAlignmentBlock2.S_path_score[0] + n5;
        if (localAlignmentBlock.S_path_score[0] <= 0) {
            localAlignmentBlock.S_path_score[0] = 0;
            localAlignmentBlock.S_direction = 0;
        }
        int n6 = 1;
        while (n6 < n4) {
            localAlignmentBlock.dist_column[n6] = localAlignmentBlock2.dist_column[n6 - 1] + n5;
            localAlignmentBlock.direction[n6] = 3;
            localAlignmentBlock.S_path_score[n6] = localAlignmentBlock2.S_path_score[n6 - 1];
            localAlignmentBlock.E_path_score[n6] = localAlignmentBlock2.E_path_score[n6 - 1];
            localAlignmentBlock.E_path_ancestor[n6] = localAlignmentBlock2.E_path_ancestor[n6 - 1];
            localAlignmentBlock.E_path_ancestor_index[n6] = localAlignmentBlock2.E_path_ancestor_index[n6 - 1];
            if (localAlignmentBlock.dist_column[n6] > localAlignmentBlock.E_path_score[n6]) {
                localAlignmentBlock.E_path_score[n6] = localAlignmentBlock.dist_column[n6];
                localAlignmentBlock.E_path_ancestor[n6] = localAlignmentBlock;
                localAlignmentBlock.E_path_ancestor_index[n6] = n6;
            }
            ++n6;
        }
        this.computeOutputBorder(localAlignmentBlock, n, 0, n4, n3, n2);
        localAlignmentBlock.C = this.max(localAlignmentBlock.S_path_score[n3], localAlignmentBlock2.C);
        if (localAlignmentBlock.C > this.max_score) {
            this.max_score = localAlignmentBlock.C;
            this.max_row = n;
            this.max_col = 0;
            this.max_path_type = (byte)2;
        }
        return localAlignmentBlock;
    }

    protected void computeOutputBorder(LocalAlignmentBlock localAlignmentBlock, int n, int n2, int n3, int n4, int n5) {
        int[] nArray = this.assembleInputBorder(n3, n, n2, n5);
        int[][] nArray2 = this.assembleDistMatrix(localAlignmentBlock, n3, n, n2, n4);
        this.out_matrix.setData(nArray2, nArray, n3, n4);
        this.smawk.computeColumnMaxima(this.out_matrix, localAlignmentBlock.source_path);
        int n6 = 0;
        while (n6 < n3) {
            localAlignmentBlock.path_type[n6] = 0;
            localAlignmentBlock.output_border[n6] = this.out_matrix.valueAt(localAlignmentBlock.source_path[n6], n6);
            if (localAlignmentBlock.S_path_score[n6] >= localAlignmentBlock.output_border[n6]) {
                localAlignmentBlock.output_border[n6] = localAlignmentBlock.S_path_score[n6];
                localAlignmentBlock.path_type[n6] = 1;
            }
            if (nArray[n6] + localAlignmentBlock.E_path_score[n6] > this.max_score) {
                this.max_score = nArray[n6] + localAlignmentBlock.E_path_score[n6];
                this.max_row = n;
                this.max_col = n2;
                this.max_source_index = n6;
                this.max_path_type = (byte)3;
            }
            ++n6;
        }
    }

    protected PairwiseAlignment buildOptimalAlignment() throws IncompatibleScoringSchemeException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        LocalAlignmentBlock localAlignmentBlock = (LocalAlignmentBlock)this.block_table[this.max_row][this.max_col];
        if (this.max_path_type == 2) {
            this.traverseS_Path(localAlignmentBlock, stringBuffer, stringBuffer2, stringBuffer3);
        } else {
            this.traverseBlockCrossingPath(localAlignmentBlock, stringBuffer, stringBuffer2, stringBuffer3);
        }
        return new PairwiseAlignment(stringBuffer.toString(), stringBuffer2.toString(), stringBuffer3.toString(), this.locateScore());
    }

    protected void traverseBlockCrossingPath(LocalAlignmentBlock localAlignmentBlock, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) throws IncompatibleScoringSchemeException {
        int n = this.max_row;
        int n2 = this.max_col;
        int n3 = this.max_source_index;
        LocalAlignmentBlock localAlignmentBlock2 = localAlignmentBlock.E_path_ancestor[n3];
        int n4 = localAlignmentBlock.E_path_ancestor_index[n3];
        this.traverseBlock(localAlignmentBlock2, n4, stringBuffer, stringBuffer2, stringBuffer3);
        while (true) {
            int n5;
            if (n == 0) {
                n5 = this.block_table[n][--n2].factor2.length();
            } else if (n2 == 0) {
                --n;
                n5 = 0;
            } else if (n3 < localAlignmentBlock.factor1.length()) {
                n5 = this.block_table[n][--n2].factor2.length() + n3;
            } else if (n3 == localAlignmentBlock.factor1.length()) {
                n5 = this.block_table[--n][--n2].factor2.length();
            } else {
                --n;
                n5 = n3 - localAlignmentBlock.factor1.length();
            }
            if (n <= 0 && n2 <= 0) break;
            localAlignmentBlock = (LocalAlignmentBlock)this.block_table[n][n2];
            if (localAlignmentBlock.path_type[n5] == 1) {
                localAlignmentBlock2 = (LocalAlignmentBlock)localAlignmentBlock.ancestor[n5];
                this.traverseS_Path(localAlignmentBlock2, stringBuffer, stringBuffer2, stringBuffer3);
                break;
            }
            n3 = localAlignmentBlock.source_path[n5];
            localAlignmentBlock2 = (LocalAlignmentBlock)localAlignmentBlock.ancestor[n5];
            n4 = n3;
            if (n5 > localAlignmentBlock.factor2.length()) {
                n4 -= localAlignmentBlock.factor1.length() - localAlignmentBlock2.factor1.length();
            }
            this.traverseBlock(localAlignmentBlock2, n4, stringBuffer, stringBuffer2, stringBuffer3);
        }
    }

    protected void traverseS_Path(LocalAlignmentBlock localAlignmentBlock, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) throws IncompatibleScoringSchemeException {
        while (localAlignmentBlock.S_direction != 0) {
            char c = localAlignmentBlock.factor1.getNewChar();
            char c2 = localAlignmentBlock.factor2.getNewChar();
            switch (localAlignmentBlock.S_direction) {
                case 1: {
                    stringBuffer.insert(0, '-');
                    stringBuffer2.insert(0, ' ');
                    stringBuffer3.insert(0, c2);
                    localAlignmentBlock = (LocalAlignmentBlock)this.getLeftPrefix(localAlignmentBlock);
                    break;
                }
                case 2: {
                    stringBuffer.insert(0, c);
                    if (c == c2) {
                        if (this.useMatchTag()) {
                            stringBuffer2.insert(0, '|');
                        } else {
                            stringBuffer2.insert(0, c);
                        }
                    } else if (this.scoreSubstitution(c, c2) > 0) {
                        stringBuffer2.insert(0, '+');
                    } else {
                        stringBuffer2.insert(0, ' ');
                    }
                    stringBuffer3.insert(0, c2);
                    localAlignmentBlock = (LocalAlignmentBlock)this.getDiagonalPrefix(localAlignmentBlock);
                    break;
                }
                case 3: {
                    stringBuffer.insert(0, c);
                    stringBuffer2.insert(0, ' ');
                    stringBuffer3.insert(0, '-');
                    localAlignmentBlock = (LocalAlignmentBlock)this.getTopPrefix(localAlignmentBlock);
                }
            }
        }
    }

    protected int locateScore() {
        return this.max_score;
    }
}

