/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class FileSpec {
    public static final int DEFAULTBUFFERSIZE = 1000000;
    public static final String NEXTKEY = "$NEXTDATA";
    public static final byte[] NEXTKEYBYTES = "$NEXTDATA".getBytes();
    public static final byte CLEARBYTE = 32;
    public String name;
    public String pathname;
    public String fcsVersion;
    Vector textSegments;
    public static final int FCSPREAMBLESIZE = 58;
    public static final int FCSVERSIONSIZE = 10;
    public static final int FCSOFFSETSIZE = 8;

    public FileSpec(String xpath) {
        this.pathname = xpath;
        this.name = this.getNameFromPath(xpath);
        this.readHeaders();
    }

    public boolean readHeaders() {
        RandomAccessFile finp = null;
        boolean status = true;
        byte[] preamble = new byte[58];
        if (preamble == null) {
            return false;
        }
        this.textSegments = new Vector();
        long nextData = 0L;
        try {
            try {
                finp = new RandomAccessFile(this.pathname, "r");
                while (true) {
                    long thisData = nextData;
                    finp.seek(thisData);
                    finp.read(preamble);
                    int offset = 0;
                    this.fcsVersion = new String(preamble, offset, 10);
                    if (this.fcsVersion.indexOf("FCS") < 0) {
                        throw new FileNotFoundException("FileNotFCSType");
                    }
                    long hdrStrt = thisData + Long.parseLong(new String(preamble, offset += 10, 8).trim());
                    long hdrEnd = thisData + 1L + Long.parseLong(new String(preamble, offset += 8, 8).trim());
                    byte[] header = new byte[(int)(hdrEnd - hdrStrt)];
                    finp.seek(hdrStrt);
                    if (finp.read(header) != header.length) {
                        status = false;
                    }
                    byte dlt = header[0];
                    TextSegment aSeg = new TextSegment(hdrStrt, hdrEnd, header);
                    this.addTextSegment(aSeg);
                    nextData = FileSpec.extractL(header, NEXTKEYBYTES, dlt);
                    if (nextData == 0L) {
                        break;
                    }
                    nextData += thisData;
                }
            }
            catch (Exception e) {
                status = false;
                try {
                    finp.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                finp.close();
            }
            catch (Exception exception) {}
        }
        return status;
    }

    public static boolean isFCS(String path) {
        FileInputStream finp = null;
        boolean result = false;
        byte[] preamb = new byte[10];
        if (preamb == null) {
            return result;
        }
        try {
            finp = new FileInputStream(path);
            if (finp.read(preamb) == 10) {
                result = true;
            }
            finp.close();
        }
        catch (Exception ex) {
            try {
                finp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = false;
        }
        if (result) {
            String fcsV = new String(preamb, 0, 10);
            if (fcsV.indexOf("FCS") != 0) {
                result = false;
            } else {
                try {
                    Float version = Float.valueOf(fcsV.substring(3));
                }
                catch (Exception ex2) {
                    result = false;
                }
            }
        }
        return result;
    }

    public boolean clearKeys(String[] keys) {
        if (keys != null && this.textSegments != null) {
            int n = 0;
            while (n < this.textSegments.size()) {
                TextSegment aSeg = (TextSegment)this.textSegments.get(n);
                int i = 0;
                while (i < keys.length) {
                    this.replaceVal(aSeg.getText(), keys[i].getBytes());
                    ++i;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public boolean writeNew(String preText, String outFolder) {
        String outPath;
        FileInputStream finp = null;
        FileOutputStream fos = null;
        boolean status = true;
        String newName = String.valueOf(preText) + this.name;
        if (outFolder == null) {
            outFolder = this.getFolderFromPath(this.pathname);
        }
        if ((outPath = this.completePath(outFolder, newName)) == null || new File(outPath).exists()) {
            return false;
        }
        try {
            try {
                int datasize;
                byte[] buffer = new byte[1000000];
                finp = new FileInputStream(this.pathname);
                fos = new FileOutputStream(outPath);
                long hdrStrt = 0L;
                long hdrEnd = 0L;
                int i = 0;
                while (i < this.textSegments.size()) {
                    TextSegment aSeg = (TextSegment)this.textSegments.get(i);
                    if (aSeg != null) {
                        hdrStrt = aSeg.getStart();
                        if ((int)(hdrStrt - hdrEnd) > buffer.length) {
                            buffer = new byte[(int)(hdrStrt - hdrEnd)];
                        }
                        this.readBuffer(finp, buffer, (int)(hdrStrt - hdrEnd));
                        fos.write(buffer, 0, (int)(hdrStrt - hdrEnd));
                        hdrEnd = aSeg.getEnd();
                        finp.skip(hdrEnd - hdrStrt);
                        fos.write(aSeg.getText());
                    }
                    ++i;
                }
                while ((datasize = this.readBuffer(finp, buffer, buffer.length)) > 0) {
                    fos.write(buffer, 0, datasize);
                }
            }
            catch (Exception ex) {
                status = false;
                try {
                    if (finp != null) {
                        finp.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (finp != null) {
                    finp.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
        return status;
    }

    private void addTextSegment(TextSegment aSeg) {
        if (aSeg != null && this.textSegments != null) {
            int i = 0;
            while (i < this.textSegments.size()) {
                TextSegment thisSeg = (TextSegment)this.textSegments.get(i);
                if (thisSeg != null && thisSeg.getStart() > aSeg.getStart()) {
                    this.textSegments.insertElementAt(aSeg, i);
                    return;
                }
                ++i;
            }
            this.textSegments.add(aSeg);
            return;
        }
    }

    public Vector getTextSegments() {
        return this.textSegments;
    }

    public static String find(byte[] a, byte[] b, byte c) {
        int j = 0;
        int i = 1;
        while (i < a.length - b.length) {
            j = 0;
            while (j < b.length) {
                if (b[j] != a[i + j]) break;
                ++j;
            }
            if (j == b.length && a[i - 1] == c && a[i + j] == c) break;
            ++i;
        }
        if (j < b.length) {
            return null;
        }
        i += j + 1;
        j = i;
        while (j < a.length) {
            if (a[j] == c) break;
            ++j;
        }
        if (j >= a.length) {
            return null;
        }
        return new String(a, i, j - i);
    }

    public static String extractS(byte[] a, byte[] b, byte c) {
        return FileSpec.find(a, b, c);
    }

    public static long extractL(byte[] a, byte[] b, byte c) {
        long val = 0L;
        String valS = FileSpec.find(a, b, c).trim();
        try {
            val = Long.parseLong(valS);
        }
        catch (Exception ex) {
            val = 0L;
        }
        return val;
    }

    private void replaceVal(byte[] hdr, byte[] key) {
        this.replaceVal(hdr, key, null);
    }

    /*
     * Unable to fully structure code
     */
    private void replaceVal(byte[] hdr, byte[] key, byte[] val) {
        if (hdr == null || key == null || hdr.length == 0 || key.length == 0) {
            return;
        }
        j = 0;
        dlt = hdr[0];
        i = 1;
        while (i <= hdr.length - key.length) {
            j = 0;
            while (j < key.length) {
                if (key[j] != hdr[i + j]) break;
                ++j;
            }
            if (i + j >= hdr.length) {
                return;
            }
            if (j == key.length && hdr[i - 1] == dlt && hdr[i + j] == dlt) break;
            ++i;
        }
        if (j < key.length) {
            return;
        }
        i += j + 1;
        j = i;
        while (j < hdr.length) {
            if (hdr[j] == dlt) break;
            ++j;
        }
        if (j < hdr.length) ** GOTO lbl29
        return;
lbl-1000:
        // 1 sources

        {
            hdr[i] = val == null || i < j - val.length ? 32 : val[i - j + val.length];
            ++i;
lbl29:
            // 2 sources

            ** while (i < j)
        }
lbl30:
        // 1 sources

    }

    private int readBuffer(FileInputStream finp, byte[] buffer, int len) throws IOException {
        int offset = 0;
        while (len > 0) {
            int numB = finp.read(buffer, offset, len);
            if (numB <= 0) break;
            offset += numB;
            len -= numB;
        }
        return offset;
    }

    private String getFolderFromPath(String path) {
        Object dir = null;
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(File.separatorChar);
        if (index > 0) {
            return path.substring(0, index);
        }
        return null;
    }

    private String completePath(String dir, String name) {
        if (dir == null || name == null) {
            return null;
        }
        if ((dir = dir.trim()).endsWith(String.valueOf(File.separatorChar))) {
            return String.valueOf(dir) + name;
        }
        return String.valueOf(dir) + File.separatorChar + name;
    }

    private String getNameFromPath(String path) {
        if (path == null || path.length() <= 0) {
            return null;
        }
        int index = path.lastIndexOf(File.separatorChar);
        if (index > 0) {
            return path.substring(index + 1);
        }
        return null;
    }
}

