/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.client;

import ghidra.framework.Application;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.model.ServerInfo;
import ghidra.framework.remote.AnonymousCallback;
import ghidra.framework.remote.GhidraPrincipal;
import ghidra.framework.remote.GhidraServerHandle;
import ghidra.framework.remote.InetNameLookup;
import ghidra.framework.remote.RMIServerPortFactory;
import ghidra.framework.remote.RemoteRepositoryServerHandle;
import ghidra.framework.remote.SSHSignatureCallback;
import ghidra.framework.remote.SignatureCallback;
import ghidra.net.ApplicationKeyManagerFactory;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashSet;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

class ServerConnectTask
extends Task {
    private ServerInfo server;
    private boolean allowLoginRetry;
    private RemoteRepositoryServerHandle hdl;
    private Exception exc;

    ServerConnectTask(ServerInfo server, boolean allowLoginRetry) {
        super("Connecting to " + server.getServerName(), false, false, true);
        this.server = server;
        this.allowLoginRetry = allowLoginRetry;
    }

    public void run(TaskMonitor monitor) {
        try {
            this.hdl = this.getRepositoryServerHandle(ClientUtil.getUserName());
        }
        catch (RemoteException e) {
            this.exc = e;
            Throwable t = e.getCause();
            if (t instanceof Exception) {
                this.exc = (Exception)t;
            }
        }
        catch (Exception e) {
            this.exc = e;
        }
    }

    Exception getException() {
        return this.exc;
    }

    RemoteRepositoryServerHandle getRepositoryServerHandle() {
        return this.hdl;
    }

    private static Subject getLocalUserSubject() {
        String username = ClientUtil.getUserName();
        HashSet<GhidraPrincipal> pset = new HashSet<GhidraPrincipal>();
        HashSet emptySet = new HashSet();
        pset.add(new GhidraPrincipal(username));
        Subject subj = new Subject(false, pset, emptySet, emptySet);
        return subj;
    }

    private static String getPreferredHostname(String name) {
        try {
            return InetNameLookup.getCanonicalHostName(name);
        }
        catch (UnknownHostException e) {
            Msg.warn(ServerConnectTask.class, (Object)("Failed to resolve hostname for " + name));
            return name;
        }
    }

    private static boolean isSSLHandshakeCancelled(SSLHandshakeException e) throws IOException {
        if (e.getMessage().indexOf("bad_certificate") > 0) {
            if (ApplicationKeyManagerFactory.getPreferredKeyStore() == null) {
                throw new IOException("User PKI Certificate not installed", e);
            }
            return true;
        }
        return false;
    }

    public static GhidraServerHandle getGhidraServerHandle(ServerInfo server) throws IOException {
        GhidraServerHandle gsh = null;
        try {
            Registry reg;
            ServerConnectTask.testServerSSLConnection(server);
            try {
                reg = LocateRegistry.getRegistry(server.getServerName(), server.getPortNumber());
                ServerConnectTask.checkServerBindNames(reg);
            }
            catch (IOException e) {
                reg = LocateRegistry.getRegistry(server.getServerName(), server.getPortNumber(), new SslRMIClientSocketFactory());
                ServerConnectTask.checkServerBindNames(reg);
            }
            gsh = (GhidraServerHandle)reg.lookup("GhidraServer9.0");
            gsh.checkCompatibility(11);
        }
        catch (NotBoundException e) {
            throw new IOException(e.getMessage());
        }
        catch (SSLHandshakeException e) {
            if (ServerConnectTask.isSSLHandshakeCancelled(e)) {
                return null;
            }
            throw e;
        }
        catch (RemoteException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnmarshalException || cause instanceof ClassNotFoundException) {
                throw new RemoteException("Incompatible Ghidra Server interface version");
            }
            if (cause instanceof SSLHandshakeException && ServerConnectTask.isSSLHandshakeCancelled((SSLHandshakeException)cause)) {
                return null;
            }
            throw e;
        }
        return gsh;
    }

    private RemoteRepositoryServerHandle getRepositoryServerHandle(String defaultUserID) throws IOException, LoginException {
        GhidraServerHandle gsh = ServerConnectTask.getGhidraServerHandle(this.server);
        if (gsh == null) {
            return null;
        }
        Callback[] callbacks = null;
        try {
            boolean loopOK = this.allowLoginRetry;
            String loginError = null;
            callbacks = gsh.getAuthenticationCallbacks();
            SignatureCallback pkiSignatureCb = null;
            boolean hasSSHSignatureCallback = false;
            if (callbacks != null) {
                for (Callback cb : callbacks) {
                    if (cb instanceof SignatureCallback) {
                        pkiSignatureCb = (SignatureCallback)cb;
                        continue;
                    }
                    if (!(cb instanceof SSHSignatureCallback)) continue;
                    hasSSHSignatureCallback = true;
                }
            }
            String serverName = ServerConnectTask.getPreferredHostname(this.server.getServerName());
            AnonymousCallback onlyAnonymousCb = null;
            while (true) {
                Callback[] rsh;
                block30: {
                    try {
                        if (callbacks != null) {
                            if (onlyAnonymousCb != null) {
                                onlyAnonymousCb.setAnonymousAccessRequested(true);
                                loopOK = false;
                            } else if (callbacks.length == 1 && callbacks[0] instanceof AnonymousCallback) {
                                onlyAnonymousCb = (AnonymousCallback)callbacks[0];
                                loopOK = true;
                            } else if (hasSSHSignatureCallback && ClientUtil.isSSHKeyAvailable()) {
                                hasSSHSignatureCallback = false;
                                ClientUtil.processSSHSignatureCallback(callbacks, serverName, defaultUserID);
                            } else if (pkiSignatureCb != null) {
                                if (!ApplicationKeyManagerFactory.initialize()) {
                                    throw new IOException("Client PKI certificate has not been installed");
                                }
                                if (ApplicationKeyManagerFactory.usingGeneratedSelfSignedCertificate()) {
                                    Msg.warn((Object)((Object)this), (Object)"Server connect - client is using self-signed PKI certificate");
                                }
                                loopOK = false;
                                ClientUtil.processSignatureCallback(serverName, pkiSignatureCb);
                            } else if (!ClientUtil.processPasswordCallbacks(callbacks, serverName, defaultUserID, loginError)) {
                                RemoteRepositoryServerHandle remoteRepositoryServerHandle = null;
                                return remoteRepositoryServerHandle;
                            }
                        } else {
                            loopOK = false;
                        }
                        rsh = gsh.getRepositoryServer(ServerConnectTask.getLocalUserSubject(), callbacks);
                        if (!rsh.isReadOnly()) break block30;
                    }
                    catch (FailedLoginException e) {
                        try {
                            if (loopOK) {
                                loginError = "Access denied: " + this.server;
                                continue;
                            }
                            throw e;
                        }
                        catch (AccessException e2) {
                            throw new IOException(e2.getMessage());
                        }
                    }
                    Msg.showInfo((Object)((Object)this), null, (String)"Anonymous Server Login", (Object)("You have been logged-in anonymously to " + serverName + "\nRead-only permission is granted to repositories which allow anonymous access"));
                }
                Callback[] callbackArray = rsh;
                return callbackArray;
            }
        }
        finally {
            if (callbacks != null) {
                for (Callback callback : callbacks) {
                    if (!(callback instanceof PasswordCallback)) continue;
                    ((PasswordCallback)callback).clearPassword();
                }
            }
        }
    }

    private static void testServerSSLConnection(ServerInfo server) throws IOException {
        RMIServerPortFactory portFactory = new RMIServerPortFactory(server.getPortNumber());
        SslRMIClientSocketFactory factory = new SslRMIClientSocketFactory();
        String serverName = server.getServerName();
        int sslRmiPort = portFactory.getRMISSLPort();
        try (SSLSocket socket = (SSLSocket)factory.createSocket(serverName, sslRmiPort);){
            socket.startHandshake();
        }
    }

    private static void checkServerBindNames(Registry reg) throws RemoteException {
        Object requiredVersion = "9.0";
        if (!Application.getApplicationVersion().startsWith((String)requiredVersion)) {
            requiredVersion = (String)requiredVersion + " - " + Application.getApplicationVersion();
        }
        String[] regList = reg.list();
        RemoteException exc = null;
        int badVerCount = 0;
        for (String name : regList) {
            if (name.equals("GhidraServer9.0")) {
                return;
            }
            if (!name.startsWith("GhidraServer")) continue;
            String version = name.substring("GhidraServer".length());
            if (version.length() == 0) {
                version = "4.3.x (or older)";
            }
            exc = new RemoteException("Incompatible Ghidra Server interface, detected interface version " + version + ",\nthis client requires server version " + (String)requiredVersion);
            ++badVerCount;
        }
        if (exc != null) {
            if (badVerCount == 1) {
                throw exc;
            }
            throw new RemoteException("Incompatible Ghidra Server interface, detected " + badVerCount + " incompatible server versions,\nthis client requires server version " + (String)requiredVersion);
        }
        throw new RemoteException("Ghidra Server not found.");
    }
}

