/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.data;

import db.DBHandle;
import db.util.ErrorHandler;
import ghidra.framework.model.DomainFile;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypePath;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.model.data.TraceBasedDataTypeManager;
import ghidra.util.InvalidNameException;
import ghidra.util.UniversalID;
import ghidra.util.database.DBOpenMode;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceDataTypeManager
extends DataTypeManagerDB
implements TraceBasedDataTypeManager,
DBTraceManager {
    protected final ReadWriteLock lock;
    protected final DBTrace trace;

    public DBTraceDataTypeManager(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, DBTrace trace) throws CancelledException, VersionException, IOException {
        super(dbh, null, openMode.toInteger(), (ErrorHandler)trace, trace.getLock(), monitor);
        this.lock = lock;
        this.trace = trace;
    }

    @Override
    public void invalidateCache(boolean all) {
        super.invalidateCache();
    }

    public String getName() {
        return this.trace.getName();
    }

    public void setName(String name) throws InvalidNameException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException("Name must be at least one character long: " + name);
        }
        this.trace.setName(name);
        this.categoryRenamed(CategoryPath.ROOT, this.getCategory(CategoryPath.ROOT));
    }

    public void sourceArchiveChanged(UniversalID sourceArchiveID) {
        super.sourceArchiveChanged(sourceArchiveID);
        this.trace.sourceArchiveChanged(sourceArchiveID);
    }

    protected void sourceArchiveAdded(UniversalID sourceArchiveID) {
        super.sourceArchiveAdded(sourceArchiveID);
        this.trace.sourceArchiveAdded(sourceArchiveID);
    }

    public void dataTypeChanged(DataType dataType, boolean isAutoChange) {
        super.dataTypeChanged(dataType, isAutoChange);
        if (!this.isCreatingDataType()) {
            this.trace.getCodeManager().invalidateCache(false);
            this.trace.getSymbolManager().invalidateCache(false);
            this.trace.dataTypeChanged(this.getID(dataType), dataType);
        }
    }

    protected void dataTypeAdded(DataType addedType, DataType sourceType) {
        super.dataTypeAdded(addedType, sourceType);
        this.trace.dataTypeAdded(this.getID(addedType), addedType);
    }

    protected void dataTypeReplaced(long replacedID, DataTypePath replacedPath, DataType replacementType) {
        super.dataTypeReplaced(replacedID, replacedPath, replacementType);
        this.trace.dataTypeReplaced(replacedID, replacedPath, replacementType.getDataTypePath());
    }

    protected void dataTypeMoved(DataType type, DataTypePath oldPath, DataTypePath newPath) {
        super.dataTypeMoved(type, oldPath, newPath);
        this.trace.dataTypeMoved(this.getID(type), oldPath, newPath);
    }

    protected void dataTypeNameChanged(DataType type, String oldName) {
        super.dataTypeNameChanged(type, oldName);
        this.trace.dataTypeNameChanged(this.getID(type), oldName, type.getName());
    }

    protected void dataTypeDeleted(long deletedID, DataTypePath deletedPath) {
        super.dataTypeDeleted(deletedID, deletedPath);
        this.trace.dataTypeDeleted(deletedID, deletedPath);
    }

    protected void categoryCreated(Category createdCategory) {
        super.categoryCreated(createdCategory);
        this.trace.categoryAdded(createdCategory.getID(), createdCategory);
    }

    protected void categoryMoved(CategoryPath oldPath, Category category) {
        super.categoryMoved(oldPath, category);
        this.trace.categoryMoved(category.getID(), oldPath, category.getCategoryPath());
    }

    protected void categoryRenamed(CategoryPath oldPath, Category category) {
        super.categoryRenamed(oldPath, category);
        this.trace.categoryRenamed(category.getID(), oldPath.getName(), category.getName());
    }

    protected void categoryRemoved(Category parent, String name, long deletedID) {
        super.categoryRemoved(parent, name, deletedID);
        this.trace.categoryDeleted(deletedID, new CategoryPath(parent.getCategoryPath(), new String[]{name}));
    }

    protected void replaceDataTypeIDs(long oldID, long newID) {
        if (oldID == newID) {
            return;
        }
        this.trace.getCodeManager().replaceDataTypes(oldID, newID);
        this.trace.getSymbolManager().replaceDataTypes(oldID, newID);
    }

    protected void deleteDataTypeIDs(LinkedList<Long> deletedIds, TaskMonitor monitor) throws CancelledException {
        this.trace.getCodeManager().clearData(deletedIds, monitor);
        this.trace.getSymbolManager().invalidateCache(false);
    }

    public boolean isUpdatable() {
        return this.trace.isChangeable();
    }

    public int startTransaction(String description) {
        return this.trace.startTransaction(description);
    }

    public void flushEvents() {
        this.trace.flushEvents();
    }

    public void endTransaction(int transactionID, boolean commit) {
        this.trace.endTransaction(transactionID, commit);
    }

    public void close() {
    }

    @Override
    public DBTrace getTrace() {
        return this.trace;
    }

    public DomainFile getDomainFile() {
        return this.trace.getDomainFile();
    }

    protected String getDomainFileID() {
        DomainFile domainFile = this.trace.getDomainFile();
        return domainFile == null ? null : domainFile.getFileID();
    }

    public String getPath() {
        DomainFile domainFile = this.trace.getDomainFile();
        return domainFile == null ? null : domainFile.getPathname();
    }

    public ArchiveType getType() {
        return ArchiveType.PROGRAM;
    }

    public DataOrganization getDataOrganization() {
        if (this.dataOrganization == null) {
            this.dataOrganization = this.trace.getBaseCompilerSpec().getDataOrganization();
        }
        return this.dataOrganization;
    }
}

