/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.CachedAddressSetView;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.listing.AbstractSingleDBTraceCodeUnitsView;
import ghidra.trace.database.listing.DBTraceCodeManager;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.UndefinedDBTraceData;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.listing.TraceUndefinedDataView;
import ghidra.util.DifferenceAddressSetView;
import ghidra.util.IntersectionAddressSetView;
import ghidra.util.LockHold;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public class DBTraceUndefinedDataView
extends AbstractSingleDBTraceCodeUnitsView<UndefinedDBTraceData>
implements TraceUndefinedDataView {
    protected static final int CACHE_MAX_SNAPS = 5;
    protected final DBTraceCodeManager manager;
    protected final Map<Long, CachedAddressSetView> cache = CacheBuilder.newBuilder().removalListener(this::cacheEntryRemoved).maximumSize(5L).build().asMap();

    public DBTraceUndefinedDataView(DBTraceCodeSpace space) {
        super(space);
        this.manager = space.manager;
    }

    private void cacheEntryRemoved(RemovalNotification<Long, CachedAddressSetView> rn) {
    }

    protected UndefinedDBTraceData doCreateUnit(long snap, Address address) {
        this.space.assertInSpace(address);
        return this.manager.doCreateUndefinedUnit(snap, address, this.space.getThread(), this.space.getFrameLevel());
    }

    @Override
    public int size() {
        return 0;
    }

    protected AddressSetView doGetAddressSetView(long snap) {
        return (AddressSetView)this.cache.computeIfAbsent(snap, t -> new CachedAddressSetView((AddressSetView)new DifferenceAddressSetView((AddressSetView)new AddressSet(this.space.all), this.space.definedUnits.getAddressSetView((long)t))));
    }

    @Override
    public boolean containsAddress(long snap, Address address) {
        return this.doGetAddressSetView(snap).contains(address);
    }

    @Override
    public boolean coversRange(Range<Long> lifespan, AddressRange range) {
        return !this.space.definedUnits.intersectsRange(lifespan, range);
    }

    @Override
    public boolean intersectsRange(Range<Long> lifespan, AddressRange range) {
        return !this.space.definedUnits.coversRange(lifespan, range);
    }

    @Override
    public UndefinedDBTraceData getFloor(long snap, Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            Iterator iterator = this.get(snap, address, false).iterator();
            if (iterator.hasNext()) {
                UndefinedDBTraceData u;
                UndefinedDBTraceData undefinedDBTraceData = u = (UndefinedDBTraceData)iterator.next();
                return undefinedDBTraceData;
            }
            iterator = null;
            return iterator;
        }
    }

    @Override
    public UndefinedDBTraceData getContaining(long snap, Address address) {
        return this.getAt(snap, address);
    }

    @Override
    public UndefinedDBTraceData getAt(long snap, Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            if (this.doGetAddressSetView(snap).contains(address)) {
                UndefinedDBTraceData undefinedDBTraceData = this.doCreateUnit(snap, address);
                return undefinedDBTraceData;
            }
            UndefinedDBTraceData undefinedDBTraceData = null;
            return undefinedDBTraceData;
        }
    }

    @Override
    public UndefinedDBTraceData getCeiling(long snap, Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            Iterator iterator = this.get(snap, address, true).iterator();
            if (iterator.hasNext()) {
                UndefinedDBTraceData u;
                UndefinedDBTraceData undefinedDBTraceData = u = (UndefinedDBTraceData)iterator.next();
                return undefinedDBTraceData;
            }
            iterator = null;
            return iterator;
        }
    }

    @Override
    public Iterable<? extends UndefinedDBTraceData> get(long snap, Address min, Address max, boolean forward) {
        AddressIterator ait = this.getAddressSetView(snap, (AddressRange)new AddressRangeImpl(min, max)).getAddresses(forward);
        return () -> this.lambda$get$2((Iterator)ait, snap);
    }

    @Override
    public Iterable<? extends UndefinedDBTraceData> getIntersecting(TraceAddressSnapRange tasr) {
        Iterator itIt = Iterators.transform(DBTraceUtils.iterateSpan(tasr.getLifespan()), snap -> this.get((long)snap, tasr.getX1(), tasr.getX2(), true).iterator());
        return () -> Iterators.concat((Iterator)itIt);
    }

    @Override
    public AddressSetView getAddressSetView(long snap, AddressRange within) {
        return new IntersectionAddressSetView((AddressSetView)new AddressSet(within), this.doGetAddressSetView(snap));
    }

    public void invalidateCache() {
        this.cache.clear();
    }

    private /* synthetic */ Iterator lambda$get$2(Iterator ait, long snap) {
        return Iterators.transform((Iterator)ait, a -> this.doCreateUnit(snap, (Address)a));
    }
}

