/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.stack;

import db.DBHandle;
import generic.NestedIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.stack.DBTraceStack;
import ghidra.trace.database.stack.DBTraceStackFrame;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.Trace;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.stack.TraceStackManager;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBOpenMode;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceStackManager
implements TraceStackManager,
DBTraceManager {
    protected final DBHandle dbh;
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBTraceThreadManager threadManager;
    protected final DBTraceOverlaySpaceAdapter overlayAdapter;
    protected final DBCachedObjectStore<DBTraceStack> stackStore;
    protected final DBCachedObjectIndex<DBTraceStack.ThreadSnap, DBTraceStack> stacksByThreadSnap;
    protected final DBCachedObjectStore<DBTraceStackFrame> frameStore;
    protected final DBCachedObjectIndex<Address, DBTraceStackFrame> framesByPC;

    public DBTraceStackManager(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, DBTrace trace, DBTraceThreadManager threadManager, DBTraceOverlaySpaceAdapter overlayAdapter) throws VersionException, IOException {
        this.dbh = dbh;
        this.lock = lock;
        this.trace = trace;
        this.threadManager = threadManager;
        this.overlayAdapter = overlayAdapter;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.stackStore = factory.getOrCreateCachedStore("Stacks", DBTraceStack.class, (s, r) -> new DBTraceStack(this, s, r), true);
        this.stacksByThreadSnap = this.stackStore.getIndex(DBTraceStack.ThreadSnap.class, DBTraceStack.THREAD_SNAP_COLUMN);
        this.frameStore = factory.getOrCreateCachedStore("StackFrames", DBTraceStackFrame.class, (s, r) -> new DBTraceStackFrame(this, s, r), true);
        this.framesByPC = this.frameStore.getIndex(Address.class, DBTraceStackFrame.PC_COLUMN);
    }

    @Override
    public void invalidateCache(boolean all) {
        this.stackStore.invalidateCache();
        this.frameStore.invalidateCache();
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    public DBTraceStack getStackByKey(long stackKey) {
        return (DBTraceStack)this.stackStore.getObjectAt(stackKey);
    }

    public DBTraceStackFrame getFrameByKey(long frameKey) {
        return (DBTraceStackFrame)this.frameStore.getObjectAt(frameKey);
    }

    @Override
    public DBTraceStack getStack(TraceThread thread, long snap, boolean createIfAbsent) {
        DBTraceThread dbThread = this.threadManager.assertIsMine(thread);
        DBTraceStack.ThreadSnap key = new DBTraceStack.ThreadSnap(thread.getKey(), snap);
        if (createIfAbsent) {
            DBTraceStack stack;
            try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
                stack = (DBTraceStack)this.stacksByThreadSnap.getOne((Object)key);
                if (stack != null) {
                    DBTraceStack dBTraceStack = stack;
                    return dBTraceStack;
                }
                stack = (DBTraceStack)this.stackStore.create();
                stack.set(dbThread, snap);
            }
            this.trace.setChanged(new TraceChangeRecord(Trace.TraceStackChangeType.ADDED, null, stack));
            return stack;
        }
        return (DBTraceStack)this.stacksByThreadSnap.getOne((Object)key);
    }

    @Override
    public DBTraceStack getLatestStack(TraceThread thread, long snap) {
        this.threadManager.assertIsMine(thread);
        DBTraceStack found = (DBTraceStack)this.stacksByThreadSnap.floorValue((Object)new DBTraceStack.ThreadSnap(thread.getKey(), snap));
        if (found == null) {
            return null;
        }
        if (found.getThread() != thread || found.getSnap() > snap) {
            return null;
        }
        return found;
    }

    @Override
    public Iterable<TraceStackFrame> getFramesIn(AddressSetView set) {
        return () -> NestedIterator.start((Iterator)set.iterator(), rng -> this.framesByPC.sub((Object)rng.getMinAddress(), true, (Object)rng.getMaxAddress(), true).values().iterator());
    }

    protected void deleteStack(DBTraceStack stack) {
        this.stackStore.delete((DBAnnotatedObject)stack);
    }

    protected DBTraceStackFrame createFrame(DBTraceStack stack) {
        DBTraceStackFrame frame = (DBTraceStackFrame)this.frameStore.create();
        frame.set(stack);
        return frame;
    }

    protected void deleteFrame(DBTraceStackFrame frame) {
        this.frameStore.delete((DBAnnotatedObject)frame);
    }
}

