/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.thread;

import com.google.common.collect.Range;
import db.DBHandle;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.thread.TraceThreadManager;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBOpenMode;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceThreadManager
implements TraceThreadManager,
DBTraceManager {
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBCachedObjectStore<DBTraceThread> threadStore;
    protected final DBCachedObjectIndex<String, DBTraceThread> threadsByPath;

    public DBTraceThreadManager(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, DBTrace trace) throws IOException, VersionException {
        this.lock = lock;
        this.trace = trace;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.threadStore = factory.getOrCreateCachedStore("Threads", DBTraceThread.class, (s, r) -> new DBTraceThread(this, s, r), true);
        this.threadsByPath = this.threadStore.getIndex(String.class, DBTraceThread.PATH_COLUMN);
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        this.threadStore.invalidateCache();
    }

    public DBTraceThread assertIsMine(TraceThread thread) {
        if (!(thread instanceof DBTraceThread)) {
            throw new IllegalArgumentException("Thread " + thread + " is not part of this trace");
        }
        DBTraceThread dbThread = (DBTraceThread)thread;
        if (dbThread.manager != this) {
            throw new IllegalArgumentException("Thread " + thread + " is not part of this trace");
        }
        if (!this.getAllThreads().contains(dbThread)) {
            throw new IllegalArgumentException("Thread " + thread + " is not part of this trace");
        }
        return dbThread;
    }

    protected void checkConflictingPath(DBTraceThread ignore, String path, Range<Long> lifespan) throws DuplicateNameException {
        for (DBTraceThread pc : this.threadsByPath.get((Object)path)) {
            if (pc == ignore || !DBTraceUtils.intersect(pc.getLifespan(), lifespan)) continue;
            throw new DuplicateNameException("A thread having path '" + path + "' already exists within an overlapping snap");
        }
    }

    @Override
    public DBTraceThread addThread(String path, Range<Long> lifespan) throws DuplicateNameException {
        return this.addThread(path, path, (Range)lifespan);
    }

    @Override
    public DBTraceThread addThread(String path, String display, Range<Long> lifespan) throws DuplicateNameException {
        DBTraceThread thread;
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.checkConflictingPath(null, path, lifespan);
            thread = (DBTraceThread)this.threadStore.create();
            thread.set(path, display, lifespan);
        }
        this.trace.setChanged(new TraceChangeRecord(Trace.TraceThreadChangeType.ADDED, null, thread));
        return thread;
    }

    public Collection<? extends DBTraceThread> getAllThreads() {
        return Collections.unmodifiableCollection(this.threadStore.asMap().values());
    }

    public Collection<? extends DBTraceThread> getThreadsByPath(String path) {
        return Collections.unmodifiableCollection(this.threadsByPath.get((Object)path));
    }

    @Override
    public DBTraceThread getLiveThreadByPath(long snap, String path) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            DBTraceThread dBTraceThread = this.threadsByPath.get((Object)path).stream().filter(t -> t.getLifespan().contains((Comparable)Long.valueOf(snap))).findAny().orElse(null);
            return dBTraceThread;
        }
    }

    @Override
    public DBTraceThread getThread(long key) {
        return (DBTraceThread)this.threadStore.getObjectAt(key);
    }

    public Collection<? extends DBTraceThread> getLiveThreads(long snap) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            LinkedHashSet<DBTraceThread> result = new LinkedHashSet<DBTraceThread>();
            for (DBTraceThread thread : this.threadStore.asMap().values()) {
                if (thread.getCreationSnap() > snap || snap >= thread.getDestructionSnap()) continue;
                result.add(thread);
            }
            LinkedHashSet<DBTraceThread> linkedHashSet = result;
            return linkedHashSet;
        }
    }

    public void deleteThread(DBTraceThread thread) {
        this.threadStore.delete((DBAnnotatedObject)thread);
        this.trace.setChanged(new TraceChangeRecord(Trace.TraceThreadChangeType.DELETED, null, thread));
    }
}

