/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.time.schedule;

import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.trace.model.time.schedule.CompareResult;
import ghidra.trace.model.time.schedule.Step;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.help.UnsupportedOperationException;

public class PatchStep
implements Step {
    protected final long threadKey;
    protected final String sleigh;
    protected final int hashCode;

    public static PatchStep parse(long threadKey, String stepSpec) {
        if (!stepSpec.startsWith("{") || !stepSpec.endsWith("}")) {
            throw new IllegalArgumentException("Cannot parse step: '" + stepSpec + "'");
        }
        return new PatchStep(threadKey, stepSpec.substring(1, stepSpec.length() - 1));
    }

    public PatchStep(long threadKey, String sleigh) {
        this.threadKey = threadKey;
        this.sleigh = Objects.requireNonNull(sleigh);
        this.hashCode = Objects.hash(threadKey, sleigh);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PatchStep)) {
            return false;
        }
        PatchStep that = (PatchStep)obj;
        if (this.threadKey != that.threadKey) {
            return false;
        }
        return this.sleigh.equals(that.sleigh);
    }

    public String toString() {
        if (this.threadKey == -1L) {
            return "{" + this.sleigh + "}";
        }
        return String.format("t%d-{%s}", this.threadKey, this.sleigh);
    }

    @Override
    public int getTypeOrder() {
        return 10;
    }

    @Override
    public boolean isNop() {
        return this.sleigh.length() == 0;
    }

    @Override
    public long getThreadKey() {
        return this.threadKey;
    }

    @Override
    public long getTickCount() {
        return 0L;
    }

    @Override
    public long getPatchCount() {
        return 1L;
    }

    @Override
    public boolean isCompatible(Step step) {
        return false;
    }

    @Override
    public void addTo(Step step) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Step subtract(Step step) {
        if (this.equals(step)) {
            return Step.nop();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Step clone() {
        return new PatchStep(this.threadKey, this.sleigh);
    }

    @Override
    public long rewind(long count) {
        return count - 1L;
    }

    @Override
    public CompareResult compareStep(Step step) {
        CompareResult result = this.compareStepType(step);
        if (result != CompareResult.EQUALS) {
            return result;
        }
        PatchStep that = (PatchStep)step;
        result = CompareResult.unrelated(Long.compare(this.threadKey, that.threadKey));
        if (result != CompareResult.EQUALS) {
            return result;
        }
        result = CompareResult.unrelated(this.sleigh.compareTo(that.sleigh));
        if (result != CompareResult.EQUALS) {
            return result;
        }
        return CompareResult.EQUALS;
    }

    @Override
    public <T> void execute(PcodeThread<T> emuThread, Consumer<PcodeThread<T>> stepAction, TaskMonitor monitor) throws CancelledException {
        PcodeProgram prog = emuThread.getMachine().compileSleigh("schedule", List.of(this.sleigh + ";"));
        emuThread.getExecutor().execute(prog, emuThread.getUseropLibrary());
    }
}

