/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceChangeType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DefaultTraceChangeType<T, U>
implements TraceChangeType<T, U> {
    private static int nextType = 986578944;
    private static final Map<Integer, String> TYPE_NAMES = new HashMap<Integer, String>();
    private static final Set<Field> FIELD_BACKLOG = new HashSet<Field>();
    private final int type = DefaultTraceChangeType.nextType();

    private static void procType(Field f, TraceChangeType<?, ?> type) {
        String kind = f.getDeclaringClass().getSimpleName();
        if (kind.startsWith("Trace")) {
            kind = kind.substring("Trace".length());
        }
        if (kind.endsWith("ChangeType")) {
            kind = kind.substring(0, kind.length() - "ChangeType".length());
        }
        TYPE_NAMES.put(type.getType(), kind + "." + f.getName());
    }

    private static <C extends TraceChangeType<?, ?>> void procField(Field f, Class<C> cls, boolean isBacklog) {
        TraceChangeType type;
        int mods = f.getModifiers();
        if (!Modifier.isStatic(mods) || !Modifier.isFinal(mods)) {
            return;
        }
        if (!cls.isAssignableFrom(f.getType())) {
            return;
        }
        try {
            type = (TraceChangeType)cls.cast(f.get(null));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        if (type != null) {
            DefaultTraceChangeType.procType(f, type);
        } else {
            if (isBacklog) {
                throw new AssertionError();
            }
            FIELD_BACKLOG.add(f);
        }
    }

    private static void procBacklog() {
        Iterator<Field> fit = FIELD_BACKLOG.iterator();
        while (fit.hasNext()) {
            Field f = fit.next();
            DefaultTraceChangeType.procField(f, f.getType(), true);
            fit.remove();
        }
    }

    private static <C extends TraceChangeType<?, ?>> void scanTypeNames(Class<C> cls) {
        for (Field f : cls.getFields()) {
            DefaultTraceChangeType.procField(f, cls, false);
        }
    }

    public static String getName(int type) {
        DefaultTraceChangeType.procBacklog();
        String name = TYPE_NAMES.get(type);
        if (name != null) {
            return name;
        }
        return "TYPE_0x" + Integer.toHexString(type);
    }

    private static int nextType() {
        return nextType++;
    }

    public DefaultTraceChangeType() {
        DefaultTraceChangeType.scanTypeNames(this.getClass());
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getSubType() {
        return 0;
    }

    public TraceChangeRecord<T, U> cast(DomainObjectChangeRecord rec) {
        return (TraceChangeRecord)rec;
    }
}

