/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import ghidra.framework.model.DomainObjectClosedListener;
import ghidra.framework.model.DomainObjectException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.TraceTimeManager;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.trace.util.TraceTimeViewport;
import ghidra.util.LockHold;
import ghidra.util.MergeSortingIterator;
import ghidra.util.Msg;
import ghidra.util.UnionAddressSetView;
import ghidra.util.UniqIterator;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.exception.ClosedException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DefaultTraceTimeViewport
implements TraceTimeViewport {
    protected final Trace trace;
    protected final List<Range<Long>> ordered = new ArrayList<Range>(List.of(Range.singleton((Comparable)Long.valueOf(0L))));
    protected final RangeSet<Long> spanSet = TreeRangeSet.create();
    protected final ForSnapshotsListener listener = new ForSnapshotsListener();
    protected final ListenerSet<Runnable> changeListeners = new ListenerSet(Runnable.class);
    protected long snap = 0L;

    public DefaultTraceTimeViewport(Trace trace) {
        this.trace = trace;
        trace.addCloseListener(this.listener);
        trace.addListener(this.listener);
    }

    @Override
    public void addChangeListener(Runnable l) {
        this.changeListeners.add((Object)l);
    }

    @Override
    public void removeChangeListener(Runnable l) {
        this.changeListeners.remove((Object)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAnyUpper(Range<Long> range) {
        try (LockHold hold = this.trace.lockRead();){
            List<Range<Long>> list = this.ordered;
            synchronized (list) {
                for (Range intersecting : this.spanSet.subRangeSet(range).asRanges()) {
                    if (!range.contains((Comparable)((Long)intersecting.upperEndpoint()))) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean isCompletelyVisible(AddressRange range, Range<Long> lifespan, T object, TraceTimeViewport.Occlusion<T> occlusion) {
        try (LockHold hold = this.trace.lockRead();){
            List<Range<Long>> list = this.ordered;
            synchronized (list) {
                boolean bl;
                for (Range<Long> rng : this.ordered) {
                    if (lifespan.contains((Comparable)((Long)rng.upperEndpoint()))) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    if (!occlusion.occluded(object, range, rng)) continue;
                    bl = false;
                }
                return bl;
                boolean bl3 = false;
                return bl3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> AddressSet computeVisibleParts(AddressSetView set, Range<Long> lifespan, T object, TraceTimeViewport.Occlusion<T> occlusion) {
        try (LockHold hold = this.trace.lockRead();){
            if (!this.containsAnyUpper(lifespan)) {
                AddressSet addressSet = new AddressSet();
                return addressSet;
            }
            AddressSet remains = new AddressSet(set);
            List<Range<Long>> list = this.ordered;
            synchronized (list) {
                Iterator<Range<Long>> iterator = this.ordered.iterator();
                do {
                    if (!iterator.hasNext()) throw new AssertionError();
                    Range<Long> rng = iterator.next();
                    if (lifespan.contains((Comparable)((Long)rng.upperEndpoint()))) {
                        AddressSet addressSet = remains;
                        return addressSet;
                    }
                    occlusion.remove(object, remains, rng);
                } while (!remains.isEmpty());
                AddressSet addressSet = remains;
                return addressSet;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLower(long lower) {
        try (LockHold hold = this.trace.lockRead();){
            List<Range<Long>> list = this.ordered;
            synchronized (list) {
                Range range = this.spanSet.rangeContaining((Comparable)Long.valueOf(lower));
                if (range == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = (Long)range.lowerEndpoint() == lower;
                return bl;
            }
        }
    }

    protected static boolean addSnapRange(long lower, long upper, RangeSet<Long> spanSet, List<Range<Long>> ordered) {
        if (spanSet.contains((Comparable)Long.valueOf(lower))) {
            return false;
        }
        Range range = Range.closed((Comparable)Long.valueOf(lower), (Comparable)Long.valueOf(upper));
        spanSet.add(range);
        ordered.add((Range<Long>)range);
        return true;
    }

    protected static TraceSnapshot locateMostRecentFork(TraceTimeManager timeManager, long from) {
        TraceSnapshot prev;
        while (true) {
            if ((prev = timeManager.getMostRecentSnapshot(from)) == null) {
                return null;
            }
            TraceSchedule prevSched = prev.getSchedule();
            long prevKey = prev.getKey();
            if (prevSched == null) {
                if (prevKey == Long.MIN_VALUE) {
                    return null;
                }
                from = prevKey - 1L;
                continue;
            }
            long forkedSnap = prevSched.getSnap();
            if (forkedSnap != prevKey - 1L) break;
            --from;
        }
        return prev;
    }

    protected static void collectForkRanges(TraceTimeManager timeManager, long curSnap, RangeSet<Long> spanSet, List<Range<Long>> ordered) {
        while (true) {
            TraceSnapshot fork;
            long prevSnap;
            long l = prevSnap = (fork = DefaultTraceTimeViewport.locateMostRecentFork(timeManager, curSnap)) == null ? Long.MIN_VALUE : fork.getKey();
            if (!DefaultTraceTimeViewport.addSnapRange(prevSnap, curSnap, spanSet, ordered)) {
                return;
            }
            if (fork == null) {
                return;
            }
            curSnap = fork.getSchedule().getSnap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshSnapRanges() {
        TreeRangeSet spanSet = TreeRangeSet.create();
        ArrayList<Range<Long>> ordered = new ArrayList<Range<Long>>();
        try (LockHold hold = this.trace.lockRead();){
            DefaultTraceTimeViewport.collectForkRanges(this.trace.getTimeManager(), this.snap, (RangeSet<Long>)spanSet, ordered);
            List<Range<Long>> list = this.ordered;
            synchronized (list) {
                this.spanSet.clear();
                this.ordered.clear();
                this.spanSet.addAll((RangeSet)spanSet);
                this.ordered.addAll(ordered);
            }
        }
        assert (!ordered.isEmpty());
        ((Runnable)this.changeListeners.fire).run();
    }

    public void setSnap(long snap) {
        if (this.snap == snap) {
            return;
        }
        this.snap = snap;
        this.refreshSnapRanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkSnapshotAddedNeedsRefresh(TraceSnapshot snapshot) {
        try (LockHold hold = this.trace.lockRead();){
            List<Range<Long>> list = this.ordered;
            synchronized (list) {
                block13: {
                    if (snapshot.getSchedule() != null) break block13;
                    boolean bl = false;
                    return bl;
                }
                if (this.spanSet.contains((Comparable)Long.valueOf(snapshot.getKey()))) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkSnapshotChangedNeedsRefresh(TraceSnapshot snapshot) {
        try (LockHold hold = this.trace.lockRead();){
            List<Range<Long>> list = this.ordered;
            synchronized (list) {
                block13: {
                    if (!this.isLower(snapshot.getKey())) break block13;
                    boolean bl = true;
                    return bl;
                }
                if (this.spanSet.contains((Comparable)Long.valueOf(snapshot.getKey())) && snapshot.getSchedule() != null) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkSnapshotDeletedNeedsRefresh(TraceSnapshot snapshot) {
        try (LockHold hold = this.trace.lockRead();){
            List<Range<Long>> list = this.ordered;
            synchronized (list) {
                if (this.isLower(snapshot.getKey())) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isForked() {
        try (LockHold hold = this.trace.lockRead();){
            List<Range<Long>> list = this.ordered;
            synchronized (list) {
                boolean bl = this.ordered.size() > 1;
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Range<Long>> getOrderedSpans() {
        try (LockHold hold = this.trace.lockRead();){
            List<Range<Long>> list = this.ordered;
            synchronized (list) {
                List<Range<Long>> list2 = List.copyOf(this.ordered);
                return list2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Range<Long>> getOrderedSpans(long snap) {
        try (LockHold hold = this.trace.lockRead();){
            List<Range<Long>> list = this.ordered;
            synchronized (list) {
                this.setSnap(snap);
                List<Range<Long>> list2 = this.getOrderedSpans();
                return list2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getOrderedSnaps() {
        try (LockHold hold = this.trace.lockRead();){
            List<Range<Long>> list = this.ordered;
            synchronized (list) {
                List<Long> list2 = this.ordered.stream().map(Range::upperEndpoint).collect(Collectors.toList());
                return list2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getReversedSnaps() {
        try (LockHold hold = this.trace.lockRead();){
            List<Range<Long>> list = this.ordered;
            synchronized (list) {
                List<Long> list2 = Lists.reverse(this.ordered).stream().map(Range::upperEndpoint).collect(Collectors.toList());
                return list2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getTop(Function<Long, T> func) {
        try (LockHold hold = this.trace.lockRead();){
            List<Range<Long>> list = this.ordered;
            synchronized (list) {
                T t;
                for (Range<Long> rng : this.ordered) {
                    T t2 = func.apply((Long)rng.upperEndpoint());
                    if (t2 == null) continue;
                    t = t2;
                }
                return t;
                Iterator<Range<Long>> iterator = null;
                return (T)iterator;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Iterator<T> mergedIterator(Function<Long, Iterator<T>> iterFunc, Comparator<? super T> comparator) {
        List iters;
        try (LockHold hold = this.trace.lockRead();){
            List<Range<Long>> list = this.ordered;
            synchronized (list) {
                block11: {
                    if (this.isForked()) break block11;
                    Iterator<T> iterator = iterFunc.apply(this.snap);
                    return iterator;
                }
                iters = this.ordered.stream().map(rng -> (Iterator)iterFunc.apply((Long)rng.upperEndpoint())).collect(Collectors.toList());
            }
        }
        return new UniqIterator((Iterator)new MergeSortingIterator(iters, comparator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressSetView unionedAddresses(Function<Long, AddressSetView> viewFunc) {
        List views;
        try (LockHold hold = this.trace.lockRead();){
            List<Range<Long>> list = this.ordered;
            synchronized (list) {
                block11: {
                    if (this.isForked()) break block11;
                    AddressSetView addressSetView = viewFunc.apply(this.snap);
                    return addressSetView;
                }
                views = this.ordered.stream().map(rng -> (AddressSetView)viewFunc.apply((Long)rng.upperEndpoint())).collect(Collectors.toList());
            }
        }
        return new UnionAddressSetView(views);
    }

    protected class ForSnapshotsListener
    extends TraceDomainObjectListener
    implements DomainObjectClosedListener {
        protected ForSnapshotsListener() {
            this.listenFor(Trace.TraceSnapshotChangeType.ADDED, this.ignoringClosed(this::snapshotAdded));
            this.listenFor(Trace.TraceSnapshotChangeType.CHANGED, this.ignoringClosed(this::snapshotChanged));
            this.listenFor(Trace.TraceSnapshotChangeType.DELETED, this.ignoringClosed(this::snapshotDeleted));
        }

        private TraceDomainObjectListener.AffectedObjectOnlyHandler<? super TraceSnapshot> ignoringClosed(TraceDomainObjectListener.AffectedObjectOnlyHandler<? super TraceSnapshot> handler) {
            return snapshot -> {
                try {
                    handler.handle((TraceSnapshot)snapshot);
                }
                catch (DomainObjectException e) {
                    if (e.getCause() instanceof ClosedException) {
                        Msg.warn((Object)this, (Object)"Ignoring ClosedException in trace viewport update");
                    }
                    throw e;
                }
            };
        }

        private void snapshotAdded(TraceSnapshot snapshot) {
            if (DefaultTraceTimeViewport.this.checkSnapshotAddedNeedsRefresh(snapshot)) {
                DefaultTraceTimeViewport.this.refreshSnapRanges();
            }
        }

        private void snapshotChanged(TraceSnapshot snapshot) {
            if (DefaultTraceTimeViewport.this.checkSnapshotChangedNeedsRefresh(snapshot)) {
                DefaultTraceTimeViewport.this.refreshSnapRanges();
            }
        }

        private void snapshotDeleted(TraceSnapshot snapshot) {
            if (DefaultTraceTimeViewport.this.checkSnapshotDeletedNeedsRefresh(snapshot)) {
                DefaultTraceTimeViewport.this.refreshSnapRanges();
            }
        }

        public void domainObjectClosed() {
            DefaultTraceTimeViewport.this.trace.removeListener(this);
        }
    }
}

