/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.ByteField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.LongField;
import db.OpenMode;
import db.RecordIterator;
import db.Schema;
import ghidra.feature.vt.api.db.TableColumn;
import ghidra.feature.vt.api.db.TableDescriptor;
import ghidra.feature.vt.api.db.VTAssociationTableDBAdapterV0;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Set;

public abstract class VTAssociationTableDBAdapter {
    static String TABLE_NAME = "AssociationTable";
    static Schema TABLE_SCHEMA = new Schema(0, "Key", AssociationTableDescriptor.INSTANCE.getColumnFields(), AssociationTableDescriptor.INSTANCE.getColumnNames());
    static int[] TABLE_INDEXES = AssociationTableDescriptor.INSTANCE.getIndexedColumns();

    public static VTAssociationTableDBAdapter createAdapter(DBHandle dbHandle) throws IOException {
        return new VTAssociationTableDBAdapterV0(dbHandle);
    }

    static VTAssociationTableDBAdapter getAdapter(DBHandle dbHandle, OpenMode openMode, TaskMonitor monitor) throws VersionException {
        return new VTAssociationTableDBAdapterV0(dbHandle, openMode, monitor);
    }

    abstract DBRecord insertRecord(long var1, long var3, VTAssociationType var5, VTAssociationStatus var6, int var7) throws IOException;

    abstract void deleteRecord(long var1) throws IOException;

    abstract RecordIterator getRecordsForSourceAddress(long var1) throws IOException;

    abstract RecordIterator getRecordsForDestinationAddress(long var1) throws IOException;

    abstract int getRecordCount();

    abstract RecordIterator getRecords() throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract Set<DBRecord> getRelatedAssociationRecordsBySourceAndDestinationAddress(long var1, long var3) throws IOException;

    abstract Set<DBRecord> getRelatedAssociationRecordsBySourceAddress(long var1) throws IOException;

    abstract Set<DBRecord> getRelatedAssociationRecordsByDestinationAddress(long var1) throws IOException;

    abstract void updateRecord(DBRecord var1) throws IOException;

    abstract void removeAssociaiton(long var1) throws IOException;

    public static class AssociationTableDescriptor
    extends TableDescriptor {
        public static TableColumn SOURCE_ADDRESS_COL = new TableColumn((Field)LongField.INSTANCE, true);
        public static TableColumn DESTINATION_ADDRESS_COL = new TableColumn((Field)LongField.INSTANCE, true);
        public static TableColumn TYPE_COL = new TableColumn((Field)ByteField.INSTANCE);
        public static TableColumn STATUS_COL = new TableColumn((Field)ByteField.INSTANCE);
        public static TableColumn APPLIED_STATUS_COL = new TableColumn((Field)ByteField.INSTANCE);
        public static TableColumn VOTE_COUNT_COL = new TableColumn((Field)IntField.INSTANCE);
        public static AssociationTableDescriptor INSTANCE = new AssociationTableDescriptor();
    }
}

