/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.impliedmatches.VTImpliedMatchInfo;
import ghidra.feature.vt.gui.provider.impliedmatches.VTImpliedMatchesTableProvider;
import ghidra.feature.vt.gui.task.AcceptMatchTask;
import ghidra.feature.vt.gui.task.CreateImpliedMatchesTask;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class CreateImpliedMatchAction
extends DockingAction {
    private final VTController controller;
    private final VTImpliedMatchesTableProvider provider;

    public CreateImpliedMatchAction(VTController controller, VTImpliedMatchesTableProvider provider) {
        super("Accept Implied Match", VTPlugin.OWNER);
        this.controller = controller;
        this.provider = provider;
        ImageIcon icon = ResourceManager.loadImage((String)"images/flag.png");
        this.setToolBarData(new ToolBarData((Icon)icon, "1"));
        this.setPopupMenuData(new MenuData(new String[]{"Accept Implied Match"}, (Icon)icon, "1"));
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Accept_Implied_Match"));
        this.setEnabled(false);
    }

    public void actionPerformed(ActionContext context) {
        List<VTImpliedMatchInfo> matches = this.provider.getSelectedImpliedMatches();
        final CreateImpliedMatchesTask myTask = new CreateImpliedMatchesTask(this.controller, matches);
        myTask.addTaskListener(new TaskListener(){

            public void taskCompleted(Task task) {
                List<VTMatch> createdMatches = myTask.getCreatedMatches();
                AcceptMatchTask acceptTask = new AcceptMatchTask(CreateImpliedMatchAction.this.controller, createdMatches);
                CreateImpliedMatchAction.this.controller.runVTTask(acceptTask);
            }

            public void taskCancelled(Task task) {
            }
        });
        this.controller.runVTTask(myTask);
    }

    public boolean isEnabledForContext(ActionContext context) {
        List<VTImpliedMatchInfo> matches = this.provider.getSelectedImpliedMatches();
        return matches.size() > 0;
    }

    public boolean isAddToPopup(ActionContext context) {
        return true;
    }
}

