/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchInfo;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTScore;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.task.VtTask;
import ghidra.program.model.listing.Function;
import ghidra.util.task.TaskMonitor;

public class CreateManualMatchTask
extends VtTask {
    private final Function sourceFunction;
    private final Function destinationFunction;
    private double PERFECT_SCORE = 1.0;
    protected VTMatch newlyCreatedMatch;

    public CreateManualMatchTask(VTSession session, Function sourceFunction, Function destinationFunction) {
        this("Create Manual Match", session, sourceFunction, destinationFunction);
    }

    public CreateManualMatchTask(String name, VTSession session, Function sourceFunction, Function destinationFunction) {
        super(name, session);
        this.sourceFunction = sourceFunction;
        this.destinationFunction = destinationFunction;
    }

    @Override
    protected boolean doWork(TaskMonitor monitor) throws Exception {
        VTMatchSet manualMatchSet = this.session.getManualMatchSet();
        VTMatchInfo manualMatchInfo = this.createMatch(manualMatchSet);
        this.newlyCreatedMatch = manualMatchSet.addMatch(manualMatchInfo);
        boolean result = this.runFollowOnTasks(monitor);
        return result;
    }

    protected boolean runFollowOnTasks(TaskMonitor monitor) throws Exception {
        return true;
    }

    public VTMatch getNewMatch() {
        return this.newlyCreatedMatch;
    }

    private VTMatchInfo createMatch(VTMatchSet manualMatchSet) {
        VTMatchInfo matchInfo = new VTMatchInfo(manualMatchSet);
        matchInfo.setSourceAddress(this.sourceFunction.getEntryPoint());
        matchInfo.setDestinationAddress(this.destinationFunction.getEntryPoint());
        matchInfo.setSourceLength((int)this.sourceFunction.getBody().getNumAddresses());
        matchInfo.setDestinationLength((int)this.destinationFunction.getBody().getNumAddresses());
        matchInfo.setSimilarityScore(new VTScore(this.PERFECT_SCORE));
        matchInfo.setConfidenceScore(new VTScore(this.PERFECT_SCORE));
        matchInfo.setAssociationType(VTAssociationType.FUNCTION);
        matchInfo.setTag(null);
        return matchInfo;
    }

    @Override
    protected String getErrorHeader() {
        return "Unexpected exceptions creating a manual match from " + this.sourceFunction + " to " + this.destinationFunction;
    }
}

