/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.extension.datatype.finder;

import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTypeToken;
import ghidra.app.decompiler.ClangVariableDecl;
import ghidra.app.extension.datatype.finder.DecompilerReference;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.util.ArrayList;
import java.util.List;

public abstract class DecompilerVariable {
    protected List<DecompilerVariable> casts = new ArrayList<DecompilerVariable>();
    protected ClangToken variable;

    protected DecompilerVariable(ClangToken variable) {
        this.variable = variable;
    }

    public List<DecompilerVariable> getCasts() {
        return this.casts;
    }

    public DataType getParentDataType() {
        return this.getDataType();
    }

    public DataType getDataType() {
        ClangVariableDecl decl;
        if (this.variable instanceof ClangTypeToken) {
            return ((ClangTypeToken)this.variable).getDataType();
        }
        HighVariable highVariable = this.variable.getHighVariable();
        if (highVariable != null) {
            return highVariable.getDataType();
        }
        Varnode varnode = this.variable.getVarnode();
        DataType dataType = this.getDataType(varnode);
        if (dataType != null) {
            return dataType;
        }
        ClangNode parent = this.variable.Parent();
        if (parent instanceof ClangVariableDecl && (dataType = (decl = (ClangVariableDecl)parent).getDataType()) != null) {
            return dataType;
        }
        PcodeOp op = this.variable.getPcodeOp();
        dataType = this.getInputDataType(op);
        if (dataType instanceof PointerDataType && (dataType = DecompilerReference.getBaseType(dataType)) instanceof VoidDataType) {
            dataType = null;
        }
        if (dataType != null) {
            return dataType;
        }
        dataType = this.getOutputDataType(op);
        return dataType;
    }

    private DataType getInputDataType(PcodeOp op) {
        if (op == null) {
            return null;
        }
        Varnode[] inputs = op.getInputs();
        if (inputs.length == 2) {
            return inputs[0].getHigh().getDataType();
        }
        return null;
    }

    private DataType getOutputDataType(PcodeOp op) {
        if (op == null) {
            return null;
        }
        Varnode output = op.getOutput();
        if (output == null) {
            return null;
        }
        HighVariable high = output.getHigh();
        if (high == null) {
            return null;
        }
        return high.getDataType();
    }

    private DataType getDataType(Varnode varnode) {
        HighVariable highVariable;
        if (varnode != null && (highVariable = varnode.getHigh()) != null) {
            return highVariable.getDataType();
        }
        return null;
    }

    public ClangNode getParent() {
        return this.variable.Parent();
    }

    public Function getFunction() {
        ClangFunction clangFunction = this.variable.getClangFunction();
        HighFunction highFunction = clangFunction.getHighFunction();
        Function function = highFunction.getFunction();
        return function;
    }

    public Address getAddress() {
        Address minAddress = this.variable.getMinAddress();
        if (minAddress != null) {
            return minAddress;
        }
        for (ClangNode parent = this.variable.Parent(); parent != null; parent = parent.Parent()) {
            if (parent instanceof ClangFunction) {
                HighFunction highFunction = ((ClangFunction)parent).getHighFunction();
                Function function = highFunction.getFunction();
                Address entry = function.getEntryPoint();
                return entry;
            }
            Address parentAddress = parent.getMinAddress();
            if (parentAddress == null) continue;
            return parentAddress;
        }
        return null;
    }

    public String getName() {
        String text = this.variable.getText();
        return text;
    }

    public String toString() {
        String castString = this.casts.isEmpty() ? "" : "\tcasts: " + this.casts + ",\n";
        return "{\n" + castString + "\tvariable: " + this.variable + ",\n}";
    }
}

