/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string.variadic;

import ghidra.app.plugin.core.string.variadic.FunctionCallData;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.Varnode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PcodeFunctionParser {
    private static final int READABLE_ASCII_LOWER_BOUND = 32;
    private static final int READABLE_ASCII_UPPER_BOUND = 126;
    private static final int BUFFER_LENGTH = 20;
    private static final String CALL_INSTRUCTION = "CALL";
    private Program program;

    public PcodeFunctionParser(Program program) {
        this.program = program;
    }

    public List<FunctionCallData> parseFunctionForCallData(List<PcodeOpAST> pcodeOps, Map<Address, Data> addressToCandidateData, Set<String> variadicFunctionNames) {
        if (pcodeOps == null || addressToCandidateData == null || variadicFunctionNames == null || this.program == null) {
            return null;
        }
        ArrayList<FunctionCallData> functionCallDataList = new ArrayList<FunctionCallData>();
        for (PcodeOpAST ast : pcodeOps) {
            boolean hasDefinedFormatString;
            Varnode[] inputs;
            Varnode firstNode = ast.getInput(0);
            if (firstNode == null || !ast.getMnemonic().contentEquals(CALL_INSTRUCTION)) continue;
            FunctionManager functionManager = this.program.getFunctionManager();
            Function function = functionManager.getFunctionAt(firstNode.getAddress());
            if (function == null) {
                return null;
            }
            String functionName = function.getName();
            if (!variadicFunctionNames.contains(functionName) || (inputs = ast.getInputs()).length <= 0 || (hasDefinedFormatString = this.searchForVariadicCallData(ast, addressToCandidateData, functionCallDataList, functionName))) continue;
            this.searchForHiddenFormatStrings(ast, functionCallDataList, functionName);
        }
        return functionCallDataList;
    }

    private boolean searchForVariadicCallData(PcodeOpAST ast, Map<Address, Data> addressToCandidateData, List<FunctionCallData> functionCallDataList, String functionName) {
        boolean hasDefinedFormatString = false;
        Varnode[] inputs = ast.getInputs();
        for (int i = 1; i < inputs.length; ++i) {
            Varnode v = inputs[i];
            Data data = null;
            Address ramSpaceAddress = this.convertAddressToRamSpace(v.getAddress());
            if (!addressToCandidateData.containsKey(ramSpaceAddress)) continue;
            data = addressToCandidateData.get(ramSpaceAddress);
            functionCallDataList.add(new FunctionCallData(ast.getSeqnum().getTarget(), functionName, data.getDefaultValueRepresentation()));
            hasDefinedFormatString = true;
        }
        return hasDefinedFormatString;
    }

    private void searchForHiddenFormatStrings(PcodeOpAST ast, List<FunctionCallData> functionCallDataList, String functionName) {
        Varnode[] inputs = ast.getInputs();
        for (int i = 1; i < inputs.length; ++i) {
            Varnode v = inputs[i];
            String formatStringCandidate = this.findFormatString(v.getAddress());
            if (formatStringCandidate == null) continue;
            if (!formatStringCandidate.contains("%")) break;
            functionCallDataList.add(new FunctionCallData(ast.getSeqnum().getTarget(), functionName, formatStringCandidate));
            break;
        }
    }

    private Address convertAddressToRamSpace(Address address) {
        String addressString = address.toString(false);
        return this.program.getAddressFactory().getAddress(addressString);
    }

    private String findFormatString(Address address) {
        SettingsImpl settings;
        if (!address.getAddressSpace().isConstantSpace()) {
            return null;
        }
        Address ramSpaceAddress = this.convertAddressToRamSpace(address);
        MemoryBufferImpl memoryBuffer = new MemoryBufferImpl(this.program.getMemory(), ramSpaceAddress);
        StringDataInstance stringDataInstance = StringDataInstance.getStringDataInstance((DataType)new StringDataType(), (MemBuffer)memoryBuffer, (Settings)(settings = new SettingsImpl()), (int)20);
        String stringValue = stringDataInstance.getStringValue();
        if (stringValue == null) {
            return null;
        }
        Object formatStringCandidate = "";
        for (int i = 0; i < stringValue.length() && this.isAsciiReadable(stringValue.charAt(i)); ++i) {
            formatStringCandidate = (String)formatStringCandidate + stringValue.charAt(i);
        }
        return formatStringCandidate;
    }

    private boolean isAsciiReadable(char c) {
        return c >= ' ' && c <= '~';
    }
}

