/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target;

import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.DebuggerTargetObjectIface;
import ghidra.dbg.attributes.TargetDataType;
import ghidra.dbg.target.TargetDataTypeMember;
import ghidra.dbg.target.TargetDataTypeNamespace;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

@DebuggerTargetObjectIface(value="DataType")
public interface TargetNamedDataType
extends TargetObject,
TargetDataType {
    public static final String NAMED_DATA_TYPE_KIND_ATTRIBUTE_NAME = "_type_kind";
    public static final String ENUM_BYTE_LENGTH_ATTRIBUTE_NAME = "_byte_length";
    public static final String NAMESPACE_ATTRIBUTE_NAME = "_namespace";
    public static final String FUNCTION_RETURN_INDEX = "return";
    public static final String FUNCTION_PARAMETER_DIM = "param";

    default public CompletableFuture<? extends Collection<? extends TargetDataTypeMember>> getMembers() {
        return DebugModelConventions.collectSuccessors(this, TargetDataTypeMember.class);
    }

    @TargetAttributeType(name="_namespace", required=true, fixed=true, hidden=true)
    default public TargetDataTypeNamespace getNamespace() {
        return this.getTypedAttributeNowByName(NAMESPACE_ATTRIBUTE_NAME, TargetDataTypeNamespace.class, null);
    }

    @TargetAttributeType(name="_type_kind", required=true, fixed=true, hidden=true)
    default public NamedDataTypeKind getTypeKind() {
        return this.getTypedAttributeNowByName(NAMED_DATA_TYPE_KIND_ATTRIBUTE_NAME, NamedDataTypeKind.class, null);
    }

    @TargetAttributeType(name="_byte_length", fixed=true, hidden=true)
    default public Integer getEnumByteLength() {
        return this.getTypedAttributeNowByName(ENUM_BYTE_LENGTH_ATTRIBUTE_NAME, Integer.class, null);
    }

    public static enum NamedDataTypeKind {
        ENUM,
        FUNCTION,
        STRUCT,
        TYPEDEF,
        UNION;

    }
}

