/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.util;

import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.util.Msg;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface ConfigurableFactory<T> {
    public CompletableFuture<? extends T> build();

    default public String getBrief() {
        FactoryDescription annot = this.getClass().getAnnotation(FactoryDescription.class);
        if (annot == null) {
            return "Class: " + this.getClass().getSimpleName();
        }
        return annot.brief();
    }

    default public String getHtmlDetails() {
        FactoryDescription annot = this.getClass().getAnnotation(FactoryDescription.class);
        if (annot == null) {
            return "Un-described factory: " + this.getClass().getName();
        }
        return annot.htmlDetails();
    }

    default public Map<String, Property<?>> getOptions() {
        LinkedHashMap result = new LinkedHashMap();
        for (Field f : this.getClass().getFields()) {
            FactoryOption annot = f.getAnnotation(FactoryOption.class);
            if (annot == null) continue;
            try {
                result.put(annot.value(), (Property)f.get(this));
            }
            catch (Throwable e) {
                Msg.error((Object)this, (Object)("Could not process option: " + f.getName()), (Throwable)e);
            }
        }
        return result;
    }

    default public void writeConfigState(SaveState saveState) {
        for (Map.Entry<String, Property<?>> opt : this.getOptions().entrySet()) {
            Property<?> property = opt.getValue();
            AutoConfigState.ConfigFieldCodec codec = AutoConfigState.ConfigStateField.getCodecByType(property.getValueClass());
            if (codec == null) continue;
            codec.write(saveState, opt.getKey(), property.getValue());
        }
    }

    default public void readConfigState(SaveState saveState) {
        for (Map.Entry<String, Property<?>> opt : this.getOptions().entrySet()) {
            Object read;
            Property<?> property = opt.getValue();
            AutoConfigState.ConfigFieldCodec codec = AutoConfigState.ConfigStateField.getCodecByType(property.getValueClass());
            if (codec == null || (read = codec.read(saveState, opt.getKey(), null)) == null) continue;
            property.setValue(read);
        }
    }

    public static interface Property<T> {
        public Class<T> getValueClass();

        public T getValue();

        public void setValue(T var1);

        public boolean isEnabled();

        public void setEnabled(boolean var1);

        public static <T> Property<T> fromAccessors(final Class<T> cls, final Supplier<T> getter, final Consumer<T> setter) {
            return new Property<T>(){
                boolean enabled = true;

                @Override
                public Class<T> getValueClass() {
                    return cls;
                }

                @Override
                public T getValue() {
                    return getter.get();
                }

                @Override
                public void setValue(T value) {
                    setter.accept(value);
                }

                @Override
                public boolean isEnabled() {
                    return this.enabled;
                }

                @Override
                public void setEnabled(boolean enabled) {
                    this.enabled = enabled;
                }
            };
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface FactoryOption {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface FactoryDescription {
        public String brief();

        public String htmlDetails();
    }
}

