/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SourceDebugExtensionAttribute
extends AbstractAttributeInfo {
    private byte[] debugExtension;

    public SourceDebugExtensionAttribute(BinaryReader reader) throws IOException {
        super(reader);
        this.debugExtension = reader.readNextByteArray(this.getAttributeLength());
    }

    public byte[] getDebugExtension() {
        return this.debugExtension;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = this.getBaseStructure("SourceDebugExtension_attribute");
        if (this.debugExtension.length > 0) {
            ArrayDataType array = new ArrayDataType(BYTE, this.debugExtension.length, BYTE.getLength());
            structure.add((DataType)array, "debug_extension", null);
        }
        return structure;
    }
}

