/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class FBPT_Entry
implements StructConverter {
    private String name;
    private String guid1;
    private String guid2;
    private String padding;
    private int unknown1;
    private int unknown2;
    private int unknown3;
    private boolean isLast;

    public FBPT_Entry(BinaryReader reader, boolean isLast) throws IOException {
        this.isLast = isLast;
        this.name = reader.readNextAsciiString(36);
        this.guid1 = reader.readNextAsciiString(37);
        this.guid2 = reader.readNextAsciiString(37);
        this.padding = reader.readNextAsciiString(2);
        if ("last_parti".equals(this.name)) {
            return;
        }
        this.unknown1 = reader.readNextInt();
        if (!isLast) {
            this.unknown2 = reader.readNextInt();
            this.unknown3 = reader.readNextInt();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getGuid1() {
        return this.guid1;
    }

    public String getGuid2() {
        return this.guid2;
    }

    public String getPadding() {
        return this.padding;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    public int getUnknown2() {
        return this.unknown2;
    }

    public int getUnknown3() {
        return this.unknown3;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(FBPT_Entry.class.getSimpleName(), 0);
        struct.add(STRING, 36, "name", null);
        struct.add(STRING, 37, "guid1", null);
        struct.add(STRING, 37, "guid2", null);
        struct.add(STRING, 2, "padding", null);
        if ("last_parti".equals(this.name) || this.isLast) {
            try {
                struct.setName(FBPT_Entry.class.getSimpleName() + "_last");
            }
            catch (InvalidNameException invalidNameException) {}
        } else {
            struct.add(DWORD, "unknown1", null);
            if (!this.isLast) {
                struct.add(DWORD, "unknown2", null);
                struct.add(DWORD, "unknown3", null);
            }
        }
        return struct;
    }
}

