/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat;

import generic.continues.GenericFactory;
import generic.continues.RethrowContinuesFactory;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.ElfSymbolTable;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.oat.OatHeader;
import ghidra.file.formats.android.oat.OatHeaderFactory;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.formats.gfilesystem.fileinfo.FileAttribute;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

@FileSystemInfo(type="androidoat", description="Android OAT (for extracting embedded DEX files)", factory=GFileSystemBaseFactory.class)
public class OatFileSystem
extends GFileSystemBase {
    private long baseOffset;
    private List<GFile> listing = new ArrayList<GFile>();
    private List<OatDexFile> dexFileList = new ArrayList<OatDexFile>();

    public OatFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        try {
            boolean magicMatch;
            byte e_ident_magic_num = this.provider.readByte(0L);
            String e_ident_magic_str = new String(this.provider.readBytes(1L, 3L));
            boolean bl = magicMatch = 127 == e_ident_magic_num && "ELF".equalsIgnoreCase(e_ident_magic_str);
            if (magicMatch) {
                ElfSymbol[] symbols;
                ElfHeader elf = ElfHeader.createElfHeader((GenericFactory)RethrowContinuesFactory.INSTANCE, (ByteProvider)this.provider);
                elf.parse();
                ElfSymbolTable dynamicSymbolTable = elf.getDynamicSymbolTable();
                for (ElfSymbol symbol : symbols = dynamicSymbolTable.getSymbols()) {
                    if (!"oatdata".equals(symbol.getNameAsString())) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        try {
            monitor.setProgress(0L);
            monitor.setMaximum(10L);
            monitor.setMessage("Parsing ELF header...");
            monitor.incrementProgress(1L);
            ElfHeader elf = ElfHeader.createElfHeader((GenericFactory)RethrowContinuesFactory.INSTANCE, (ByteProvider)this.provider);
            elf.parse();
            monitor.incrementProgress(1L);
            ElfSectionHeader roDataSection = elf.getSection(".rodata");
            if (roDataSection == null) {
                throw new IOException("rodata section does not exist.");
            }
            this.baseOffset = roDataSection.getOffset();
            monitor.setMessage("Parsing OAT header...");
            ByteProviderWrapper wrapper = new ByteProviderWrapper(this.provider, this.baseOffset, roDataSection.getSize());
            BinaryReader reader = new BinaryReader((ByteProvider)wrapper, elf.isLittleEndian());
            OatHeader oatHeader = OatHeaderFactory.newOatHeader(reader);
            OatHeaderFactory.parseOatHeader(oatHeader, null, reader, monitor, new MessageLog());
            monitor.incrementProgress(1L);
            this.dexFileList = oatHeader.getOatDexFileList();
            monitor.setProgress(0L);
            monitor.setMaximum((long)this.dexFileList.size());
            monitor.setMessage("Creating OAT filesystem...");
            for (OatDexFile oatDexFileHeader : this.dexFileList) {
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
                DexHeader dexHeader = oatDexFileHeader.getDexHeader();
                if (dexHeader == null) continue;
                StringTokenizer tokenizer = new StringTokenizer(oatDexFileHeader.getDexFileLocation(), "/");
                while (tokenizer.hasMoreTokens()) {
                    monitor.checkCanceled();
                    Object token = tokenizer.nextToken();
                    boolean isDirectory = tokenizer.hasMoreTokens();
                    if (isDirectory) continue;
                    if (this.listing.isEmpty() && !((String)token).endsWith(":classes.dex")) {
                        token = (String)token + ":classes.dex";
                    }
                    GFileImpl file = GFileImpl.fromPathString((GFileSystem)this, (GFile)this.root, (String)token, null, (boolean)isDirectory, (long)dexHeader.getFileSize());
                    this.listing.add((GFile)file);
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        super.close();
        this.listing.clear();
        this.dexFileList = new ArrayList<OatDexFile>();
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null || directory.equals(this.root)) {
            return this.listing;
        }
        return null;
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        int index = this.listing.indexOf(file);
        if (index < 0) {
            return FileAttributes.EMPTY;
        }
        OatDexFile oatDexFileHeader = this.dexFileList.get(index);
        return FileAttributes.of((FileAttribute[])new FileAttribute[]{FileAttribute.create((String)"Oat location", (Object)oatDexFileHeader.getDexFileLocation())});
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        int index = this.listing.indexOf(file);
        if (index < 0) {
            throw new IOException("Invalid / unknown file: " + file);
        }
        OatDexFile oatDexFileHeader = this.dexFileList.get(index);
        return new ByteProviderWrapper(this.provider, this.baseOffset + (long)oatDexFileHeader.getDexFileOffset(), (long)oatDexFileHeader.getDexHeader().getFileSize(), file.getFSRL());
    }
}

