/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.oat.OatInstructionSet;
import ghidra.file.formats.android.oat.UnsupportedOatVersionException;
import ghidra.file.formats.android.oat.bundle.OatBundle;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFileFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class OatHeader
implements StructConverter {
    protected String magic;
    protected String version;
    protected List<String> orderedKeyList = new ArrayList<String>();
    protected Map<String, String> key_value_store_ = new HashMap<String, String>();
    protected List<OatDexFile> oatDexFileList = new ArrayList<OatDexFile>();

    protected OatHeader(BinaryReader reader) throws IOException {
        this.magic = new String(reader.readNextByteArray("oat\n".length()));
        this.version = reader.readNextAsciiString(4);
    }

    public void parse(BinaryReader reader, OatBundle bundle) throws IOException, UnsupportedOatVersionException {
        String value;
        for (int count = 0; count < this.getKeyValueStoreSize(); count += value.length() + 1) {
            String key = reader.readNextAsciiString();
            value = reader.readNextAsciiString();
            count += key.length() + 1;
            this.orderedKeyList.add(key);
            this.key_value_store_.put(key, value);
        }
        reader.setPointerIndex(this.getOatDexFilesOffset(reader));
        for (int i = 0; i < this.getDexFileCount(); ++i) {
            this.oatDexFileList.add(OatDexFileFactory.getOatDexFile(reader, this.getVersion(), bundle));
        }
    }

    public String getMagic() {
        return this.magic;
    }

    public String getVersion() {
        return this.version;
    }

    public abstract int getOatDexFilesOffset(BinaryReader var1);

    public abstract int getDexFileCount();

    public abstract int getKeyValueStoreSize();

    public abstract List<OatDexFile> getOatDexFileList();

    public abstract OatInstructionSet getInstructionSet();

    public abstract int getExecutableOffset();

    public abstract int getChecksum();
}

