/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.oatclass;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.oat.oatclass.OatClassStatusEnum;
import ghidra.file.formats.android.oat.oatclass.OatClassStatusEnum_11_12;
import ghidra.file.formats.android.oat.oatclass.OatClassStatusEnum_Invalid;
import ghidra.file.formats.android.oat.oatclass.OatClassStatusEnum_K;
import ghidra.file.formats.android.oat.oatclass.OatClassStatusEnum_L_M_N;
import ghidra.file.formats.android.oat.oatclass.OatClassStatusEnum_O;
import ghidra.file.formats.android.oat.oatclass.OatClassStatusEnum_O_M2;
import ghidra.file.formats.android.oat.oatclass.OatClassStatusEnum_P_10;
import ghidra.file.formats.android.oat.oatclass.OatClassType;
import ghidra.file.formats.android.oat.oatmethod.OatMethodOffsets;
import ghidra.program.model.data.DataType;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class OatClass
implements StructConverter {
    protected String oatVersion;
    protected short status_;
    protected short type_;
    protected List<OatMethodOffsets> methods_pointer_ = new ArrayList<OatMethodOffsets>();
    protected OatClassStatusEnum statusEnum;

    protected OatClass(BinaryReader reader, String oatVersion) throws IOException {
        this.oatVersion = oatVersion;
        this.status_ = reader.readNextShort();
        switch (oatVersion) {
            case "007": {
                this.statusEnum = OatClassStatusEnum_K.kStatusInitialized.get(this.status_);
                break;
            }
            case "039": 
            case "045": 
            case "051": 
            case "064": 
            case "079": 
            case "088": {
                this.statusEnum = OatClassStatusEnum_L_M_N.kStatusMax.get(this.status_);
                break;
            }
            case "124": {
                this.statusEnum = OatClassStatusEnum_O.kStatusMax.get(this.status_);
                break;
            }
            case "131": {
                this.statusEnum = OatClassStatusEnum_O_M2.kStatusMax.get(this.status_);
                break;
            }
            case "138": 
            case "170": {
                this.statusEnum = OatClassStatusEnum_P_10.kLast.get(this.status_);
                break;
            }
            case "183": 
            case "195": {
                this.statusEnum = OatClassStatusEnum_11_12.kLast.get(this.status_);
                break;
            }
            default: {
                this.statusEnum = new OatClassStatusEnum_Invalid(this.status_);
            }
        }
    }

    public final short getStatus() {
        return this.status_;
    }

    public final OatClassType getType() {
        for (OatClassType type : OatClassType.values()) {
            if (type.ordinal() != this.type_) continue;
            return type;
        }
        return OatClassType.kOatClassMax;
    }

    public final List<OatMethodOffsets> getMethodOffsets() {
        return this.methods_pointer_;
    }

    public abstract boolean isMethodNative(int var1);

    protected void renameDataType(DataType dataType, String prefix) throws InvalidNameException, DuplicateNameException {
        String currentName = dataType.getName();
        int underscorePos = currentName.indexOf(95);
        if ((underscorePos = currentName.indexOf(95, underscorePos + 1)) == -1) {
            dataType.setName(prefix);
        } else {
            dataType.setName(prefix + currentName.substring(underscorePos));
        }
    }
}

