/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.tlt;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.oat.UnsupportedOatVersionException;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable_Android10;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable_Android11;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable_Android12;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable_Nougat;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable_Oreo;
import ghidra.file.formats.android.oat.tlt.TypeLookupTable_Pie;
import java.io.IOException;

public final class TypeLookupTableFactory {
    public static final TypeLookupTable getTypeLookupTable(BinaryReader reader, String oatVersion) throws IOException {
        switch (oatVersion) {
            case "079": 
            case "088": {
                return new TypeLookupTable_Nougat(reader);
            }
            case "124": 
            case "131": 
            case "126": {
                return new TypeLookupTable_Oreo(reader);
            }
            case "138": {
                return new TypeLookupTable_Pie(reader);
            }
            case "170": {
                return new TypeLookupTable_Android10(reader);
            }
            case "183": {
                return new TypeLookupTable_Android11(reader);
            }
            case "195": {
                return new TypeLookupTable_Android12(reader);
            }
        }
        throw new IOException(new UnsupportedOatVersionException("Unsupported TypeLookupTable for OAT version " + oatVersion));
    }
}

