/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.yaffs2;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.yaffs2.YAFFS2Data;
import ghidra.file.formats.yaffs2.YAFFS2ExtendedTags;
import ghidra.file.formats.yaffs2.YAFFS2Header;
import ghidra.file.formats.yaffs2.YAFFS2Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Arrays;

public class YAFFS2Analyzer
extends FileFormatAnalyzer
implements AnalysisWorker {
    private MessageLog log;

    public String getName() {
        return "YAFFS2 Image Annotation (used in Android System and Userdata image files)";
    }

    public boolean getDefaultEnablement(Program program) {
        return false;
    }

    public String getDescription() {
        return "Annotates YAFFS2 Image files (used in Android System and UserData Images.";
    }

    public boolean canAnalyze(Program program) {
        try {
            return YAFFS2Utils.isYAFFS2Image(program);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isPrototype() {
        return true;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        this.log = log;
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager((Program)program);
        return manager.scheduleWorker((AnalysisWorker)this, null, false, monitor);
    }

    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws Exception, CancelledException {
        Address address = program.getMinAddress();
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), address);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, true);
        int index = 0;
        long lastObjectType = 3L;
        while ((long)index < reader.length() && !monitor.isCancelled()) {
            byte[] block = reader.readByteArray((long)index, 2112);
            if (lastObjectType != 1L) {
                YAFFS2Header header = new YAFFS2Header(Arrays.copyOfRange(block, 0, 2048));
                DataType headerDataType = header.toDataType();
                Data headerData = this.createData(program, address.add((long)index), headerDataType);
                if (headerData == null) {
                    this.log.appendMsg("Unable to create header.");
                }
                lastObjectType = header.getObjectType();
            } else {
                YAFFS2Data dataBlock = new YAFFS2Data(Arrays.copyOfRange(block, 0, 2048));
                DataType dataBlockDataType = dataBlock.toDataType();
                Data dataBlockData = this.createData(program, address.add((long)index), dataBlockDataType);
                if (dataBlockData == null) {
                    this.log.appendMsg("Unable to create data block.");
                }
            }
            YAFFS2ExtendedTags tags = new YAFFS2ExtendedTags(Arrays.copyOfRange(block, 2048, 2111));
            DataType tagsDataType = tags.toDataType();
            Data tagsData = this.createData(program, address.add((long)(index + 2048)), tagsDataType);
            if (tagsData == null) {
                this.log.appendMsg("Unable to create tags (footer).");
            }
            index += 2112;
        }
        this.changeDataSettings(program, monitor);
        this.removeEmptyFragments(program);
        return true;
    }

    public String getWorkerName() {
        return "YAFFS2Analyzer";
    }
}

