/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bytepatterns.bitcluster;

import ghidra.bytepatterns.bitcluster.Face;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.TreeSet;

public class FacePatterns {
    private int maxDim;
    private HashSet<Face> patterns = null;
    private int sampleSize;

    public FacePatterns(int sampsize) {
        this.sampleSize = sampsize;
    }

    public HashSet<Face> generatePatterns(ArrayList<byte[]> bytes, int minBitsOfCheck) {
        if (bytes.isEmpty()) {
            return null;
        }
        ArrayList<byte[]> forSample = FacePatterns.sample(bytes, this.sampleSize);
        this.patterns = new HashSet();
        int numBytes = forSample.get(0).length;
        this.maxDim = numBytes * 8 - minBitsOfCheck;
        this.createFaces(forSample);
        TreeSet<Face> edges = this.createEdges();
        this.cluster(edges);
        return this.patterns;
    }

    private void createFaces(ArrayList<byte[]> sequences) {
        HashMap<String, Face> faceByName = new HashMap<String, Face>();
        for (byte[] seq : sequences) {
            Face node = new Face(seq);
            String name = node.strID;
            if (faceByName.containsKey(name)) {
                ((Face)faceByName.get(name)).incrementWeight();
                continue;
            }
            faceByName.put(name, node);
            this.patterns.add(node);
        }
    }

    private TreeSet<Face> createEdges() {
        Face[] faceList = this.patterns.toArray(new Face[this.patterns.size()]);
        TreeSet<Face> edgesConsidered = new TreeSet<Face>();
        for (int indexA = 0; indexA < faceList.length - 1; ++indexA) {
            Face f1 = faceList[indexA];
            for (int indexB = indexA + 1; indexB < faceList.length; ++indexB) {
                Face f2 = faceList[indexB];
                Face edge = new Face(f1, f2, this.patterns, this.maxDim, false);
                if (edge.getNumUncertainBits() > this.maxDim) continue;
                edgesConsidered.add(edge);
            }
        }
        return edgesConsidered;
    }

    private void cluster(TreeSet<Face> edgesConsidered) {
        HashMap<String, Face> added = new HashMap<String, Face>();
        while (edgesConsidered.size() > 0) {
            Face bestEdge = edgesConsidered.last();
            if (bestEdge.meetsCriteria(this.patterns, added)) {
                this.patterns.removeAll(bestEdge.getChildren());
                for (Face outside : this.patterns) {
                    Face edge = new Face(bestEdge, outside, this.patterns, this.maxDim, true);
                    if (edge.getNumUncertainBits() > this.maxDim) continue;
                    edgesConsidered.add(edge);
                }
                this.patterns.add(bestEdge);
                added.put(bestEdge.strID, bestEdge);
            }
            edgesConsidered.remove(bestEdge);
        }
    }

    private static HashSet<String> edgize(Face node) {
        HashSet<String> result = new HashSet<String>();
        for (Face kid : node.getChildren()) {
            result.add(node.strID + "," + kid.strID);
            result.addAll(FacePatterns.edgize(kid));
        }
        return result;
    }

    public void outputHierarchy(Writer writer) throws IOException {
        HashSet<String> edgeStrs = new HashSet<String>();
        for (Face f : this.patterns) {
            edgeStrs.addAll(FacePatterns.edgize(f));
        }
        for (String line : edgeStrs) {
            writer.write(line + "\n");
        }
    }

    public void outputTopPatterns(Writer writer) throws IOException {
        for (Face f : this.patterns) {
            writer.write(f.strID + "\t" + f.getWeight() + "\t" + Double.valueOf(f.ratioFilled()).toString() + "\n");
        }
    }

    private static ArrayList<byte[]> sample(ArrayList<byte[]> li, int numOfSamples) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        Random rand = new Random();
        for (int s = 0; s < numOfSamples; ++s) {
            int r = rand.nextInt(li.size());
            result.add(li.get(r));
        }
        return result;
    }
}

