/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.Processor;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LanguageName;

public class Compile3MsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 4412;
    protected LanguageName language;
    protected boolean compiledForEditAndContinue;
    protected boolean notCompiledWithDebugInfo;
    protected boolean compiledWithLinkTimeCodeGeneration;
    protected boolean compiledWithBzalignNoDataAlign;
    protected boolean managedCodeDataPresent;
    protected boolean compiledWithGsBufferSecurityChecks;
    protected boolean compiledWithHotPatch;
    protected boolean convertedWithCvtcil;
    protected boolean microsoftIntermediateLanguageNetModule;
    protected boolean compiledWithSdl;
    protected boolean compiledWithLtcgPgoOrPgu;
    protected boolean dotExpModule;
    protected Processor processor;
    protected int frontEndMajorVersionNumber;
    protected int frontEndMinorVersionNumber;
    protected int frontEndBuildVersionNumber;
    protected int frontEndQuickFixEngineeringVersionNumber;
    protected int backEndMajorVersionNumber;
    protected int backEndMinorVersionNumber;
    protected int backEndBuildVersionNumber;
    protected int backEndQuickFixEngineeringVersionNumber;
    protected String compilerVersionString;

    public Compile3MsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.processFlags(reader.parseUnsignedIntVal());
        this.processor = Processor.fromValue(reader.parseUnsignedShortVal());
        this.frontEndMajorVersionNumber = reader.parseUnsignedShortVal();
        this.frontEndMinorVersionNumber = reader.parseUnsignedShortVal();
        this.frontEndBuildVersionNumber = reader.parseUnsignedShortVal();
        this.frontEndQuickFixEngineeringVersionNumber = reader.parseUnsignedShortVal();
        this.backEndMajorVersionNumber = reader.parseUnsignedShortVal();
        this.backEndMinorVersionNumber = reader.parseUnsignedShortVal();
        this.backEndBuildVersionNumber = reader.parseUnsignedShortVal();
        this.backEndQuickFixEngineeringVersionNumber = reader.parseUnsignedShortVal();
        this.compilerVersionString = reader.parseString(pdb, StringParseType.StringUtf8Nt);
        pdb.setTargetProcessor(this.processor);
    }

    @Override
    public int getPdbId() {
        return 4412;
    }

    public String getLanguage() {
        return this.language.toString();
    }

    public boolean isCompiledForEditAndContinue() {
        return this.compiledForEditAndContinue;
    }

    public boolean isNotCompiledWithDebugInfo() {
        return this.notCompiledWithDebugInfo;
    }

    public boolean isCompiledWithLinkTimeCodeGeneration() {
        return this.compiledWithLinkTimeCodeGeneration;
    }

    public boolean isCompiledWithBzalignNoDataAlign() {
        return this.compiledWithBzalignNoDataAlign;
    }

    public boolean isManagedCodeDataPresent() {
        return this.managedCodeDataPresent;
    }

    public boolean isCompiledWithGsBufferSecurityChecks() {
        return this.compiledWithGsBufferSecurityChecks;
    }

    public boolean isCompiledWithHotPatch() {
        return this.compiledWithHotPatch;
    }

    public boolean wasConvertedWithCvtcil() {
        return this.convertedWithCvtcil;
    }

    public boolean isMicrosoftIntermediateLanguageNetModule() {
        return this.microsoftIntermediateLanguageNetModule;
    }

    public boolean isCompiledWithSdl() {
        return this.compiledWithSdl;
    }

    public boolean isCompiledWithLtcgPgoOrPgu() {
        return this.compiledWithLtcgPgoOrPgu;
    }

    public boolean isDotExpModule() {
        return this.dotExpModule;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public int getFrontEndMajorVersionNumber() {
        return this.frontEndMajorVersionNumber;
    }

    public int getFrontEndMinorVersionNumber() {
        return this.frontEndMinorVersionNumber;
    }

    public int getFrontEndBuildVersionNumber() {
        return this.frontEndBuildVersionNumber;
    }

    public int getFrontEndQuickFixEngineeringVersionNumber() {
        return this.frontEndQuickFixEngineeringVersionNumber;
    }

    public int getBackEndMajorVersionNumber() {
        return this.backEndMajorVersionNumber;
    }

    public int getBackEndMinorVersionNumber() {
        return this.backEndMinorVersionNumber;
    }

    public int getBackEndBuildVersionNumber() {
        return this.backEndBuildVersionNumber;
    }

    public int getBackEndQuickFixEngineeringVersionNumber() {
        return this.backEndQuickFixEngineeringVersionNumber;
    }

    public String getCompilerVersionString() {
        return this.compilerVersionString;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(this.getSymbolTypeName());
        builder.append(":\n   Language: ");
        builder.append(this.language.toString());
        builder.append("\n   Target Processor: ");
        builder.append(this.processor.toString());
        builder.append("\n   Compiled for edit and continue: " + (this.compiledForEditAndContinue ? "yes" : "no"));
        builder.append("\n   Compiled withoug debugging info: " + (this.notCompiledWithDebugInfo ? "yes" : "no"));
        builder.append("\n   Compiled with LTCG: " + (this.compiledWithLinkTimeCodeGeneration ? "yes" : "no"));
        builder.append("\n   Compiled with /bzalign: " + (this.compiledWithBzalignNoDataAlign ? "yes" : "no"));
        builder.append("\n   Managed code present: " + (this.managedCodeDataPresent ? "yes" : "no"));
        builder.append("\n   Compiled with /GS: " + (this.compiledWithGsBufferSecurityChecks ? "yes" : "no"));
        builder.append("\n   Compiled with /hotpatch: " + (this.compiledWithHotPatch ? "yes" : "no"));
        builder.append("\n   Converted by CVTCIL: " + (this.convertedWithCvtcil ? "yes" : "no"));
        builder.append("\n   Microsoft Intermediate Language Module: " + (this.microsoftIntermediateLanguageNetModule ? "yes" : "no"));
        builder.append("\n   Compiled with /sdl: " + (this.compiledWithSdl ? "yes" : "no"));
        builder.append("\n   Compiled with Profile Guided Optimization (PGO): " + (this.compiledWithLtcgPgoOrPgu ? "yes" : "no"));
        builder.append("\n   .EXP module: " + (this.dotExpModule ? "yes" : "no"));
        builder.append(String.format("\n   Frontend Version: Major = %d, Minor = %d, Build = %d, QFE = %d", this.frontEndMajorVersionNumber, this.frontEndMinorVersionNumber, this.frontEndBuildVersionNumber, this.frontEndQuickFixEngineeringVersionNumber));
        builder.append(String.format("\n   Backend Version: Major = %d, Minor = %d, Build = %d, QFE = %d", this.backEndMajorVersionNumber, this.backEndMinorVersionNumber, this.backEndBuildVersionNumber, this.backEndQuickFixEngineeringVersionNumber));
        builder.append("\n   Version String:" + this.compilerVersionString);
        builder.append("\n");
    }

    @Override
    protected String getSymbolTypeName() {
        return "COMPILE3";
    }

    protected void processFlags(long flagsIn) {
        this.language = LanguageName.fromValue((int)(flagsIn & 0xFFL));
        this.compiledForEditAndContinue = ((flagsIn >>= 8) & 1L) == 1L;
        this.notCompiledWithDebugInfo = ((flagsIn >>= 1) & 1L) == 1L;
        this.compiledWithLinkTimeCodeGeneration = ((flagsIn >>= 1) & 1L) == 1L;
        this.compiledWithBzalignNoDataAlign = ((flagsIn >>= 1) & 1L) == 1L;
        this.managedCodeDataPresent = ((flagsIn >>= 1) & 1L) == 1L;
        this.compiledWithGsBufferSecurityChecks = ((flagsIn >>= 1) & 1L) == 1L;
        this.compiledWithHotPatch = ((flagsIn >>= 1) & 1L) == 1L;
        this.convertedWithCvtcil = ((flagsIn >>= 1) & 1L) == 1L;
        this.microsoftIntermediateLanguageNetModule = ((flagsIn >>= 1) & 1L) == 1L;
        this.compiledWithSdl = ((flagsIn >>= 1) & 1L) == 1L;
        this.compiledWithLtcgPgoOrPgu = ((flagsIn >>= 1) & 1L) == 1L;
        this.dotExpModule = ((flagsIn >>= 1) & 1L) == 1L;
    }
}

