/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.SymbolPathParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractComplexMsType;
import ghidra.app.util.pdb.PdbNamespaceUtils;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.program.model.data.DataType;

public abstract class AbstractComplexTypeApplier
extends MsTypeApplier {
    protected SymbolPath symbolPath;
    protected SymbolPath fixedSymbolPath;
    protected AbstractComplexTypeApplier definitionApplier = null;
    protected AbstractComplexTypeApplier forwardReferenceApplier = null;

    public static AbstractComplexTypeApplier getComplexApplier(PdbApplicator applicator, RecordNumber recordNumber) throws PdbException {
        return (AbstractComplexTypeApplier)applicator.getApplierSpec(recordNumber, AbstractComplexTypeApplier.class);
    }

    public AbstractComplexTypeApplier(PdbApplicator applicator, AbstractComplexMsType msType) {
        super(applicator, msType);
        String fullPathName = msType.getName();
        this.symbolPath = new SymbolPath(SymbolPathParser.parse((String)fullPathName));
    }

    SymbolPath getSymbolPath() {
        return this.symbolPath;
    }

    boolean isForwardReference() {
        return ((AbstractComplexMsType)this.msType).getMsProperty().isForwardReference();
    }

    boolean isNested() {
        return ((AbstractComplexMsType)this.msType).getMsProperty().isNestedClass();
    }

    boolean isFinal() {
        return ((AbstractComplexMsType)this.msType).getMsProperty().isSealed();
    }

    void setForwardReferenceApplier(AbstractComplexTypeApplier forwardReferenceApplier) {
        this.forwardReferenceApplier = forwardReferenceApplier;
    }

    void setDefinitionApplier(AbstractComplexTypeApplier definitionApplier) {
        this.definitionApplier = definitionApplier;
    }

    <T extends AbstractComplexTypeApplier> T getDefinitionApplier(Class<T> typeClass) {
        if (!typeClass.isInstance(this.definitionApplier)) {
            return null;
        }
        return (T)((AbstractComplexTypeApplier)typeClass.cast(this.definitionApplier));
    }

    protected AbstractComplexTypeApplier getAlternativeTypeApplier() {
        if (this.isForwardReference()) {
            return this.definitionApplier;
        }
        return this.forwardReferenceApplier;
    }

    protected SymbolPath getFixedSymbolPath() {
        if (this.fixedSymbolPath != null) {
            return this.fixedSymbolPath;
        }
        if (this.definitionApplier != null && this.definitionApplier.getFixedSymbolPath() != null) {
            this.fixedSymbolPath = this.definitionApplier.getFixedSymbolPath();
            return this.fixedSymbolPath;
        }
        SymbolPath fixed = PdbNamespaceUtils.convertToGhidraPathName(this.symbolPath, this.index);
        this.fixedSymbolPath = this.symbolPath.equals((Object)fixed) ? this.symbolPath : fixed;
        return this.fixedSymbolPath;
    }

    DataType getDataTypeInternal() {
        return this.dataType;
    }
}

