/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractArgumentsListMsType;
import ghidra.app.util.pdb.pdbapplicator.AbstractFunctionTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.PrimitiveTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Undefined;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ArgumentsListTypeApplier
extends MsTypeApplier {
    public ArgumentsListTypeApplier(PdbApplicator applicator, AbstractArgumentsListMsType msType) throws IllegalArgumentException {
        super(applicator, msType);
    }

    @Override
    void deferredApply() throws PdbException, CancelledException {
    }

    @Override
    void apply() throws PdbException, CancelledException {
    }

    @Override
    BigInteger getSize() {
        return BigInteger.ZERO;
    }

    void checkForDependencies(AbstractFunctionTypeApplier functionApplier) throws CancelledException {
        AbstractArgumentsListMsType argsList = (AbstractArgumentsListMsType)this.msType;
        List<RecordNumber> args = argsList.getArgRecordNumbers();
        for (RecordNumber arg : args) {
            this.applicator.checkCanceled();
            MsTypeApplier argApplier = this.applicator.getTypeApplier(arg);
            if (argApplier instanceof PrimitiveTypeApplier && ((PrimitiveTypeApplier)argApplier).isNoType()) break;
            if (!argApplier.isDeferred()) continue;
            this.applicator.addApplierDependency(functionApplier, argApplier);
            functionApplier.setDeferred();
        }
    }

    void applyTo(AbstractFunctionTypeApplier functionApplier) throws CancelledException {
        FunctionDefinitionDataType functionDefinition = functionApplier.getFunctionDefinition();
        AbstractArgumentsListMsType argsList = (AbstractArgumentsListMsType)this.msType;
        List<RecordNumber> args = argsList.getArgRecordNumbers();
        ArrayList<ParameterDefinitionImpl> parameterDefinitionList = new ArrayList<ParameterDefinitionImpl>();
        int parameterCount = 0;
        for (RecordNumber arg : args) {
            this.applicator.checkCanceled();
            MsTypeApplier argApplier = this.applicator.getTypeApplier(arg);
            if (argApplier instanceof PrimitiveTypeApplier && ((PrimitiveTypeApplier)argApplier).isNoType()) break;
            DataType argDataType = argApplier.getDataType();
            if (argDataType == null) {
                this.applicator.appendLogMsg("PDB Warning: No type conversion for " + argApplier.getMsType().toString() + " for parameter " + parameterCount + " of " + functionDefinition.getName());
                continue;
            }
            try {
                ParameterDefinitionImpl parameterDefinition = new ParameterDefinitionImpl(null, argDataType, "");
                parameterDefinitionList.add(parameterDefinition);
                ++parameterCount;
            }
            catch (IllegalArgumentException e) {
                try {
                    DataType substitute = Undefined.getUndefinedDataType((int)argDataType.getLength());
                    ParameterDefinitionImpl parameterDefinition = new ParameterDefinitionImpl(null, substitute, "");
                    parameterDefinitionList.add(parameterDefinition);
                    this.applicator.appendLogMsg("PDB Warning: Could not apply type " + argDataType + " for parameter " + ++parameterCount + " of " + functionDefinition.getName() + ". Using undefined type instead.");
                }
                catch (IllegalArgumentException e1) {
                    this.applicator.appendLogMsg("PDB Warning: Could not apply type " + argDataType + " for parameter " + parameterCount + " of " + functionDefinition.getName() + ". Undefined failed: " + e1);
                }
            }
        }
        functionDefinition.setArguments(parameterDefinitionList.toArray(new ParameterDefinition[parameterDefinitionList.size()]));
    }
}

