/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractNestedTypeExtMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractNestedTypeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassFieldMsAttributes;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;

public class NestedTypeApplier
extends MsTypeApplier {
    private MsTypeApplier nestedTypeDefinitionApplier = null;

    public NestedTypeApplier(PdbApplicator applicator, AbstractMsType msType) throws IllegalArgumentException {
        super(applicator, NestedTypeApplier.validateType(msType));
    }

    @Override
    BigInteger getSize() {
        if (this.nestedTypeDefinitionApplier == null) {
            return BigInteger.ZERO;
        }
        return this.nestedTypeDefinitionApplier.getSize();
    }

    String getTypeName() {
        if (this.nestedTypeDefinitionApplier == null) {
            return "";
        }
        return this.nestedTypeDefinitionApplier.getMsType().getName();
    }

    String getMemberName() {
        if (this.nestedTypeDefinitionApplier == null) {
            return "";
        }
        if (this.msType instanceof AbstractNestedTypeMsType) {
            return ((AbstractNestedTypeMsType)this.msType).getName();
        }
        return ((AbstractNestedTypeExtMsType)this.msType).getName();
    }

    MsTypeApplier getNestedTypeDefinitionApplier() {
        return this.applicator.getTypeApplier(this.getNestedTypeDefinitionRecordNumber());
    }

    RecordNumber getNestedTypeDefinitionRecordNumber() {
        if (this.msType instanceof AbstractNestedTypeMsType) {
            return ((AbstractNestedTypeMsType)this.msType).getNestedTypeDefinitionRecordNumber();
        }
        return ((AbstractNestedTypeExtMsType)this.msType).getNestedTypeDefinitionRecordNumber();
    }

    boolean hasAttributes() {
        if (this.nestedTypeDefinitionApplier == null) {
            return false;
        }
        return !(this.nestedTypeDefinitionApplier.getMsType() instanceof AbstractNestedTypeMsType);
    }

    ClassFieldMsAttributes getAttributes() {
        AbstractMsType type = this.nestedTypeDefinitionApplier.getMsType();
        if (type instanceof AbstractNestedTypeExtMsType) {
            return ((AbstractNestedTypeExtMsType)type).getClassFieldAttributes();
        }
        return null;
    }

    @Override
    void apply() throws PdbException, CancelledException {
        this.dataType = this.msType instanceof AbstractNestedTypeMsType ? this.applyNestedTypeMsType((AbstractNestedTypeMsType)this.msType) : this.applyNestedTypeExtMsType((AbstractNestedTypeExtMsType)this.msType);
    }

    private DataType applyNestedTypeMsType(AbstractNestedTypeMsType type) {
        this.nestedTypeDefinitionApplier = this.applicator.getTypeApplier(type.getNestedTypeDefinitionRecordNumber());
        return this.nestedTypeDefinitionApplier.getDataType();
    }

    private DataType applyNestedTypeExtMsType(AbstractNestedTypeExtMsType type) {
        this.nestedTypeDefinitionApplier = this.applicator.getTypeApplier(type.getNestedTypeDefinitionRecordNumber());
        return this.nestedTypeDefinitionApplier.getDataType();
    }

    @Override
    DataType getCycleBreakType() {
        return this.dataType;
    }

    MsTypeApplier getNestedTypeApplier() {
        return this.nestedTypeDefinitionApplier;
    }

    private static AbstractMsType validateType(AbstractMsType type) throws IllegalArgumentException {
        if (!(type instanceof AbstractNestedTypeMsType) && !(type instanceof AbstractNestedTypeExtMsType)) {
            throw new IllegalArgumentException("PDB Incorrectly applying " + type.getClass().getSimpleName() + " to " + NestedTypeApplier.class.getSimpleName());
        }
        return type;
    }
}

