/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractModuleInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractSectionContribution;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractTypeProgramInterface;
import ghidra.app.util.bin.format.pdb2.pdbreader.GlobalSymbolInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.PublicSymbolInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractThunkMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractUserDefinedTypeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AddressMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.PeCoffGroupMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.PeCoffSectionMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.pdb.PdbCategories;
import ghidra.app.util.pdb.pdbapplicator.ComplexTypeApplierMapper;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbAddressManager;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorControl;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorMetrics;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorOptions;
import ghidra.app.util.pdb.pdbapplicator.PdbCliInfoManager;
import ghidra.app.util.pdb.pdbapplicator.PdbPrimitiveTypeApplicator;
import ghidra.app.util.pdb.pdbapplicator.PdbRegisterNameToProgramRegisterMapper;
import ghidra.app.util.pdb.pdbapplicator.PdbResearch;
import ghidra.app.util.pdb.pdbapplicator.PdbVbtManager;
import ghidra.app.util.pdb.pdbapplicator.SymbolApplierFactory;
import ghidra.app.util.pdb.pdbapplicator.SymbolGroup;
import ghidra.app.util.pdb.pdbapplicator.TypeApplierFactory;
import ghidra.app.util.pdb.pdbapplicator.VbtManager;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.graph.DefaultGEdge;
import ghidra.graph.GEdge;
import ghidra.graph.GraphAlgorithms;
import ghidra.graph.algo.GraphNavigator;
import ghidra.graph.jung.JungDirectedGraph;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.CancelOnlyWrappingTaskMonitor;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class PdbApplicator {
    private static final String THUNK_NAME_PREFIX = "[thunk]:";
    private String pdbFilename;
    private AbstractPdb pdb;
    private PdbApplicatorMetrics pdbApplicatorMetrics;
    private Program program;
    private PdbApplicatorOptions applicatorOptions;
    private MessageLog log;
    private TaskMonitor monitor;
    private CancelOnlyWrappingTaskMonitor cancelOnlyWrappingMonitor;
    private Address imageBase;
    private DataTypeManager dataTypeManager;
    private PdbAddressManager pdbAddressManager;
    private List<SymbolGroup> symbolGroups;
    private PdbCliInfoManager pdbCliManagedInfoManager;
    VbtManager vbtManager;
    PdbRegisterNameToProgramRegisterMapper registerNameToRegisterMapper;
    private int resolveCount;
    private PdbCategories categoryUtils;
    private PdbPrimitiveTypeApplicator pdbPrimitiveTypeApplicator;
    private TypeApplierFactory typeApplierParser;
    private ComplexTypeApplierMapper complexApplierMapper;
    private JungDirectedGraph<MsTypeApplier, GEdge<MsTypeApplier>> applierDependencyGraph;
    private Map<SymbolPath, Boolean> isClassByNamespace;
    private SymbolApplierFactory symbolApplierParser;
    private Map<Address, Set<String>> labelsByAddress;
    private Map<String, Set<RecordNumber>> recordNumbersByFileName;
    private Map<Integer, Set<RecordNumber>> recordNumbersByModuleNumber;
    private Map<Address, PrimarySymbolInfo> primarySymbolInfoByAddress = new HashMap<Address, PrimarySymbolInfo>();

    static long bigIntegerToLong(PdbApplicator myApplicator, BigInteger big) {
        try {
            return big.longValueExact();
        }
        catch (ArithmeticException e) {
            String msg = "BigInteger value greater than max Long: " + big;
            PdbLog.message(msg);
            myApplicator.appendLogMsg(msg);
            return Long.MAX_VALUE;
        }
    }

    static int bigIntegerToInt(PdbApplicator myApplicator, BigInteger big) {
        try {
            return big.intValueExact();
        }
        catch (ArithmeticException e) {
            String msg = "BigInteger value greater than max Integer: " + big;
            PdbLog.message(msg);
            myApplicator.appendLogMsg(msg);
            return Integer.MAX_VALUE;
        }
    }

    public PdbApplicator(String pdbFilename, AbstractPdb pdb) {
        Objects.requireNonNull(pdbFilename, "pdbFilename cannot be null");
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdbFilename = pdbFilename;
        this.pdb = pdb;
    }

    public void applyTo(Program programParam, DataTypeManager dataTypeManagerParam, Address imageBaseParam, PdbApplicatorOptions applicatorOptionsParam, TaskMonitor monitorParam, MessageLog logParam) throws PdbException, CancelledException {
        this.initializeApplyTo(programParam, dataTypeManagerParam, imageBaseParam, applicatorOptionsParam, monitorParam, logParam);
        switch (this.applicatorOptions.getProcessingControl()) {
            case DATA_TYPES_ONLY: {
                this.processTypes();
                break;
            }
            case PUBLIC_SYMBOLS_ONLY: {
                this.processPublicSymbols();
                break;
            }
            case ALL: {
                this.processTypes();
                this.processSymbols();
                break;
            }
            default: {
                throw new PdbException("PDB: Invalid Application Control: " + this.applicatorOptions.getProcessingControl());
            }
        }
        if (this.program != null) {
            Options options = this.program.getOptions("Program Information");
            options.setBoolean("PDB Loaded", true);
        }
        this.pdbAddressManager.logReport();
        this.pdbApplicatorMetrics.logReport();
        Msg.info((Object)this, (Object)"PDB Terminated Normally");
    }

    private void processTypes() throws CancelledException, PdbException {
        this.setMonitorMessage("PDB: Applying to DTM " + this.dataTypeManager.getName() + "...");
        PdbResearch.initBreakPointRecordNumbers();
        this.resolveCount = 0;
        this.complexApplierMapper.mapAppliers(this.monitor);
        this.processSequentially();
        this.processDeferred();
        this.resolveSequentially();
        Msg.info((Object)this, (Object)("resolveCount: " + this.resolveCount));
        if (this.program != null) {
            this.defineClasses();
        }
        this.processGlobalTypdefSymbols();
    }

    private void processSymbols() throws CancelledException, PdbException {
        this.processGlobalSymbolsNoTypedefs();
        this.processPublicSymbols();
        this.processModuleSymbols();
        this.processThunkSymbolsFromNonLinkerModules();
    }

    private void initializeApplyTo(Program programParam, DataTypeManager dataTypeManagerParam, Address imageBaseParam, PdbApplicatorOptions applicatorOptionsParam, TaskMonitor monitorParam, MessageLog logParam) throws PdbException, CancelledException {
        this.validateAndSetParameters(programParam, dataTypeManagerParam, imageBaseParam, applicatorOptionsParam, monitorParam, logParam);
        this.cancelOnlyWrappingMonitor = new CancelOnlyWrappingTaskMonitor(this.monitor);
        this.pdbApplicatorMetrics = new PdbApplicatorMetrics();
        this.pdbAddressManager = new PdbAddressManager(this, this.imageBase);
        this.pdbCliManagedInfoManager = new PdbCliInfoManager(this);
        this.symbolGroups = this.createSymbolGroups();
        this.categoryUtils = this.setPdbCatogoryUtils(this.pdbFilename);
        this.pdbPrimitiveTypeApplicator = new PdbPrimitiveTypeApplicator(this.dataTypeManager);
        this.typeApplierParser = new TypeApplierFactory(this);
        this.complexApplierMapper = new ComplexTypeApplierMapper(this);
        this.applierDependencyGraph = new JungDirectedGraph();
        this.isClassByNamespace = new TreeMap<SymbolPath, Boolean>();
        if (this.program != null) {
            PdbVbtManager pdbVbtManager = new PdbVbtManager(this);
            this.vbtManager = pdbVbtManager;
            this.registerNameToRegisterMapper = new PdbRegisterNameToProgramRegisterMapper(this.program);
        } else {
            this.vbtManager = new VbtManager(this.getDataTypeManager());
        }
        this.symbolApplierParser = new SymbolApplierFactory(this);
        this.labelsByAddress = new HashMap<Address, Set<String>>();
        this.recordNumbersByFileName = new HashMap<String, Set<RecordNumber>>();
        this.recordNumbersByModuleNumber = new HashMap<Integer, Set<RecordNumber>>();
    }

    private void validateAndSetParameters(Program programParam, DataTypeManager dataTypeManagerParam, Address imageBaseParam, PdbApplicatorOptions applicatorOptionsParam, TaskMonitor monitorParam, MessageLog logParam) throws PdbException {
        PdbApplicatorOptions pdbApplicatorOptions = this.applicatorOptions = applicatorOptionsParam != null ? applicatorOptionsParam : new PdbApplicatorOptions();
        if (programParam == null) {
            if (dataTypeManagerParam == null) {
                throw new PdbException("PDB: programParam and dataTypeManagerParam may not both be null.");
            }
            if (imageBaseParam == null) {
                throw new PdbException("PDB: programParam and imageBaseParam may not both be null.");
            }
            if (this.applicatorOptions.getProcessingControl() != PdbApplicatorControl.DATA_TYPES_ONLY) {
                throw new PdbException("PDB: programParam may not be null for the chosen Applicator Control: " + this.applicatorOptions.getProcessingControl());
            }
        }
        this.monitor = monitorParam != null ? monitorParam : TaskMonitor.DUMMY;
        this.log = logParam != null ? logParam : new MessageLog();
        this.program = programParam;
        this.dataTypeManager = dataTypeManagerParam != null ? dataTypeManagerParam : this.program.getDataTypeManager();
        this.imageBase = imageBaseParam != null ? imageBaseParam : this.program.getImageBase();
    }

    private List<SymbolGroup> createSymbolGroups() throws CancelledException, PdbException {
        ArrayList<SymbolGroup> mySymbolGroups = new ArrayList<SymbolGroup>();
        int num = this.pdb.getDebugInfo().getNumModules();
        for (int moduleNumber = 0; moduleNumber <= num; ++moduleNumber) {
            this.monitor.checkCanceled();
            Map<Long, AbstractMsSymbol> symbols = this.pdb.getDebugInfo().getModuleSymbolsByOffset(moduleNumber);
            SymbolGroup symbolGroup = new SymbolGroup(symbols, moduleNumber);
            mySymbolGroups.add(symbolGroup);
        }
        return mySymbolGroups;
    }

    PdbApplicatorOptions getPdbApplicatorOptions() {
        return this.applicatorOptions;
    }

    void checkCanceled() throws CancelledException {
        this.monitor.checkCanceled();
    }

    void setMonitorMessage(String message) {
        this.monitor.setMessage(message);
    }

    void appendLogMsg(String message) {
        this.log.appendMsg(message);
    }

    MessageLog getMessageLog() {
        return this.log;
    }

    void pdbLogAndInfoMessage(Object originator, String message) {
        PdbLog.message(message);
        Msg.info((Object)originator, (Object)message);
    }

    void pdbLogAndErrorMessage(Object originator, String message, Exception exc) {
        PdbLog.message(message);
        if (exc != null) {
            Msg.error((Object)originator, (Object)message);
        } else {
            Msg.error((Object)originator, (Object)message, (Throwable)exc);
        }
    }

    TaskMonitor getMonitor() {
        return this.monitor;
    }

    TaskMonitor getCancelOnlyWrappingMonitor() {
        return this.cancelOnlyWrappingMonitor;
    }

    PdbApplicatorMetrics getPdbApplicatorMetrics() {
        return this.pdbApplicatorMetrics;
    }

    AbstractPdb getPdb() {
        return this.pdb;
    }

    Program getProgram() {
        return this.program;
    }

    DataTypeManager getDataTypeManager() {
        return this.dataTypeManager;
    }

    DataOrganization getDataOrganization() {
        return this.dataTypeManager.getDataOrganization();
    }

    PdbPrimitiveTypeApplicator getPdbPrimitiveTypeApplicator() {
        return this.pdbPrimitiveTypeApplicator;
    }

    CategoryPath getCategory(SymbolPath symbolPath) {
        return this.categoryUtils.getCategory(symbolPath);
    }

    CategoryPath getTypedefsCategory(int moduleNumber, SymbolPath symbolPath) {
        return this.categoryUtils.getTypedefsCategory(moduleNumber, symbolPath);
    }

    CategoryPath getAnonymousFunctionsCategory() {
        return this.categoryUtils.getAnonymousFunctionsCategory();
    }

    CategoryPath getAnonymousTypesCategory() {
        return this.categoryUtils.getAnonymousTypesCategory();
    }

    private PdbCategories setPdbCatogoryUtils(String pdbFilename) throws CancelledException, PdbException {
        int index;
        ArrayList<String> categoryNames = new ArrayList<String>();
        int num = this.pdb.getDebugInfo().getNumModules();
        for (index = 1; index <= num; ++index) {
            this.monitor.checkCanceled();
            String moduleName = this.pdb.getDebugInfo().getModuleInformation(index).getModuleName();
            categoryNames.add(moduleName);
        }
        index = pdbFilename.lastIndexOf("\\");
        if (index == -1) {
            index = pdbFilename.lastIndexOf("/");
        }
        return new PdbCategories(pdbFilename.substring(index + 1), categoryNames);
    }

    void addApplierDependency(MsTypeApplier depender) {
        Objects.requireNonNull(depender);
        this.applierDependencyGraph.addVertex((Object)depender.getDependencyApplier());
    }

    void addApplierDependency(MsTypeApplier depender, MsTypeApplier dependee) {
        Objects.requireNonNull(depender);
        Objects.requireNonNull(dependee);
        this.applierDependencyGraph.addEdge((GEdge)new DefaultGEdge((Object)depender.getDependencyApplier(), (Object)dependee.getDependencyApplier()));
    }

    List<MsTypeApplier> getVerticesInPostOrder() {
        this.setMonitorMessage("PDB: Determining data type dependency order...");
        return GraphAlgorithms.getVerticesInPostOrder(this.applierDependencyGraph, (GraphNavigator)GraphNavigator.topDownNavigator());
    }

    MsTypeApplier getApplierSpec(RecordNumber recordNumber, Class<? extends MsTypeApplier> expected) throws PdbException {
        return this.typeApplierParser.getApplierSpec(recordNumber, expected);
    }

    MsTypeApplier getApplierOrNoTypeSpec(RecordNumber recordNumber, Class<? extends MsTypeApplier> expected) throws PdbException {
        return this.typeApplierParser.getApplierOrNoTypeSpec(recordNumber, expected);
    }

    MsTypeApplier getTypeApplier(RecordNumber recordNumber) {
        return this.typeApplierParser.getTypeApplier(recordNumber);
    }

    MsTypeApplier getTypeApplier(AbstractMsType type) {
        return this.typeApplierParser.getTypeApplier(type);
    }

    int findModuleNumberBySectionOffsetContribution(int section, long offset) throws PdbException {
        for (AbstractSectionContribution sectionContribution : this.pdb.getDebugInfo().getSectionContributionList()) {
            int sectionContributionOffset = sectionContribution.getOffset();
            int maxSectionContributionOffset = sectionContributionOffset + sectionContribution.getLength();
            if (offset < (long)sectionContributionOffset || offset >= (long)maxSectionContributionOffset) continue;
            return sectionContribution.getModule();
        }
        throw new PdbException("PDB: Module not found for section/offset");
    }

    private void processDataTypesSequentially() throws CancelledException, PdbException {
        AbstractTypeProgramInterface tpi = this.pdb.getTypeProgramInterface();
        if (tpi == null) {
            return;
        }
        int num = tpi.getTypeIndexMaxExclusive() - tpi.getTypeIndexMin();
        this.monitor.initialize((long)num);
        this.setMonitorMessage("PDB: Processing " + num + " data type components...");
        for (int indexNumber = tpi.getTypeIndexMin(); indexNumber < tpi.getTypeIndexMaxExclusive(); ++indexNumber) {
            this.monitor.checkCanceled();
            MsTypeApplier applier = this.getTypeApplier(RecordNumber.typeRecordNumber(indexNumber));
            applier.apply();
            this.monitor.incrementProgress(1L);
        }
    }

    void putRecordNumberByFileName(RecordNumber recordNumber, String filename) {
        Set<RecordNumber> recordNumbers = this.recordNumbersByFileName.get(filename);
        if (recordNumbers == null) {
            recordNumbers = new HashSet<RecordNumber>();
            this.recordNumbersByFileName.put(filename, recordNumbers);
        }
        recordNumbers.add(recordNumber);
    }

    void putRecordNumberByModuleNumber(RecordNumber recordNumber, int moduleNumber) {
        Set<RecordNumber> recordNumbers = this.recordNumbersByModuleNumber.get(moduleNumber);
        if (recordNumbers == null) {
            recordNumbers = new HashSet<RecordNumber>();
            this.recordNumbersByModuleNumber.put(moduleNumber, recordNumbers);
        }
        recordNumbers.add(recordNumber);
    }

    void dumpSourceFileRecordNumbers() {
        AbstractMsType msType;
        PdbLog.message("RecordNumbersByFileName");
        for (Map.Entry<String, Set<RecordNumber>> entry : this.recordNumbersByFileName.entrySet()) {
            String filename = entry.getKey();
            PdbLog.message("FileName: " + filename);
            for (RecordNumber recordNumber : entry.getValue()) {
                msType = this.pdb.getTypeRecord(recordNumber);
                PdbLog.message(recordNumber.toString() + "\n" + msType);
            }
        }
        PdbLog.message("RecordNumbersByModuleNumber");
        for (Map.Entry<Object, Set<RecordNumber>> entry : this.recordNumbersByModuleNumber.entrySet()) {
            int moduleNumber = (Integer)entry.getKey();
            PdbLog.message("ModuleNumber: " + moduleNumber);
            for (RecordNumber recordNumber : entry.getValue()) {
                msType = this.pdb.getTypeRecord(recordNumber);
                PdbLog.message(recordNumber.toString() + "\n" + msType);
            }
        }
    }

    private void processItemTypesSequentially() throws CancelledException, PdbException {
        AbstractTypeProgramInterface ipi = this.pdb.getItemProgramInterface();
        if (ipi == null) {
            return;
        }
        int num = ipi.getTypeIndexMaxExclusive() - ipi.getTypeIndexMin();
        this.monitor.initialize((long)num);
        this.setMonitorMessage("PDB: Processing " + num + " item type components...");
        for (int indexNumber = ipi.getTypeIndexMin(); indexNumber < ipi.getTypeIndexMaxExclusive(); ++indexNumber) {
            this.monitor.checkCanceled();
            MsTypeApplier applier = this.getTypeApplier(RecordNumber.itemRecordNumber(indexNumber));
            applier.apply();
            this.monitor.incrementProgress(1L);
        }
    }

    private void processSequentially() throws CancelledException, PdbException {
        this.processDataTypesSequentially();
        this.processItemTypesSequentially();
    }

    private void processDeferred() throws CancelledException, PdbException {
        List<MsTypeApplier> verticesInPostOrder = this.getVerticesInPostOrder();
        this.monitor.initialize((long)verticesInPostOrder.size());
        this.setMonitorMessage("PDB: Processing " + verticesInPostOrder.size() + " deferred data type dependencies...");
        for (MsTypeApplier applier : verticesInPostOrder) {
            this.monitor.checkCanceled();
            if (applier.isDeferred()) {
                applier.deferredApply();
            }
            this.monitor.incrementProgress(1L);
        }
    }

    private void resolveSequentially() throws CancelledException {
        AbstractTypeProgramInterface tpi = this.pdb.getTypeProgramInterface();
        if (tpi == null) {
            return;
        }
        int num = tpi.getTypeIndexMaxExclusive() - tpi.getTypeIndexMin();
        this.monitor.initialize((long)num);
        this.setMonitorMessage("PDB: Resolving " + num + " data type components...");
        Date start = new Date();
        long longStart = start.getTime();
        for (int indexNumber = tpi.getTypeIndexMin(); indexNumber < tpi.getTypeIndexMaxExclusive(); ++indexNumber) {
            this.monitor.checkCanceled();
            MsTypeApplier applier = this.getTypeApplier(RecordNumber.typeRecordNumber(indexNumber));
            applier.resolve();
            this.monitor.incrementProgress(1L);
        }
        Date stop = new Date();
        long longStop = stop.getTime();
        long timeDiff = longStop - longStart;
        Msg.info((Object)this, (Object)("Resolve time: " + timeDiff + " mS"));
    }

    DataType resolve(DataType dataType) {
        DataType resolved = this.getDataTypeManager().resolve(dataType, DataTypeConflictHandler.REPLACE_EMPTY_STRUCTS_OR_RENAME_AND_ADD_HANDLER);
        ++this.resolveCount;
        return resolved;
    }

    SymbolGroup getSymbolGroup() {
        return this.getSymbolGroupForModule(0);
    }

    SymbolGroup getSymbolGroupForModule(int moduleNumber) {
        return this.symbolGroups.get(moduleNumber);
    }

    boolean isInvalidAddress(Address address, String name) {
        if (address == PdbAddressManager.BAD_ADDRESS) {
            this.appendLogMsg("Invalid address encountered for: " + name);
            return true;
        }
        if (address == PdbAddressManager.ZERO_ADDRESS) {
            return true;
        }
        return address == PdbAddressManager.EXTERNAL_ADDRESS;
    }

    Address getImageBase() {
        return this.imageBase;
    }

    Address getAddress(AddressMsSymbol symbol) {
        return this.pdbAddressManager.getAddress(symbol);
    }

    Address getAddress(int segment, long offset) {
        return this.pdbAddressManager.getRawAddress(segment, offset);
    }

    Address getRawAddress(AddressMsSymbol symbol) {
        return this.pdbAddressManager.getRawAddress(symbol);
    }

    Address witnessSymbolNameAtAddress(String name, Address address) {
        return this.pdbAddressManager.witnessSymbolNameAtAddress(name, address);
    }

    Address getRemapAddressByAddress(Address address) {
        return this.pdbAddressManager.getRemapAddressByAddress(address);
    }

    void putRealAddressesBySection(int sectionNum, long realAddress) {
        this.pdbAddressManager.putRealAddressesBySection(sectionNum, realAddress);
    }

    void addMemoryGroupRefinement(PeCoffGroupMsSymbol symbol) {
        this.pdbAddressManager.addMemoryGroupRefinement(symbol);
    }

    void addMemorySectionRefinement(PeCoffSectionMsSymbol symbol) {
        this.pdbAddressManager.addMemorySectionRefinement(symbol);
    }

    boolean isDll() {
        return this.pdbCliManagedInfoManager.isDll();
    }

    boolean isAslr() {
        return this.pdbCliManagedInfoManager.isAslr();
    }

    CliAbstractTableRow getCliTableRow(int tableNum, int rowNum) throws PdbException {
        return this.pdbCliManagedInfoManager.getCliTableRow(tableNum, rowNum);
    }

    VbtManager getVbtManager() {
        return this.vbtManager;
    }

    Register getRegister(String pdbRegisterName) {
        return this.registerNameToRegisterMapper.getRegister(pdbRegisterName);
    }

    private void processAllSymbols() throws CancelledException, PdbException {
        this.processMainSymbols();
        this.processModuleSymbols();
    }

    private void processMainSymbols() throws CancelledException, PdbException {
        SymbolGroup symbolGroup = this.getSymbolGroup();
        int totalCount = symbolGroup.size();
        this.setMonitorMessage("PDB: Applying " + totalCount + " main symbol components...");
        this.monitor.initialize((long)totalCount);
        SymbolGroup.AbstractMsSymbolIterator iter = symbolGroup.iterator();
        this.processSymbolGroup(0, iter);
    }

    private void processModuleSymbols() throws CancelledException {
        SymbolGroup symbolGroup;
        int moduleNumber;
        int totalCount = 0;
        int num = this.pdb.getDebugInfo().getNumModules();
        for (moduleNumber = 1; moduleNumber <= num; ++moduleNumber) {
            this.monitor.checkCanceled();
            symbolGroup = this.getSymbolGroupForModule(moduleNumber);
            totalCount += symbolGroup.size();
        }
        this.setMonitorMessage("PDB: Applying " + totalCount + " module symbol components...");
        this.monitor.initialize((long)totalCount);
        for (moduleNumber = 1; moduleNumber <= num; ++moduleNumber) {
            this.monitor.checkCanceled();
            symbolGroup = this.getSymbolGroupForModule(moduleNumber);
            SymbolGroup.AbstractMsSymbolIterator iter = symbolGroup.iterator();
            this.processSymbolGroup(moduleNumber, iter);
        }
    }

    private void processSymbolGroup(int moduleNumber, SymbolGroup.AbstractMsSymbolIterator iter) throws CancelledException {
        iter.initGet();
        while (iter.hasNext()) {
            this.monitor.checkCanceled();
            this.procSym(iter);
            this.monitor.incrementProgress(1L);
        }
    }

    private void processPublicSymbols() throws CancelledException, PdbException {
        SymbolGroup symbolGroup = this.getSymbolGroup();
        PublicSymbolInformation publicSymbolInformation = this.pdb.getDebugInfo().getPublicSymbolInformation();
        List<Long> offsets = publicSymbolInformation.getModifiedHashRecordSymbolOffsets();
        this.setMonitorMessage("PDB: Applying " + offsets.size() + " public symbol components...");
        this.monitor.initialize((long)offsets.size());
        SymbolGroup.AbstractMsSymbolIterator iter = symbolGroup.iterator();
        for (long offset : offsets) {
            this.monitor.checkCanceled();
            iter.initGetByOffset(offset);
            if (!iter.hasNext()) break;
            this.pdbApplicatorMetrics.witnessPublicSymbolType(iter.peek());
            this.procSym(iter);
            this.monitor.incrementProgress(1L);
        }
    }

    private void processGlobalSymbolsNoTypedefs() throws CancelledException, PdbException {
        SymbolGroup symbolGroup = this.getSymbolGroup();
        GlobalSymbolInformation globalSymbolInformation = this.pdb.getDebugInfo().getGlobalSymbolInformation();
        List<Long> offsets = globalSymbolInformation.getModifiedHashRecordSymbolOffsets();
        this.setMonitorMessage("PDB: Applying global symbols...");
        this.monitor.initialize((long)offsets.size());
        SymbolGroup.AbstractMsSymbolIterator iter = symbolGroup.iterator();
        for (long offset : offsets) {
            this.monitor.checkCanceled();
            iter.initGetByOffset(offset);
            if (!iter.hasNext()) break;
            AbstractMsSymbol symbol = iter.peek();
            this.pdbApplicatorMetrics.witnessGlobalSymbolType(symbol);
            if (!(symbol instanceof AbstractUserDefinedTypeMsSymbol)) {
                this.procSym(iter);
            }
            this.monitor.incrementProgress(1L);
        }
    }

    private void processGlobalTypdefSymbols() throws CancelledException, PdbException {
        SymbolGroup symbolGroup = this.getSymbolGroup();
        GlobalSymbolInformation globalSymbolInformation = this.pdb.getDebugInfo().getGlobalSymbolInformation();
        List<Long> offsets = globalSymbolInformation.getModifiedHashRecordSymbolOffsets();
        this.setMonitorMessage("PDB: Applying typedefs...");
        this.monitor.initialize((long)offsets.size());
        SymbolGroup.AbstractMsSymbolIterator iter = symbolGroup.iterator();
        for (long offset : offsets) {
            this.monitor.checkCanceled();
            iter.initGetByOffset(offset);
            if (!iter.hasNext()) break;
            AbstractMsSymbol symbol = iter.peek();
            if (symbol instanceof AbstractUserDefinedTypeMsSymbol) {
                this.procSym(iter);
            }
            this.monitor.incrementProgress(1L);
        }
    }

    private void processNonPublicOrGlobalSymbols() throws CancelledException, PdbException {
        Set<Long> offsetsRemaining = this.getSymbolGroup().getOffsets();
        for (long off : this.pdb.getDebugInfo().getPublicSymbolInformation().getModifiedHashRecordSymbolOffsets()) {
            this.monitor.checkCanceled();
            offsetsRemaining.remove(off);
        }
        for (long off : this.pdb.getDebugInfo().getGlobalSymbolInformation().getModifiedHashRecordSymbolOffsets()) {
            this.monitor.checkCanceled();
            offsetsRemaining.remove(off);
        }
        this.setMonitorMessage("PDB: Applying " + offsetsRemaining.size() + " other symbol components...");
        this.monitor.initialize((long)offsetsRemaining.size());
        SymbolGroup symbolGroup = this.getSymbolGroup();
        SymbolGroup.AbstractMsSymbolIterator iter = symbolGroup.iterator();
        for (long offset : offsetsRemaining) {
            this.monitor.checkCanceled();
            iter.initGetByOffset(offset);
            AbstractMsSymbol symbol = iter.peek();
            this.procSym(iter);
            this.monitor.incrementProgress(1L);
        }
    }

    private int findLinkerModuleNumber() {
        if (this.pdb.getDebugInfo() != null) {
            int num = 1;
            for (AbstractModuleInformation module : this.pdb.getDebugInfo().getModuleInformationList()) {
                if (this.isLinkerModule(module.getModuleName())) {
                    return num;
                }
                ++num;
            }
        }
        this.pdbLogAndInfoMessage(this, "Not processing linker symbols because linker module not found");
        return -1;
    }

    private boolean isLinkerModule(String name) {
        return "* Linker *".equals(name);
    }

    private boolean processLinkerSymbols() throws CancelledException {
        int linkerModuleNumber = this.findLinkerModuleNumber();
        if (linkerModuleNumber == -1) {
            return false;
        }
        SymbolGroup symbolGroup = this.getSymbolGroupForModule(linkerModuleNumber);
        if (symbolGroup == null) {
            Msg.info((Object)this, (Object)"No symbols to process from linker module.");
            return false;
        }
        this.setMonitorMessage("PDB: Applying " + symbolGroup.size() + " linker symbol components...");
        this.monitor.initialize((long)symbolGroup.size());
        SymbolGroup.AbstractMsSymbolIterator iter = symbolGroup.iterator();
        while (iter.hasNext()) {
            this.checkCanceled();
            this.pdbApplicatorMetrics.witnessLinkerSymbolType(iter.peek());
            this.procSym(iter);
            this.monitor.incrementProgress(1L);
        }
        return true;
    }

    private void processThunkSymbolsFromNonLinkerModules() throws CancelledException {
        SymbolGroup symbolGroup;
        int index;
        int linkerModuleNumber = this.findLinkerModuleNumber();
        int totalCount = 0;
        int num = this.pdb.getDebugInfo().getNumModules();
        for (index = 1; index <= num; ++index) {
            this.monitor.checkCanceled();
            if (index == linkerModuleNumber) continue;
            symbolGroup = this.getSymbolGroupForModule(index);
            totalCount += symbolGroup.size();
        }
        this.setMonitorMessage("PDB: Processing module thunks...");
        this.monitor.initialize((long)totalCount);
        for (index = 1; index <= num; ++index) {
            this.monitor.checkCanceled();
            if (index == linkerModuleNumber) continue;
            symbolGroup = this.getSymbolGroupForModule(index);
            SymbolGroup.AbstractMsSymbolIterator iter = symbolGroup.iterator();
            while (iter.hasNext()) {
                this.monitor.checkCanceled();
                AbstractMsSymbol symbol = iter.peek();
                if (symbol instanceof AbstractThunkMsSymbol) {
                    this.procSym(iter);
                } else {
                    iter.next();
                }
                this.monitor.incrementProgress(1L);
            }
        }
    }

    MsSymbolApplier getSymbolApplier(SymbolGroup.AbstractMsSymbolIterator iter) throws CancelledException {
        return this.symbolApplierParser.getSymbolApplier(iter);
    }

    void procSym(SymbolGroup.AbstractMsSymbolIterator iter) throws CancelledException {
        try {
            MsSymbolApplier applier = this.getSymbolApplier(iter);
            applier.apply();
        }
        catch (PdbException e) {
            Msg.info((Object)this, (Object)("Error applying symbol to program: " + e.toString()));
        }
    }

    boolean isClass(SymbolPath path) {
        return this.isClassByNamespace.get(path);
    }

    void predefineClass(SymbolPath classPath) {
        this.isClassByNamespace.put(classPath, true);
        for (SymbolPath path = classPath.getParent(); path != null; path = path.getParent()) {
            if (this.isClassByNamespace.containsKey(path)) continue;
            this.isClassByNamespace.put(path, false);
        }
    }

    private void defineClasses() throws CancelledException {
        this.monitor.initialize((long)this.isClassByNamespace.size());
        this.setMonitorMessage("PDB: Defining classes...");
        for (Map.Entry<SymbolPath, Boolean> entry : this.isClassByNamespace.entrySet()) {
            this.monitor.checkCanceled();
            SymbolPath path = entry.getKey();
            boolean isClass = entry.getValue();
            Namespace parentNamespace = NamespaceUtils.getNonFunctionNamespace((Program)this.program, (SymbolPath)path.getParent());
            if (parentNamespace == null) {
                String type = isClass ? "class" : "namespace";
                this.log.appendMsg("PDB Warning: Because parent namespace does not exist, failed to define " + type + ": " + path);
                continue;
            }
            this.defineNamespace(parentNamespace, path.getName(), isClass);
            this.monitor.incrementProgress(1L);
        }
    }

    private void defineNamespace(Namespace parentNamespace, String name, boolean isClass) {
        try {
            SymbolTable symbolTable = this.program.getSymbolTable();
            Namespace namespace = symbolTable.getNamespace(name, parentNamespace);
            if (namespace != null) {
                if (isClass) {
                    if (namespace instanceof GhidraClass) {
                        return;
                    }
                    if (this.isSimpleNamespaceSymbol(namespace)) {
                        NamespaceUtils.convertNamespaceToClass((Namespace)namespace);
                        return;
                    }
                } else if (namespace.getSymbol().getSymbolType() == SymbolType.NAMESPACE) {
                    return;
                }
                this.log.appendMsg("PDB Warning: Unable to create class namespace due to conflicting symbol: " + namespace.getName(true));
            } else if (isClass) {
                symbolTable.createClass(parentNamespace, name, SourceType.IMPORTED);
            } else {
                symbolTable.createNameSpace(parentNamespace, name, SourceType.IMPORTED);
            }
        }
        catch (DuplicateNameException | InvalidInputException e) {
            this.log.appendMsg("PDB Warning: Unable to create class namespace due to exception: " + e.toString() + "; Namespace: " + parentNamespace.getName(true) + "::" + name);
        }
    }

    private boolean isSimpleNamespaceSymbol(Namespace namespace) {
        Symbol s = namespace.getSymbol();
        if (s.getSymbolType() != SymbolType.NAMESPACE) {
            return false;
        }
        for (Namespace n = namespace; n != null; n = n.getParentNamespace()) {
            if (!(n instanceof Function)) continue;
            return false;
        }
        return true;
    }

    private void storeLabelByAddress(Address address, String label) {
        Set<String> labels = this.labelsByAddress.get(address);
        if (labels == null) {
            labels = new TreeSet<String>();
            this.labelsByAddress.put(address, labels);
        }
        if (labels.contains(label)) {
            // empty if block
        }
        labels.add(label);
    }

    private void dumpLabels() {
        for (Map.Entry<Address, Set<String>> entry : this.labelsByAddress.entrySet()) {
            Address address = entry.getKey();
            Set<String> labels = entry.getValue();
            System.out.println("\nAddress: " + address);
            for (String label : labels) {
                System.out.println(label);
            }
        }
    }

    boolean shouldForcePrimarySymbol(Address address, boolean forceIfMangled) {
        Symbol primarySymbol = this.program.getSymbolTable().getPrimarySymbol(address);
        if (primarySymbol != null) {
            if (primarySymbol.getName().startsWith("?") && forceIfMangled && this.applicatorOptions.allowDemotePrimaryMangledSymbols()) {
                return true;
            }
            SourceType primarySymbolSource = primarySymbol.getSource();
            if (!SourceType.ANALYSIS.isHigherPriorityThan(primarySymbolSource)) {
                return true;
            }
        }
        return false;
    }

    boolean createSymbolOld(Address address, String symbolPathString, boolean forcePrimary) {
        try {
            Symbol s;
            Namespace namespace = this.program.getGlobalNamespace();
            if (symbolPathString.startsWith(THUNK_NAME_PREFIX)) {
                symbolPathString = symbolPathString.substring(THUNK_NAME_PREFIX.length(), symbolPathString.length());
            }
            SymbolPath symbolPath = new SymbolPath(symbolPathString);
            symbolPath = symbolPath.replaceInvalidChars();
            String name = symbolPath.getName();
            String namespacePath = symbolPath.getParentPath();
            if (namespacePath != null) {
                namespace = NamespaceUtils.createNamespaceHierarchy((String)namespacePath, (Namespace)namespace, (Program)this.program, (Address)address, (SourceType)SourceType.IMPORTED);
            }
            if ((s = SymbolUtilities.createPreferredLabelOrFunctionSymbol((Program)this.program, (Address)address, (Namespace)namespace, (String)name, (SourceType)SourceType.IMPORTED)) != null && forcePrimary) {
                SetLabelPrimaryCmd cmd = new SetLabelPrimaryCmd(address, s.getName(), s.getParentNamespace());
                cmd.applyTo((DomainObject)this.program);
            }
            return true;
        }
        catch (InvalidInputException e) {
            this.log.appendMsg("PDB Warning: Unable to create symbol: " + e.getMessage());
            return false;
        }
    }

    Symbol createSymbol(Address address, String symbolPathString, boolean forcePrimaryIfExistingIsMangled) {
        SetLabelPrimaryCmd cmd;
        PrimarySymbolInfo existingPrimarySymbolInfo = this.getExistingPrimarySymbolInfo(address);
        Symbol newSymbol = this.createSymbol(address, symbolPathString);
        if (newSymbol == null) {
            return null;
        }
        boolean forcePrimary = false;
        if (existingPrimarySymbolInfo != null && existingPrimarySymbolInfo.canBePrimaryForceOverriddenBy(symbolPathString) && forcePrimaryIfExistingIsMangled && this.applicatorOptions.allowDemotePrimaryMangledSymbols()) {
            forcePrimary = true;
        }
        boolean forcePrimarySucceeded = false;
        if (forcePrimary && (cmd = new SetLabelPrimaryCmd(address, newSymbol.getName(), newSymbol.getParentNamespace())).applyTo((DomainObject)this.program)) {
            forcePrimarySucceeded = true;
        }
        if (existingPrimarySymbolInfo == null || forcePrimarySucceeded) {
            PrimarySymbolInfo primarySymbolInfo = new PrimarySymbolInfo(newSymbol, true);
            this.setExistingPrimarySymbolInfo(address, primarySymbolInfo);
        }
        return newSymbol;
    }

    private static boolean isMangled(String name) {
        return name.startsWith("?");
    }

    private void setExistingPrimarySymbolInfo(Address address, PrimarySymbolInfo info) {
        this.primarySymbolInfoByAddress.put(address, info);
    }

    private PrimarySymbolInfo getExistingPrimarySymbolInfo(Address address) {
        PrimarySymbolInfo info = this.primarySymbolInfoByAddress.get(address);
        if (info != null) {
            return info;
        }
        Symbol primarySymbol = this.pdbAddressManager.getPrimarySymbol(address);
        if (primarySymbol == null || primarySymbol.getSource().isLowerPriorityThan(SourceType.IMPORTED)) {
            return null;
        }
        info = new PrimarySymbolInfo(primarySymbol, false);
        this.primarySymbolInfoByAddress.put(address, info);
        return info;
    }

    private Symbol createSymbol(Address address, String symbolPathString) {
        Symbol symbol = null;
        try {
            Namespace namespace = this.program.getGlobalNamespace();
            if (symbolPathString.startsWith(THUNK_NAME_PREFIX)) {
                symbolPathString = symbolPathString.substring(THUNK_NAME_PREFIX.length(), symbolPathString.length());
            }
            SymbolPath symbolPath = new SymbolPath(symbolPathString);
            symbolPath = symbolPath.replaceInvalidChars();
            String name = symbolPath.getName();
            String namespacePath = symbolPath.getParentPath();
            if (namespacePath != null) {
                namespace = NamespaceUtils.createNamespaceHierarchy((String)namespacePath, (Namespace)namespace, (Program)this.program, (Address)address, (SourceType)SourceType.IMPORTED);
            }
            symbol = this.program.getSymbolTable().createLabel(address, name, namespace, SourceType.IMPORTED);
        }
        catch (InvalidInputException e) {
            this.log.appendMsg("PDB Warning: Unable to create symbol at " + address + " due to exception: " + e.toString() + "; symbolPathName: " + symbolPathString);
        }
        return symbol;
    }

    private static class PrimarySymbolInfo {
        private Symbol symbol;
        private boolean isNewSymbol;

        private PrimarySymbolInfo(Symbol symbol, boolean isNewSymbol) {
            this.symbol = symbol;
            this.isNewSymbol = isNewSymbol;
        }

        private boolean canBePrimaryForceOverriddenBy(String newName) {
            if (this.getSource().isLowerPriorityThan(SourceType.IMPORTED)) {
                return true;
            }
            if (this.isMangled() && !PdbApplicator.isMangled(newName)) {
                return true;
            }
            if (this.isNewSymbol()) {
                return false;
            }
            return false;
        }

        private SourceType getSource() {
            return this.symbol.getSource();
        }

        private boolean isMangled() {
            return this.symbol.getName().startsWith("?");
        }

        private boolean isNewSymbol() {
            return this.isNewSymbol;
        }
    }
}

