/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver.ui;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import java.util.List;
import pdb.symbolserver.SymbolServer;
import pdb.symbolserver.SymbolServerInstanceCreatorRegistry;
import pdb.symbolserver.SymbolServerService;
import pdb.symbolserver.ui.SymbolServerPanel;

public class ConfigPdbDialog
extends DialogComponentProvider {
    private SymbolServerPanel symbolServerConfigPanel;
    private boolean wasSuccess;

    public static boolean showSymbolServerConfig() {
        ConfigPdbDialog choosePdbDialog = new ConfigPdbDialog();
        DockingWindowManager.showDialog((DialogComponentProvider)choosePdbDialog);
        return choosePdbDialog.wasSuccess;
    }

    public ConfigPdbDialog() {
        super("Configure Symbol Server Search", true, false, true, false);
        this.build();
    }

    protected void cancelCallback() {
        this.close();
    }

    protected void okCallback() {
        if (this.symbolServerConfigPanel.isConfigChanged()) {
            this.symbolServerConfigPanel.saveConfig();
        }
        this.wasSuccess = true;
        this.close();
    }

    private void build() {
        this.symbolServerConfigPanel = new SymbolServerPanel(this::onSymbolServerServiceChange, SymbolServerInstanceCreatorRegistry.getInstance().getContext());
        this.addButtons();
        this.addWorkPanel(this.symbolServerConfigPanel);
        this.setRememberSize(false);
        this.okButton.setEnabled(this.symbolServerConfigPanel.getSymbolServerService() != null);
        this.setMinimumSize(400, 250);
    }

    private void onSymbolServerServiceChange(SymbolServerService newService) {
        this.okButton.setEnabled(newService != null);
        this.rootPanel.revalidate();
    }

    private void addButtons() {
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.cancelButton);
    }

    public void pushAddLocationButton() {
        this.symbolServerConfigPanel.pushAddLocationButton();
    }

    public void setSymbolServerService(String fakeDirectoryText, List<SymbolServer> symbolServers) {
        this.symbolServerConfigPanel.setSymbolServers(symbolServers);
        this.symbolServerConfigPanel.setSymbolStorageDirectoryTextOnly(fakeDirectoryText);
    }
}

