/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractWeakValueMap<K, V>
implements Map<K, V> {
    protected ReferenceQueue<V> refQueue = new ReferenceQueue();

    protected AbstractWeakValueMap() {
    }

    protected abstract Map<K, WeakValueRef<K, V>> getRefMap();

    @Override
    public V put(K key, V value) {
        this.processQueue();
        WeakValueRef<K, V> ref = new WeakValueRef<K, V>(key, value, this.refQueue);
        WeakValueRef<K, V> oldRef = this.getRefMap().put(key, ref);
        if (oldRef != null) {
            return (V)oldRef.get();
        }
        return null;
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        WeakValueRef<K, V> ref = this.getRefMap().get(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    @Override
    public int size() {
        this.processQueue();
        return this.getRefMap().size();
    }

    @Override
    public void clear() {
        this.getRefMap().clear();
        this.refQueue = new ReferenceQueue();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.getRefMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.getRefMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.processQueue();
        for (WeakValueRef<K, V> ref : this.getRefMap().values()) {
            if (!value.equals(ref.get())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> values() {
        ArrayList list = new ArrayList(this.getRefMap().size());
        for (WeakValueRef<K, V> ref : this.getRefMap().values()) {
            Object value = ref.get();
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (K key : map.keySet()) {
            V value = map.get(key);
            if (value == null) continue;
            this.put(key, value);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        HashSet<Map.Entry<K, V>> list = new HashSet<Map.Entry<K, V>>();
        Set<Map.Entry<K, WeakValueRef<K, V>>> entrySet = this.getRefMap().entrySet();
        for (Map.Entry<K, WeakValueRef<K, V>> next : entrySet) {
            WeakValueRef<K, V> valueRef = next.getValue();
            Object value = valueRef.get();
            if (value == null) continue;
            list.add(new GeneratedEntry(next.getKey(), value));
        }
        return list;
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.getRefMap().keySet();
    }

    @Override
    public V remove(Object key) {
        WeakValueRef<K, V> ref = this.getRefMap().remove(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    protected void processQueue() {
        WeakValueRef ref;
        while ((ref = (WeakValueRef)this.refQueue.poll()) != null) {
            this.getRefMap().remove(ref.key);
        }
    }

    protected static class WeakValueRef<K, V>
    extends WeakReference<V> {
        K key;

        WeakValueRef(K key, V value, ReferenceQueue<V> refQueue) {
            super(value, refQueue);
            this.key = key;
        }
    }

    protected class GeneratedEntry
    implements Map.Entry<K, V> {
        K key;
        V value;

        GeneratedEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return AbstractWeakValueMap.this.put(this.key, value);
        }
    }
}

