/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import com.google.common.collect.Range;
import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.debug.gui.DebuggerProvider;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerAddMappingDialog;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerStaticMappingActionContext;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerStaticMappingPlugin;
import ghidra.app.plugin.core.debug.gui.modules.StaticMappingRow;
import ghidra.app.plugin.core.debug.utils.DebouncedRowWrappedEnumeratedColumnTableModel;
import ghidra.app.services.CodeViewerService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceObject;
import ghidra.trace.model.modules.TraceStaticMapping;
import ghidra.trace.model.modules.TraceStaticMappingManager;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.MathUtilities;
import ghidra.util.Msg;
import ghidra.util.database.ObjectKey;
import ghidra.util.database.UndoableTransaction;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DebuggerStaticMappingProvider
extends ComponentProviderAdapter
implements DebuggerProvider {
    private final DebuggerStaticMappingPlugin plugin;
    private final DebuggerAddMappingDialog addMappingDialog;
    @AutoServiceConsumed
    private DebuggerStaticMappingService mappingService;
    @AutoServiceConsumed
    private CodeViewerService codeViewerService;
    @AutoServiceConsumed
    private DebuggerListingService listingService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private final AutoService.Wiring autoWiring;
    private Trace currentTrace;
    private ListenerForStaticMappingDisplay listener = new ListenerForStaticMappingDisplay();
    protected final MappingTableModel mappingTableModel = new MappingTableModel();
    private JPanel mainPanel = new JPanel(new BorderLayout());
    protected GTable mappingTable;
    private GhidraTableFilterPanel<StaticMappingRow> mappingFilterPanel;
    DockingAction actionAdd;
    DockingAction actionRemove;
    DockingAction actionSelectCurrent;
    ActionContext myActionContext;

    public DebuggerStaticMappingProvider(DebuggerStaticMappingPlugin plugin) {
        super(plugin.getTool(), "Static Mappings", plugin.getName(), null);
        this.plugin = plugin;
        this.addMappingDialog = new DebuggerAddMappingDialog();
        this.autoWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)this);
        this.setIcon(DebuggerResources.ICON_PROVIDER_MAPPINGS);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_MAPPINGS);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.setVisible(true);
        this.createActions();
    }

    @AutoServiceConsumed
    private void setMappingService(DebuggerStaticMappingService mappingService) {
        this.addMappingDialog.setMappingService(mappingService);
    }

    @Override
    public void addLocalAction(DockingActionIf action) {
        super.addLocalAction(action);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    @Override
    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    private void loadMappings() {
        this.mappingTableModel.clear();
        if (this.currentTrace == null) {
            return;
        }
        TraceStaticMappingManager manager = this.currentTrace.getStaticMappingManager();
        this.mappingTableModel.addAllItems(manager.getAllEntries());
    }

    protected void buildMainPanel() {
        this.mappingTable = new GTable((TableModel)((Object)this.mappingTableModel));
        this.mainPanel.add(new JScrollPane((Component)this.mappingTable));
        this.mappingFilterPanel = new GhidraTableFilterPanel((JTable)this.mappingTable, (RowObjectTableModel)this.mappingTableModel);
        this.mainPanel.add((Component)this.mappingFilterPanel, "South");
        this.mappingTable.getSelectionModel().addListSelectionListener(evt -> {
            this.myActionContext = new DebuggerStaticMappingActionContext(this, this.mappingFilterPanel.getSelectedItems(), this.mappingTable);
            this.contextChanged();
        });
        TableColumnModel columnModel = this.mappingTable.getColumnModel();
        TableColumn dynAddrCol = columnModel.getColumn(StaticMappingTableColumns.DYNAMIC_ADDRESS.ordinal());
        dynAddrCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn statAddrCol = columnModel.getColumn(StaticMappingTableColumns.STATIC_ADDRESS.ordinal());
        statAddrCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn lengthCol = columnModel.getColumn(StaticMappingTableColumns.LENGTH.ordinal());
        lengthCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_BIG_HEX);
        TableColumn shiftCol = columnModel.getColumn(StaticMappingTableColumns.SHIFT.ordinal());
        shiftCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_LONG_HEX);
    }

    protected void createActions() {
        this.actionAdd = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.AddAction.builder(this.plugin).description("Add Mapping from Listing Selections")).onAction(this::activatedAdd)).buildAndInstallLocal((ComponentProvider)this);
        this.actionRemove = (DockingAction)DebuggerResources.RemoveAction.builder(this.plugin).withContext(DebuggerStaticMappingActionContext.class).enabledWhen(ctx -> !ctx.getSelectedMappings().isEmpty()).onAction(this::activatedRemove).buildAndInstallLocal((ComponentProvider)this);
        this.actionSelectCurrent = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)DebuggerResources.SelectRowsAction.builder(this.plugin).description("Select mappings by trace selection")).enabledWhen(ctx -> this.currentTrace != null)).onAction(this::activatedSelectCurrent)).buildAndInstallLocal((ComponentProvider)this);
        this.contextChanged();
    }

    private void activatedAdd(ActionContext ignore) {
        long traceLen;
        this.tool.showDialog((DialogComponentProvider)this.addMappingDialog);
        if (this.codeViewerService == null || this.listingService == null) {
            return;
        }
        ProgramLocation progLoc = this.codeViewerService.getCurrentLocation();
        ProgramLocation traceLoc = this.listingService.getCurrentLocation();
        if (progLoc == null || traceLoc == null) {
            return;
        }
        ProgramSelection progSel = this.codeViewerService.getCurrentSelection();
        ProgramSelection traceSel = this.listingService.getCurrentSelection();
        if (progSel != null && progSel.getNumAddressRanges() > 1) {
            return;
        }
        if (traceSel != null && traceSel.getNumAddressRanges() > 1) {
            return;
        }
        long progLen = progSel == null ? 0L : progSel.getNumAddresses();
        long l = traceLen = traceSel == null ? 0L : traceSel.getNumAddresses();
        if (progLen == 0L && traceLen == 0L) {
            return;
        }
        long length = progLen == 0L ? traceLen : (traceLen == 0L ? progLen : MathUtilities.unsignedMin((long)progLen, (long)traceLen));
        Address progStart = progLen != 0L ? progSel.getMinAddress() : progLoc.getAddress();
        Address traceStart = traceLen != 0L ? traceSel.getMinAddress() : traceLoc.getAddress();
        TraceProgramView view = (TraceProgramView)traceLoc.getProgram();
        try {
            this.addMappingDialog.setValues(progLoc.getProgram(), this.currentTrace, progStart, traceStart, length, (Range<Long>)Range.atLeast((Comparable)Long.valueOf(view.getSnap())));
        }
        catch (AddressOverflowException e) {
            Msg.showError((Object)this, null, (String)"Add Mapping", (Object)"Error populating dialog");
        }
    }

    private void activatedRemove(DebuggerStaticMappingActionContext ctx) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.currentTrace, (String)"Remove Static Mappings", (boolean)false);){
            for (StaticMappingRow mapping : ctx.getSelectedMappings()) {
                mapping.getMapping().delete();
            }
            tid.commit();
        }
    }

    private void activatedSelectCurrent(ActionContext ignored) {
        TraceStaticMapping mapping;
        if (this.listingService == null || this.traceManager == null || this.currentTrace == null) {
            return;
        }
        ProgramSelection progSel = this.listingService.getCurrentSelection();
        TraceStaticMappingManager mappingManager = this.currentTrace.getStaticMappingManager();
        if (progSel != null && !progSel.isEmpty()) {
            HashSet<TraceStaticMapping> mappingSel = new HashSet<TraceStaticMapping>();
            for (AddressRange range : progSel) {
                mappingSel.addAll(mappingManager.findAllOverlapping(range, Range.singleton((Comparable)Long.valueOf(this.traceManager.getCurrentSnap()))));
            }
            this.setSelectedMappings(mappingSel);
            return;
        }
        ProgramLocation progLoc = this.listingService.getCurrentLocation();
        if (progLoc != null && (mapping = mappingManager.findContaining(progLoc.getAddress(), this.traceManager.getCurrentSnap())) != null) {
            this.setSelectedMappings(Set.of(mapping));
            return;
        }
    }

    public void setSelectedMappings(Set<TraceStaticMapping> sel) {
        DebuggerResources.setSelectedRows(sel, StaticMappingRow::getMapping, this.mappingTable, this.mappingFilterPanel);
    }

    private void removeOldListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.listener);
    }

    private void addNewListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.listener);
    }

    public void setTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.removeOldListeners();
        this.currentTrace = trace;
        this.addNewListeners();
        this.loadMappings();
        this.addMappingDialog.setTrace(trace);
    }

    public void setProgram(Program program) {
        this.addMappingDialog.setProgram(program);
    }

    protected class ListenerForStaticMappingDisplay
    extends TraceDomainObjectListener {
        public ListenerForStaticMappingDisplay() {
            this.listenForUntyped(4, e -> this.objectRestored());
            this.listenFor((TraceChangeType)Trace.TraceStaticMappingChangeType.ADDED, this::staticMappingAdded);
            this.listenFor((TraceChangeType)Trace.TraceStaticMappingChangeType.DELETED, this::staticMappingDeleted);
        }

        private void objectRestored() {
            DebuggerStaticMappingProvider.this.loadMappings();
        }

        private void staticMappingAdded(TraceStaticMapping mapping) {
            DebuggerStaticMappingProvider.this.mappingTableModel.addItem(mapping);
        }

        private void staticMappingDeleted(TraceStaticMapping mapping) {
            DebuggerStaticMappingProvider.this.mappingTableModel.deleteItem(mapping);
        }
    }

    protected static class MappingTableModel
    extends DebouncedRowWrappedEnumeratedColumnTableModel<StaticMappingTableColumns, ObjectKey, StaticMappingRow, TraceStaticMapping> {
        public MappingTableModel() {
            super("Mappings", StaticMappingTableColumns.class, TraceObject::getObjectKey, StaticMappingRow::new);
        }
    }

    protected static enum StaticMappingTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<StaticMappingTableColumns, StaticMappingRow>
    {
        DYNAMIC_ADDRESS("Dynamic Address", Address.class, StaticMappingRow::getTraceAddress),
        STATIC_URL("Static Program", URL.class, StaticMappingRow::getStaticProgramURL),
        STATIC_ADDRESS("Static Address", String.class, StaticMappingRow::getStaticAddress),
        LENGTH("Length", BigInteger.class, StaticMappingRow::getBigLength),
        SHIFT("Shift", Long.class, StaticMappingRow::getShift),
        LIFESPAN("Lifespan", Range.class, StaticMappingRow::getLifespan);

        private final String header;
        private final Class<?> cls;
        private final Function<StaticMappingRow, ?> getter;

        private <T> StaticMappingTableColumns(String header, Class<T> cls, Function<StaticMappingRow, T> getter) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(StaticMappingRow row) {
            return this.getter.apply(row);
        }

        public String getHeader() {
            return this.header;
        }
    }
}

