/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.register;

import ghidra.app.plugin.core.debug.gui.register.DebuggerRegistersProvider;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Register;
import ghidra.util.Msg;
import java.math.BigInteger;

public class RegisterRow {
    private final DebuggerRegistersProvider provider;
    private boolean favorite;
    private final int number;
    private final Register register;

    public RegisterRow(DebuggerRegistersProvider provider, int number, Register register) {
        this.provider = provider;
        this.number = number;
        this.register = register;
        this.favorite = provider.isFavorite(register);
    }

    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
        this.provider.setFavorite(this.register, favorite);
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public int getNumber() {
        return this.number;
    }

    public Register getRegister() {
        return this.register;
    }

    public String getName() {
        return this.register.getName();
    }

    public boolean isValueEditable() {
        return this.provider.canWriteRegister(this.register);
    }

    public void setValue(BigInteger value) {
        try {
            this.provider.writeRegisterValue(this.register, value);
        }
        catch (Throwable t) {
            Msg.showError((Object)this, null, (String)"Cannot edit Register Value", (Object)t.getMessage(), (Throwable)t);
        }
    }

    public BigInteger getValue() {
        return this.provider.getRegisterValue(this.register);
    }

    public void setDataType(DataType dataType) {
        this.provider.writeRegisterDataType(this.register, dataType);
    }

    public DataType getDataType() {
        return this.provider.getRegisterDataType(this.register);
    }

    public String getRepresentation() {
        return this.provider.getRegisterValueRepresentation(this.register);
    }

    public boolean isKnown() {
        return this.provider.isRegisterKnown(this.register);
    }

    public boolean isChanged() {
        return this.provider.isRegisterChanged(this.register);
    }
}

