/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.time;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ToggleActionBuilder;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.DebuggerSnapActionContext;
import ghidra.app.plugin.core.debug.gui.time.DebuggerSnapshotTablePanel;
import ghidra.app.plugin.core.debug.gui.time.DebuggerTimePlugin;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import javax.swing.JComponent;

public class DebuggerTimeProvider
extends ComponentProviderAdapter {
    private static final AutoConfigState.ClassHandler<DebuggerTimeProvider> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerTimeProvider.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final DebuggerTimePlugin plugin;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    @AutoServiceConsumed
    protected DebuggerTraceManagerService viewManager;
    private final AutoService.Wiring autoServiceWiring;
    final DebuggerSnapshotTablePanel mainPanel = new DebuggerSnapshotTablePanel();
    private DebuggerSnapActionContext myActionContext;
    ToggleDockingAction actionHideScratch;
    @AutoConfigStateField
    boolean hideScratch = true;

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getTrace(), b.getTrace())) {
            return false;
        }
        return Objects.equals(a.getTime(), b.getTime());
    }

    public DebuggerTimeProvider(DebuggerTimePlugin plugin) {
        super(plugin.getTool(), "Time", plugin.getName());
        this.plugin = plugin;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.setTitle("Time");
        this.setIcon(DebuggerResources.ICON_PROVIDER_TIME);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_TIME);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.myActionContext = new DebuggerSnapActionContext(this.current.getTrace(), this.current.getSnap());
        this.createActions();
        this.contextChanged();
        this.setVisible(true);
    }

    public void addLocalAction(DockingActionIf action) {
        super.addLocalAction(action);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    protected void buildMainPanel() {
        this.mainPanel.getSelectionModel().addListSelectionListener(evt -> {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            Long snap = this.mainPanel.getSelectedSnapshot();
            if (snap == null) {
                this.myActionContext = null;
                return;
            }
            if (snap.longValue() == this.current.getSnap().longValue()) {
                return;
            }
            this.myActionContext = new DebuggerSnapActionContext(this.current.getTrace(), snap);
            this.viewManager.activateSnap(snap);
            this.contextChanged();
        });
    }

    protected void createActions() {
        this.actionHideScratch = (ToggleDockingAction)((ToggleActionBuilder)DebuggerResources.HideScratchSnapshotsAction.builder(this.plugin).selected(this.hideScratch).onAction(this::activatedHideScratch)).buildAndInstallLocal((ComponentProvider)this);
    }

    private void activatedHideScratch(ActionContext ctx) {
        this.hideScratch = !this.hideScratch;
        this.mainPanel.setHideScratchSnapshots(this.hideScratch);
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        if (DebuggerTimeProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        this.current = coordinates;
        this.mainPanel.setTrace(this.current.getTrace());
        this.mainPanel.setSelectedSnapshot(this.current.getSnap());
    }

    public void writeConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
    }

    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        this.actionHideScratch.setSelected(this.hideScratch);
        this.mainPanel.setHideScratchSnapshots(this.hideScratch);
    }
}

