/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOffer;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetEnvironment;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.program.model.lang.Endian;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.classfinder.ExtensionPoint;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public interface DebuggerMappingOpinion
extends ExtensionPoint {
    public static final Comparator<DebuggerMappingOffer> HIGHEST_CONFIDENCE_FIRST = Comparator.comparing(o -> -o.getConfidence());

    public static Endian getEndian(TargetEnvironment env) {
        String strEndian = env.getEndian();
        if (strEndian.contains("little")) {
            return Endian.LITTLE;
        }
        if (strEndian.contains("big")) {
            return Endian.BIG;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DebuggerMappingOffer> queryOpinions(TargetObject target, boolean includeOverrides) {
        ArrayList<DebuggerMappingOffer> result = new ArrayList<DebuggerMappingOffer>();
        for (DebuggerMappingOpinion opinion : ClassSearcher.getInstances(DebuggerMappingOpinion.class)) {
            try {
                Set<DebuggerMappingOffer> offers = opinion.getOffers(target, includeOverrides);
                ArrayList<DebuggerMappingOffer> arrayList = result;
                synchronized (arrayList) {
                    result.addAll(offers);
                }
            }
            catch (Throwable t) {
                Msg.error(DebuggerMappingOpinion.class, (Object)("Problem querying opinion " + opinion + " for recording/mapping offers: " + t));
            }
        }
        result.sort(HIGHEST_CONFIDENCE_FIRST);
        return result;
    }

    default public Set<DebuggerMappingOffer> getOffers(TargetObject target, boolean includeOverrides) {
        if (!(target instanceof TargetProcess)) {
            return Set.of();
        }
        TargetProcess process = (TargetProcess)target;
        DebuggerObjectModel model = process.getModel();
        List pathToEnv = model.getRootSchema().searchForSuitable(TargetEnvironment.class, process.getPath());
        if (pathToEnv == null) {
            Msg.error((Object)this, (Object)"Could not find path to environment");
            return Set.of();
        }
        TargetEnvironment env = (TargetEnvironment)model.getModelObject(pathToEnv);
        return this.offersForEnv(env, process, includeOverrides);
    }

    public Set<DebuggerMappingOffer> offersForEnv(TargetEnvironment var1, TargetProcess var2, boolean var3);
}

