/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.app.plugin.core.debug.mapping.DebuggerMemoryMapper;
import ghidra.app.plugin.core.debug.mapping.DebuggerRegisterMapper;
import ghidra.app.plugin.core.debug.mapping.DebuggerTargetTraceMapper;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerMemoryMapper;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerRegisterMapper;
import ghidra.app.plugin.core.debug.service.model.DebuggerModelServicePlugin;
import ghidra.app.plugin.core.debug.service.model.DefaultTraceRecorder;
import ghidra.app.services.TraceRecorder;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.util.DefaultLanguageService;
import ghidra.trace.model.Trace;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class DefaultDebuggerTargetTraceMapper
implements DebuggerTargetTraceMapper {
    protected final TargetObject target;
    protected final Language language;
    protected final CompilerSpec cSpec;
    protected final Set<String> extraRegNames;

    public DefaultDebuggerTargetTraceMapper(TargetObject target, LanguageID langID, CompilerSpecID csId, Collection<String> extraRegNames) throws LanguageNotFoundException, CompilerSpecNotFoundException {
        this.target = target;
        LanguageService langServ = DefaultLanguageService.getLanguageService();
        this.language = langServ.getLanguage(langID);
        this.cSpec = this.language.getCompilerSpecByID(csId);
        this.extraRegNames = Set.copyOf(extraRegNames);
    }

    protected DebuggerMemoryMapper createMemoryMapper(TargetMemory memory) {
        return new DefaultDebuggerMemoryMapper(this.language, memory.getModel());
    }

    protected DebuggerRegisterMapper createRegisterMapper(TargetRegisterContainer registers) {
        return new DefaultDebuggerRegisterMapper(this.cSpec, registers, false);
    }

    public CompletableFuture<DebuggerMemoryMapper> offerMemory(TargetMemory memory) {
        DebuggerMemoryMapper mm = this.createMemoryMapper(memory);
        return CompletableFuture.completedFuture(mm);
    }

    public CompletableFuture<DebuggerRegisterMapper> offerRegisters(TargetRegisterContainer registers) {
        DebuggerRegisterMapper rm = this.createRegisterMapper(registers);
        return CompletableFuture.completedFuture(rm);
    }

    public Set<String> getExtraRegNames() {
        return this.extraRegNames;
    }

    @Override
    public Language getTraceLanguage() {
        return this.language;
    }

    @Override
    public CompilerSpec getTraceCompilerSpec() {
        return this.cSpec;
    }

    @Override
    public TraceRecorder startRecording(DebuggerModelServicePlugin service, Trace trace) {
        return new DefaultTraceRecorder(service, trace, this.target, this);
    }
}

