/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation;

import ghidra.app.plugin.core.debug.service.emulation.AbstractReadsTargetPcodeExecutorState;
import ghidra.app.services.TraceRecorder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import java.util.HashSet;

public class ReadsTargetRegistersPcodeExecutorState
extends AbstractReadsTargetPcodeExecutorState {
    public ReadsTargetRegistersPcodeExecutorState(PluginTool tool, Trace trace, long snap, TraceThread thread, int frame, TraceRecorder recorder) {
        super(tool, trace, snap, thread, frame, recorder);
    }

    @Override
    protected AbstractReadsTargetPcodeExecutorState.AbstractReadsTargetCachedSpace createCachedSpace(AddressSpace s, TraceMemorySpace tms) {
        return new ReadsTargetRegistersCachedSpace(this.language, s, tms, this.snap);
    }

    protected class ReadsTargetRegistersCachedSpace
    extends AbstractReadsTargetPcodeExecutorState.AbstractReadsTargetCachedSpace {
        public ReadsTargetRegistersCachedSpace(Language language, AddressSpace space, TraceMemorySpace source, long snap) {
            super(ReadsTargetRegistersPcodeExecutorState.this, language, space, source, snap);
        }

        @Override
        protected void fillUninitialized(AddressSet uninitialized) {
            if (!this.isLive()) {
                return;
            }
            AddressSet unknown = this.computeUnknown(uninitialized);
            HashSet<Register> toRead = new HashSet<Register>();
            for (AddressRange rng : unknown) {
                Register register = this.language.getRegister(rng.getMinAddress(), (int)rng.getLength());
                if (register == null) {
                    Msg.error((Object)((Object)this), (Object)("Could not figure register for " + rng));
                    continue;
                }
                if (!ReadsTargetRegistersPcodeExecutorState.this.recorder.getRegisterMapper(ReadsTargetRegistersPcodeExecutorState.this.thread).getRegistersOnTarget().contains(register)) {
                    Msg.warn((Object)((Object)this), (Object)("Register not recognized by target: " + register));
                    continue;
                }
                toRead.add(register);
            }
            this.waitTimeout(ReadsTargetRegistersPcodeExecutorState.this.recorder.captureThreadRegisters(ReadsTargetRegistersPcodeExecutorState.this.thread, 0, toRead));
        }
    }
}

